/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.mixin;

import com.falsepattern.lib.mixin.IMixin;
import com.falsepattern.lib.mixin.ITargetedMod;
import com.falsepattern.lib.mixin.MinecraftURLClassPath;
import com.falsepattern.lib.util.FileUtil;
import java.io.File;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public interface IMixinPlugin
extends IMixinConfigPlugin {
    public static final Path MODS_DIRECTORY_PATH = FileUtil.getMinecraftHome().toPath().resolve("mods");

    public static Logger createLogger(String modName) {
        return LogManager.getLogger((String)(modName + " Mixin Loader"));
    }

    @Deprecated
    public static File findJarOf(ITargetedMod mod) {
        File result = null;
        try (Stream<Path> stream = Files.walk(MODS_DIRECTORY_PATH, new FileVisitOption[0]);){
            result = stream.filter(mod::isMatchingJar).map(Path::toFile).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result == null) {
            File found = null;
            for (URL url : Launch.classLoader.getURLs()) {
                try {
                    File file = new File(url.toURI());
                    Path path = file.toPath();
                    if (!mod.isMatchingJar(path)) continue;
                    found = file;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result = found;
        }
        return result;
    }

    public static Set<File> findJarsOf(IMixinPlugin self, ITargetedMod mod) {
        if (!self.useNewFindJar()) {
            File jar = IMixinPlugin.findJarOf(mod);
            return jar == null ? Collections.emptySet() : Collections.singleton(jar);
        }
        HashSet<File> results = new HashSet<File>();
        try (Stream<Path> stream = Files.walk(MODS_DIRECTORY_PATH, new FileVisitOption[0]);){
            results.addAll(stream.filter(mod::isMatchingJar).map(Path::toFile).collect(Collectors.toSet()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (URL url : Launch.classLoader.getURLs()) {
            try {
                File file = new File(url.toURI());
                Path path = file.toPath();
                if (!mod.isMatchingJar(path)) continue;
                results.add(file);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return results;
    }

    public Logger getLogger();

    public IMixin[] getMixinEnumValues();

    public ITargetedMod[] getTargetedModEnumValues();

    default public boolean useNewFindJar() {
        return false;
    }

    @ApiStatus.Internal
    default public void onLoad(String mixinPackage) {
    }

    @ApiStatus.Internal
    default public String getRefMapperConfig() {
        return null;
    }

    @ApiStatus.Internal
    default public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    @ApiStatus.Internal
    default public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @ApiStatus.Internal
    default public List<String> getMixins() {
        final boolean isDevelopmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        ITargetedMod[] targetedMods = this.getTargetedModEnumValues();
        List<ITargetedMod> loadedMods = Arrays.stream(targetedMods).filter(new Predicate<ITargetedMod>(){

            @Override
            public boolean test(ITargetedMod mod) {
                boolean loadJar = IMixinPlugin.this.loadJarOf(mod);
                return mod.isLoadInDevelopment() && isDevelopmentEnvironment || loadJar;
            }
        }).collect(Collectors.toList());
        for (ITargetedMod mod : targetedMods) {
            if (loadedMods.contains(mod)) {
                this.getLogger().info("Found " + mod.getModName() + "! Integrating now...");
                continue;
            }
            this.getLogger().info("Could not find " + mod.getModName() + "! Skipping integration....");
        }
        ArrayList<String> mixins = new ArrayList<String>();
        for (IMixin mixin : this.getMixinEnumValues()) {
            if (!mixin.shouldLoad(loadedMods)) continue;
            String mixinClass = mixin.getSide().name().toLowerCase() + "." + mixin.getMixin();
            mixins.add(mixinClass);
            this.getLogger().info("Loading mixin: " + mixinClass);
        }
        return mixins;
    }

    @ApiStatus.Internal
    default public boolean loadJarOf(ITargetedMod mod) {
        try {
            Set<File> jars = IMixinPlugin.findJarsOf(this, mod);
            if (jars.isEmpty()) {
                this.getLogger().info("Jar not found for {}", new Object[]{mod});
                return false;
            }
            for (File jar : jars) {
                this.getLogger().info("Attempting to add {} to the URL Class Path", new Object[]{jar});
                try {
                    MinecraftURLClassPath.addJar(jar);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return true;
    }

    @ApiStatus.Internal
    default public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @ApiStatus.Internal
    default public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

