/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.client;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.client.entityfx.ParticleProviderLink;
import com.xcompwiz.mystcraft.client.entityfx.ParticleUtils;
import com.xcompwiz.mystcraft.client.gui.overlay.GuiNotification;
import com.xcompwiz.mystcraft.client.linkeffects.LinkRendererDisarm;
import com.xcompwiz.mystcraft.client.model.ModelBookBinder;
import com.xcompwiz.mystcraft.client.model.ModelInkMixer;
import com.xcompwiz.mystcraft.client.model.ModelLinkModifier;
import com.xcompwiz.mystcraft.client.render.ItemRendererMask;
import com.xcompwiz.mystcraft.client.render.ItemRendererPage;
import com.xcompwiz.mystcraft.client.render.ItemRendererTileEntity;
import com.xcompwiz.mystcraft.client.render.RenderBookReceptacle;
import com.xcompwiz.mystcraft.client.render.RenderBookstand;
import com.xcompwiz.mystcraft.client.render.RenderFallingBlock;
import com.xcompwiz.mystcraft.client.render.RenderLectern;
import com.xcompwiz.mystcraft.client.render.RenderLightningBoltAdv;
import com.xcompwiz.mystcraft.client.render.RenderLinkbook;
import com.xcompwiz.mystcraft.client.render.RenderMeteor;
import com.xcompwiz.mystcraft.client.render.RenderModel;
import com.xcompwiz.mystcraft.client.render.RenderStarFissure;
import com.xcompwiz.mystcraft.client.render.RenderWritingDesk;
import com.xcompwiz.mystcraft.client.shaders.ShaderUtils;
import com.xcompwiz.mystcraft.core.MystcraftCommonProxy;
import com.xcompwiz.mystcraft.data.Assets;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.data.ModLinkEffects;
import com.xcompwiz.mystcraft.data.ModPageCollections;
import com.xcompwiz.mystcraft.entity.EntityFallingBlock;
import com.xcompwiz.mystcraft.entity.EntityLightningBoltAdv;
import com.xcompwiz.mystcraft.entity.EntityLinkbook;
import com.xcompwiz.mystcraft.entity.EntityMeteor;
import com.xcompwiz.mystcraft.error.MystcraftStartupChecker;
import com.xcompwiz.mystcraft.inventory.CreativeTabMyst;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookBinder;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookReceptacle;
import com.xcompwiz.mystcraft.tileentity.TileEntityBookstand;
import com.xcompwiz.mystcraft.tileentity.TileEntityDesk;
import com.xcompwiz.mystcraft.tileentity.TileEntityInkMixer;
import com.xcompwiz.mystcraft.tileentity.TileEntityLectern;
import com.xcompwiz.mystcraft.tileentity.TileEntityLinkModifier;
import com.xcompwiz.mystcraft.tileentity.TileEntityStarFissure;
import com.xcompwiz.mystcraft.world.profiling.InstabilityDataCalculator;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class MystcraftClientProxy
extends MystcraftCommonProxy {
    private MystcraftStartupChecker startupchecker;

    @Override
    public boolean isClientSideAvailable() {
        return true;
    }

    @Override
    public Entity getEntityByID(World worldObj, int id) {
        if (worldObj instanceof WorldClient) {
            return ((WorldClient)worldObj).func_73045_a(id);
        }
        return super.getEntityByID(worldObj, id);
    }

    public GuiNotification getNotificationGui() {
        return this.startupchecker.getNotificationGui();
    }

    @Override
    public void preinit() {
        this.startupchecker = new MystcraftStartupChecker();
        FMLCommonHandler.instance().bus().register((Object)this.startupchecker);
        MinecraftForge.EVENT_BUS.register((Object)this.startupchecker);
    }

    @Override
    public void init() {
        this.registerEntityRenderers();
        this.registerTileEntityRenderers();
        InternalAPI.render.registerRenderEffect(new LinkRendererDisarm());
        ParticleUtils.registerParticle("link", new ParticleProviderLink());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.page, (IItemRenderer)new ItemRendererPage());
        MinecraftForgeClient.registerItemRenderer((Item)ModItems.inkvial, (IItemRenderer)new ItemRendererMask());
        if (Mystcraft.archivistEnabled()) {
            VillagerRegistry.instance().registerVillagerSkin(Mystcraft.archivistId, Assets.Entities.archivist);
        }
    }

    private void registerEntityRenderers() {
        LoggerUtils.info("Adding Entity Renderers", new Object[0]);
        Render render = new RenderFallingBlock();
        render.func_76976_a(RenderManager.field_78727_a);
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingBlock.class, (Render)render);
        render = new RenderLinkbook();
        render.func_76976_a(RenderManager.field_78727_a);
        RenderingRegistry.registerEntityRenderingHandler(EntityLinkbook.class, (Render)render);
        render = new RenderLightningBoltAdv();
        render.func_76976_a(RenderManager.field_78727_a);
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningBoltAdv.class, (Render)render);
        render = new RenderMeteor();
        render.func_76976_a(RenderManager.field_78727_a);
        RenderingRegistry.registerEntityRenderingHandler(EntityMeteor.class, (Render)render);
    }

    private void registerTileEntityRenderers() {
        TileEntitySpecialRenderer render = new RenderWritingDesk();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDesk.class, (TileEntitySpecialRenderer)render);
        render = new RenderLectern();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLectern.class, (TileEntitySpecialRenderer)render);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.lectern), (IItemRenderer)new ItemRendererTileEntity(render, new TileEntityLectern()));
        render = new RenderBookstand();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBookstand.class, (TileEntitySpecialRenderer)render);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.bookstand), (IItemRenderer)new ItemRendererTileEntity(render, new TileEntityBookstand()));
        render = new RenderModel(new ModelBookBinder(), Assets.Entities.bookbinder);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBookBinder.class, (TileEntitySpecialRenderer)render);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.bookbinder), (IItemRenderer)new ItemRendererTileEntity(render, new TileEntityBookBinder()));
        render = new RenderModel(new ModelInkMixer(), Assets.Entities.inkmixer);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityInkMixer.class, (TileEntitySpecialRenderer)render);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.inkmixer), (IItemRenderer)new ItemRendererTileEntity(render, new TileEntityInkMixer()));
        render = new RenderModel(new ModelLinkModifier(), Assets.Entities.linkmodifier);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLinkModifier.class, (TileEntitySpecialRenderer)render);
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)ModBlocks.linkmodifier), (IItemRenderer)new ItemRendererTileEntity(render, new TileEntityLinkModifier()));
        render = new RenderStarFissure();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStarFissure.class, (TileEntitySpecialRenderer)render);
        render = new RenderBookReceptacle();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBookReceptacle.class, (TileEntitySpecialRenderer)render);
    }

    @Override
    public void initShaders() {
        ShaderUtils.registerShaders();
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double motionX, double motionY, double motionZ) {
        ParticleUtils.spawnParticle(particle, x, y, z, motionX, motionY, motionZ);
    }

    @Override
    public void createCreativeTabs() {
        CreativeTabMyst creativeTab = new CreativeTabMyst("mystcraft.common", true);
        creativeTab.registerItemStack(new ItemStack((Item)ModItems.agebook, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.unlinked, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.folder, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.portfolio, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.booster, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.desk, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModItems.desk, 1, 1));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.bookstand, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.lectern, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.crystal, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.receptacle, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.inkmixer, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.bookbinder, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.linkmodifier, 1, 0));
        creativeTab.registerItemStack(new ItemStack((Item)ModItems.inkvial, 1, 0));
        creativeTab.registerItemStack(new ItemStack(ModBlocks.black_ink, 1, 0));
        CreativeTabMyst pageTab = new CreativeTabMyst("mystcraft.pages");
        pageTab.setHasSearchBar(true);
        pageTab.registerItemStack(Page.createLinkPage());
        ArrayList<String> linkproperties = new ArrayList<String>();
        linkproperties.addAll(InkEffects.getProperties());
        Collections.sort(linkproperties);
        for (String property : linkproperties) {
            ModLinkEffects.isPropertyAllowed(property);
            pageTab.registerItemStack(Page.createLinkPage(property));
        }
        ModPageCollections.addSymbolPages(pageTab);
    }

    @Override
    public void startBaselineProfiling(MinecraftServer mcserver) {
        if (InstabilityDataCalculator.isPerSave()) {
            super.startBaselineProfiling(mcserver);
        }
    }

    @Override
    public void stopBaselineProfiling() {
        if (InstabilityDataCalculator.isPerSave()) {
            super.stopBaselineProfiling();
        }
    }
}

