/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.client.gui;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiCargoLoader;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerAstroMinerDock;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiAstroMinerDock
extends GuiContainerGC {
    private static final ResourceLocation dockGui = new ResourceLocation("galacticraftasteroids", "textures/gui/guiAstroMinerDock.png");
    private TileEntityMinerBase tile;
    private GuiButton recallButton;
    private GuiElementInfoRegion electricInfoRegion;
    private boolean extraLines;

    public GuiAstroMinerDock(InventoryPlayer playerInventory, TileEntityMinerBase dock) {
        super(new ContainerAstroMinerDock(playerInventory, dock));
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 233, (this.field_146295_m - this.field_147000_g) / 2 + 31, 10, 68, new ArrayList<String>(), this.field_146294_l, this.field_146295_m, this);
        this.field_146999_f = 256;
        this.field_147000_g = 221;
        this.tile = dock;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.recallButton.field_146124_l = true;
        if (this.tile.linkedMinerID == null) {
            this.recallButton.field_146124_l = false;
        } else {
            EntityAstroMiner miner = this.tile.linkedMiner;
            if (miner == null || miner.field_70128_L || this.tile.linkCountDown == 0 || miner.AIstate < 2 || miner.AIstate == 5) {
                this.recallButton.field_146124_l = false;
            }
        }
        this.recallButton.field_146126_j = GCCoreUtil.translate("gui.button.recall.name");
        super.func_73863_a(par1, par2, par3);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate("gui.energyStorage.desc.0"));
        electricityDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.energyStorage.desc.1") + (int)Math.floor(this.tile.getEnergyStoredGC()) + " / " + (int)Math.floor(this.tile.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = xPos + 233;
        this.electricInfoRegion.yPosition = yPos + 29;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate("gui.batterySlot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate("gui.batterySlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion(xPos + 230, yPos + 108, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, this));
        this.recallButton = new GuiButton(0, xPos + 173, yPos + 195, 76, 20, GCCoreUtil.translate("gui.button.recall.name"));
        this.field_146292_n.add(this.recallButton);
    }

    protected void func_73864_a(int px, int py, int par3) {
        super.func_73864_a(px, py, par3);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            switch (par1GuiButton.field_146127_k) {
                case 0: {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, new Object[]{this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, 0}));
                    break;
                }
            }
        }
    }

    private String getDeltaString(int num) {
        return num > 0 ? "+" + num : "" + num;
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(this.tile.func_145825_b(), 7, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.getStatus(), 177, 141, 0x404040);
        if (this.extraLines) {
            this.field_146289_q.func_78276_b("\u0394x: " + this.getDeltaString(MathHelper.func_76128_c((double)this.tile.linkedMiner.field_70165_t) - this.tile.field_145851_c - 1), 186, 152, 2536735);
        }
        if (this.extraLines) {
            this.field_146289_q.func_78276_b("\u0394y: " + this.getDeltaString(MathHelper.func_76128_c((double)this.tile.linkedMiner.field_70163_u) - this.tile.field_145848_d), 186, 162, 2536735);
        }
        if (this.extraLines) {
            this.field_146289_q.func_78276_b("\u0394z: " + this.getDeltaString(MathHelper.func_76128_c((double)this.tile.linkedMiner.field_70161_v) - this.tile.field_145849_e - 1), 186, 172, 2536735);
        }
        if (this.extraLines) {
            this.field_146289_q.func_78276_b(GCCoreUtil.translate("gui.miner.mined") + ": " + this.tile.linkedMiner.mineCount, 177, 183, 2536735);
        }
        this.field_146289_q.func_78276_b(GCCoreUtil.translate("container.inventory"), 7, this.field_147000_g - 92, 0x404040);
    }

    private String getStatus() {
        this.extraLines = false;
        if (this.tile.linkedMinerID == null) {
            return "";
        }
        EntityAstroMiner miner = this.tile.linkedMiner;
        if (miner == null || miner.field_70128_L) {
            return "";
        }
        if (this.tile.linkCountDown == 0) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.miner.outOfRange");
        }
        switch (miner.AIstate) {
            case -1: {
                return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.miner.offline");
            }
            case 0: {
                this.extraLines = true;
                return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.miner.stuck");
            }
            case 1: {
                return (Object)((Object)EnumColor.BRIGHT_GREEN) + GCCoreUtil.translate("gui.miner.docked");
            }
            case 2: {
                this.extraLines = true;
                return (Object)((Object)EnumColor.BRIGHT_GREEN) + GCCoreUtil.translate("gui.miner.travelling");
            }
            case 3: {
                this.extraLines = true;
                return (Object)((Object)EnumColor.BRIGHT_GREEN) + GCCoreUtil.translate("gui.miner.mining");
            }
            case 4: {
                this.extraLines = true;
                return (Object)((Object)EnumColor.BRIGHT_GREEN) + GCCoreUtil.translate("gui.miner.returning");
            }
            case 5: {
                return (Object)((Object)EnumColor.BRIGHT_GREEN) + GCCoreUtil.translate("gui.miner.docking");
            }
        }
        return "";
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(dockGui);
        this.func_73729_b(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate("gui.energyStorage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip(this.tile.getEnergyStoredGC(), this.tile.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.field_146297_k.func_110434_K().func_110577_a(GuiCargoLoader.loaderTexture);
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(xPos + 233, yPos + 17, 176, 0, 11, 10);
        }
        int level = Math.min(this.tile.getScaledElecticalLevel(66), 66);
        this.drawColorModalRect(xPos + 234, yPos + 29 + 66 - level, 8, level, 12692004);
    }

    public void drawColorModalRect(int p_73729_1_, int p_73729_2_, int p_73729_5_, int p_73729_6_, int color) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        tessellator.func_78382_b();
        tessellator.func_78378_d(color);
        tessellator.func_78377_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + p_73729_6_), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + 0), (double)this.field_73735_i);
        tessellator.func_78377_a((double)(p_73729_1_ + 0), (double)(p_73729_2_ + 0), (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

