/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderTier1Rocket;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererKey;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityBubbleProviderRenderer;
import micdoodle8.mods.galacticraft.planets.IPlanetsModuleClient;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.client.SkyProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.client.fx.EntityBacterialDripFX;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiSlimeling;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiSlimelingFeed;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiTerraformer;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiWaterElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.client.model.ModelTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.client.render.block.BlockRendererCavernousVines;
import micdoodle8.mods.galacticraft.planets.mars.client.render.block.BlockRendererEgg;
import micdoodle8.mods.galacticraft.planets.mars.client.render.block.BlockRendererHydrogenPipe;
import micdoodle8.mods.galacticraft.planets.mars.client.render.block.BlockRendererMachine;
import micdoodle8.mods.galacticraft.planets.mars.client.render.block.BlockRendererTier2TreasureChest;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderCreeperBoss;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderLandingBalloons;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderProjectileTNT;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderSlimeling;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderSludgeling;
import micdoodle8.mods.galacticraft.planets.mars.client.render.item.ItemRendererMachine;
import micdoodle8.mods.galacticraft.planets.mars.client.render.item.ItemRendererTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.client.render.tile.TileEntityCryogenicChamberRenderer;
import micdoodle8.mods.galacticraft.planets.mars.client.render.tile.TileEntityTreasureChestRenderer;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCreeperBoss;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityLandingBalloons;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityProjectileTNT;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySlimeling;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySludgeling;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTerraformer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTreasureChestMars;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityDropParticleFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;

public class MarsModuleClient
implements IPlanetsModuleClient {
    private static int vineRenderID;
    private static int eggRenderID;
    private static int treasureRenderID;
    private static int machineRenderID;
    private static int renderIdHydrogenPipe;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerClient());
        vineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererCavernousVines(vineRenderID));
        eggRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererEgg(eggRenderID));
        treasureRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererTier2TreasureChest(treasureRenderID));
        machineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(machineRenderID));
        renderIdHydrogenPipe = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererHydrogenPipe(renderIdHydrogenPipe));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        IModelCustom chamberModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galacticraftmars", "models/chamber.obj"));
        IModelCustom cargoRocketModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galacticraftmars", "models/cargoRocket.obj"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestMars.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCryogenicChamber.class, (TileEntitySpecialRenderer)new TileEntityCryogenicChamberRenderer(chamberModel));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTerraformer.class, (TileEntitySpecialRenderer)new TileEntityBubbleProviderRenderer(0.25f, 1.0f, 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(EntitySludgeling.class, (Render)new RenderSludgeling());
        RenderingRegistry.registerEntityRenderingHandler(EntitySlimeling.class, (Render)new RenderSlimeling());
        RenderingRegistry.registerEntityRenderingHandler(EntityCreeperBoss.class, (Render)new RenderCreeperBoss());
        RenderingRegistry.registerEntityRenderingHandler(EntityTier2Rocket.class, (Render)new RenderTier1Rocket(new ModelTier2Rocket(), "galacticraftmars", "rocketT2"));
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileTNT.class, (Render)new RenderProjectileTNT());
        RenderingRegistry.registerEntityRenderingHandler(EntityLandingBalloons.class, (Render)new RenderLandingBalloons());
        RenderingRegistry.registerEntityRenderingHandler(EntityLandingBalloons.class, (Render)new RenderLandingBalloons());
        RenderingRegistry.registerEntityRenderingHandler(EntityCargoRocket.class, (Render)new RenderCargoRocket(cargoRocketModel));
        RenderingRegistry.addNewArmourRendererPrefix((String)"desh");
        MinecraftForgeClient.registerItemRenderer((Item)MarsItems.spaceship, (IItemRenderer)new ItemRendererTier2Rocket(cargoRocketModel));
        MinecraftForgeClient.registerItemRenderer((Item)MarsItems.key, (IItemRenderer)new ItemRendererKey(new ResourceLocation("galacticraftmars", "textures/model/treasure.png")));
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MarsBlocks.machine), (IItemRenderer)new ItemRendererMachine(chamberModel));
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (side == Side.CLIENT) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (ID == 2) {
                if (tile instanceof TileEntityTerraformer) {
                    return new GuiTerraformer(player.field_71071_by, (TileEntityTerraformer)tile);
                }
                if (tile instanceof TileEntityLaunchController) {
                    return new GuiLaunchController(player.field_71071_by, (TileEntityLaunchController)tile);
                }
                if (tile instanceof TileEntityElectrolyzer) {
                    return new GuiWaterElectrolyzer(player.field_71071_by, (TileEntityElectrolyzer)tile);
                }
                if (tile instanceof TileEntityGasLiquefier) {
                    return new GuiGasLiquefier(player.field_71071_by, (TileEntityGasLiquefier)tile);
                }
                if (tile instanceof TileEntityMethaneSynthesizer) {
                    return new GuiMethaneSynthesizer(player.field_71071_by, (TileEntityMethaneSynthesizer)tile);
                }
            }
        }
        return null;
    }

    @Override
    public int getBlockRenderID(Block block) {
        if (block == MarsBlocks.vine) {
            return vineRenderID;
        }
        if (block == MarsBlocks.hydrogenPipe) {
            return renderIdHydrogenPipe;
        }
        if (block == MarsBlocks.rock) {
            return eggRenderID;
        }
        if (block == MarsBlocks.machine || block == MarsBlocks.machineT2) {
            return machineRenderID;
        }
        if (block == MarsBlocks.tier2TreasureChest) {
            return treasureRenderID;
        }
        return -1;
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object ... extraData) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.field_71451_h != null && mc.field_71452_i != null) {
            double dPosX = mc.field_71451_h.field_70165_t - position.x;
            double dPosY = mc.field_71451_h.field_70163_u - position.y;
            double dPosZ = mc.field_71451_h.field_70161_v - position.z;
            Object particle = null;
            double maxDistSqrd = 64.0;
            if (dPosX * dPosX + dPosY * dPosY + dPosZ * dPosZ < 4096.0) {
                if (particleID.equals("sludgeDrip")) {
                    particle = new EntityDropParticleFX((World)mc.field_71441_e, position.x, position.y, position.z, Material.field_151586_h);
                } else if (particleID.equals("bacterialDrip")) {
                    particle = new EntityBacterialDripFX((World)mc.field_71441_e, position.x, position.y, position.z);
                }
            }
            if (particle != null) {
                particle.field_70169_q = particle.field_70165_t;
                particle.field_70167_r = particle.field_70163_u;
                particle.field_70166_s = particle.field_70161_v;
                mc.field_71452_i.func_78873_a((EntityFX)particle);
            }
        }
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(2);
    }

    public static void openSlimelingGui(EntitySlimeling slimeling, int gui) {
        switch (gui) {
            case 0: {
                FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSlimeling(slimeling));
                break;
            }
            case 1: {
                FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSlimelingFeed(slimeling));
            }
        }
    }

    public static class TickHandlerClient {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            Minecraft minecraft = FMLClientHandler.instance().getClient();
            WorldClient world = minecraft.field_71441_e;
            if (world != null && world.field_73011_w instanceof WorldProviderMars) {
                if (world.field_73011_w.getSkyRenderer() == null) {
                    world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderMars((IGalacticraftWorldProvider)world.field_73011_w));
                }
                if (world.field_73011_w.getCloudRenderer() == null) {
                    world.field_73011_w.setCloudRenderer((IRenderHandler)new CloudRenderer());
                }
            }
        }
    }
}

