/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.util.MarsUtil;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityLandingBalloons
extends EntityLanderBase
implements IIgnoreShift,
ICameraZoomEntity {
    private int groundHitCount;
    private float rotationPitchSpeed;
    private float rotationYawSpeed;

    public EntityLandingBalloons(World world) {
        super(world, 0.0f);
        this.func_70105_a(2.0f, 2.0f);
        this.rotationPitchSpeed = this.field_70146_Z.nextFloat();
        this.rotationYawSpeed = this.field_70146_Z.nextFloat();
    }

    public EntityLandingBalloons(EntityPlayerMP player) {
        super(player, 0.0f);
        this.func_70105_a(2.0f, 2.0f);
    }

    @Override
    public double func_70042_X() {
        return super.func_70042_X() - 0.9;
    }

    @Override
    public float getRotateOffset() {
        return -20.0f;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70122_E = false;
        }
        super.func_70071_h_();
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70122_E = false;
        }
        if (!this.field_70122_E) {
            this.field_70125_A += this.rotationPitchSpeed;
            this.field_70177_z += this.rotationYawSpeed;
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.groundHitCount = nbt.func_74762_e("GroundHitCount");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("GroundHitCount", this.groundHitCount);
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.marsLander.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_130002_c(EntityPlayer var1) {
        if (this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                return false;
            }
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            return true;
        }
        if (this.field_70153_n == null && this.groundHitCount >= 14 && var1 instanceof EntityPlayerMP) {
            MarsUtil.openParachestInventory((EntityPlayerMP)var1, this);
            return true;
        }
        if (var1 instanceof EntityPlayerMP) {
            if (!this.field_70122_E) {
                return false;
            }
            var1.func_70078_a(null);
            return true;
        }
        return true;
    }

    @Override
    public boolean pressKey(int key) {
        if (this.field_70122_E) {
            return false;
        }
        return false;
    }

    @Override
    public boolean shouldMove() {
        if (this.ticks < 40L || !this.hasReceivedPacket) {
            return false;
        }
        return this.field_70153_n != null && this.groundHitCount < 14 || !this.field_70122_E;
    }

    @Override
    public boolean shouldSpawnParticles() {
        return false;
    }

    @Override
    public Map<Vector3, Vector3> getParticleMap() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityFX getParticle(Random rand, double x, double y, double z, double motX, double motY, double motZ) {
        return null;
    }

    @Override
    public void tickInAir() {
        if (this.field_70170_p.field_72995_K) {
            if (this.groundHitCount == 0) {
                this.field_70181_x = -this.field_70163_u / 50.0;
            } else if (this.groundHitCount < 14 || this.shouldMove()) {
                this.field_70181_x *= 0.95;
                this.field_70181_x -= 0.08;
            } else if (!this.shouldMove()) {
                this.rotationYawSpeed = 0.0f;
                this.rotationPitchSpeed = 0.0f;
                this.field_70159_w = this.field_70179_y = (double)0.0f;
                this.field_70181_x = this.field_70179_y;
            }
        }
    }

    @Override
    public void tickOnGround() {
    }

    @Override
    public void onGroundHit() {
    }

    @Override
    public Vector3 getMotionVec() {
        if (this.field_70122_E && this.groundHitCount < 14) {
            ++this.groundHitCount;
            double mag = 1.0 / (double)this.groundHitCount * 4.0;
            double mX = this.field_70146_Z.nextDouble() - 0.5;
            double mY = 1.0;
            double mZ = this.field_70146_Z.nextDouble() - 0.5;
            return new Vector3(mX *= mag / 3.0, mY *= mag, mZ *= mag / 3.0);
        }
        if (this.ticks >= 40L && this.ticks < 45L) {
            this.field_70181_x = this.getInitialMotionY();
        }
        if (!this.shouldMove()) {
            return new Vector3(0.0, 0.0, 0.0);
        }
        return new Vector3(this.field_70159_w, this.ticks < 40L ? 0.0 : this.field_70181_x, this.field_70179_y);
    }

    @Override
    public ArrayList<Object> getNetworkedData() {
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.addAll(super.getNetworkedData());
        if (this.field_70170_p.field_72995_K && this.hasReceivedPacket && this.groundHitCount <= 14 || !this.field_70170_p.field_72995_K && this.groundHitCount == 14) {
            objList.add(this.groundHitCount);
        }
        return objList;
    }

    @Override
    public int getPacketTickSpacing() {
        return 5;
    }

    @Override
    public double getPacketSendDistance() {
        return 50.0;
    }

    @Override
    public void readNetworkedData(ByteBuf buffer) {
        try {
            super.readNetworkedData(buffer);
            if (buffer.readableBytes() > 0) {
                this.groundHitCount = buffer.readInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean allowDamageSource(DamageSource damageSource) {
        return this.groundHitCount > 0 && super.allowDamageSource(damageSource);
    }

    @Override
    public double getInitialMotionY() {
        return 0.0;
    }

    @Override
    public float getCameraZoom() {
        return 15.0f;
    }

    @Override
    public boolean defaultThirdPerson() {
        return true;
    }

    @Override
    public boolean shouldIgnoreShiftExit() {
        return this.groundHitCount < 14 || !this.field_70122_E;
    }
}

