/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.relauncher.Side;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IHydrogenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.IOxygenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenReceiver;
import micdoodle8.mods.galacticraft.api.transmission.tile.IOxygenStorage;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.oxygen.NetworkHelper;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemAtmosphericValve;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityElectrolyzer
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IFluidHandler,
IOxygenStorage,
IOxygenReceiver {
    private final int tankCapacity = 4000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank2 = new FluidTank(this.tankCapacity);
    public int processTimeRequired = 3;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[4];

    public TileEntityElectrolyzer() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 150.0f : 120.0f);
        this.setTierGC(2);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid;
            if (this.containingItems[1] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1])) != null && liquid.getFluid().getName().equals(FluidRegistry.WATER.getName()) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(liquid, true);
                this.containingItems[1] = FluidUtil.getUsedContainer(this.containingItems[1]);
            }
            this.checkFluidTankTransfer(2, this.liquidTank);
            this.checkFluidTankTransfer(3, this.liquidTank2);
            if (this.hasEnoughEnergyToRun && this.canProcess()) {
                if (this.tierGC == 2) {
                    int n = this.processTimeRequired = this.poweredByTierGC == 2 ? 2 : 3;
                }
                if (this.processTicks == 0) {
                    this.processTicks = this.processTimeRequired;
                } else if (--this.processTicks <= 0) {
                    this.doElectrolysis();
                    this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                }
            } else {
                this.processTicks = 0;
            }
            this.produceOxygen(ForgeDirection.getOrientation((int)this.getOxygenOutputDirection()));
            this.produceHydrogen(ForgeDirection.getOrientation((int)this.getHydrogenOutputDirection()));
        }
    }

    private void doElectrolysis() {
        int waterAmount = this.waterTank.getFluid().amount;
        if (waterAmount == 0) {
            return;
        }
        this.placeIntoFluidTanks(2);
        this.waterTank.drain(1, true);
    }

    private int placeIntoFluidTanks(int amountToDrain) {
        int fuelSpace = this.liquidTank.getCapacity() - this.liquidTank.getFluidAmount();
        int fuelSpace2 = this.liquidTank2.getCapacity() - this.liquidTank2.getFluidAmount();
        int amountToDrain2 = amountToDrain * 2;
        if (amountToDrain > fuelSpace) {
            amountToDrain = fuelSpace;
        }
        this.liquidTank.fill(FluidRegistry.getFluidStack((String)"oxygen", (int)amountToDrain), true);
        if (amountToDrain2 > fuelSpace2) {
            amountToDrain2 = fuelSpace2;
        }
        this.liquidTank2.fill(FluidRegistry.getFluidStack((String)"hydrogen", (int)amountToDrain2), true);
        return amountToDrain;
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        if (this.containingItems[slot] != null && this.containingItems[slot].func_77973_b() instanceof ItemAtmosphericValve) {
            tank.drain(4, true);
        }
    }

    public int getScaledGasLevel(int i) {
        return this.waterTank.getFluid() != null ? this.waterTank.getFluid().amount * i / this.waterTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.liquidTank.getFluid() != null ? this.liquidTank.getFluid().amount * i / this.liquidTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel2(int i) {
        return this.liquidTank2.getFluid() != null ? this.liquidTank2.getFluid().amount * i / this.liquidTank2.getCapacity() : 0;
    }

    public boolean canProcess() {
        if (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount <= 0 || this.getDisabled(0)) {
            return false;
        }
        boolean tank1HasSpace = this.liquidTank.getFluidAmount() < this.liquidTank.getCapacity();
        boolean tank2HasSpace = this.liquidTank2.getFluidAmount() < this.liquidTank2.getCapacity();
        return tank1HasSpace || tank2HasSpace;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("processTicks");
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        }
        if (nbt.func_74764_b("gasTank")) {
            this.liquidTank.readFromNBT(nbt.func_74775_l("gasTank"));
        }
        if (nbt.func_74764_b("gasTank2")) {
            this.liquidTank2.readFromNBT(nbt.func_74775_l("gasTank2"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("processTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt);
        if (this.waterTank.getFluid() != null) {
            nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank.getFluid() != null) {
            nbt.func_74782_a("gasTank", (NBTBase)this.liquidTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank2.getFluid() != null) {
            nbt.func_74782_a("gasTank2", (NBTBase)this.liquidTank2.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("tile.marsMachine.6.name");
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged(itemstack);
                }
                case 1: {
                    return itemstack.func_77973_b() == Items.field_151131_as;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty(itemstack);
                }
                case 1: {
                    return itemstack.func_77973_b() == Items.field_151133_ar;
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem(item);
            }
            case 1: {
                return item == Items.field_151133_ar || item == Items.field_151131_as;
            }
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    @Override
    public double getPacketRange() {
        return 320.0;
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.DOWN;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.liquidTank2.getFluid() != null && this.liquidTank2.getFluidAmount() > 0;
        }
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1)) {
            return this.liquidTank.getFluid() != null && this.liquidTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1) && resource != null && resource.isFluidEqual(this.liquidTank2.getFluid())) {
            return this.liquidTank2.drain(resource.amount, doDrain);
        }
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1) && resource != null && resource.isFluidEqual(this.liquidTank.getFluid())) {
            return this.liquidTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.liquidTank2.drain(maxDrain, doDrain);
        }
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1)) {
            return this.liquidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.ordinal() == this.func_145832_p() + 2) {
            return fluid != null && fluid.getName().equals(FluidRegistry.WATER.getName());
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid())) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        int side;
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        int metaside = this.func_145832_p() + 2;
        if (metaside == (side = from.ordinal())) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
        } else if (metaside == (side ^ 1)) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank2)};
        } else if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1)) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank)};
        }
        return tankInfo;
    }

    public int func_145832_p() {
        if (this.field_145847_g == -1) {
            this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.field_145847_g & 3;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public GasStack drawGas(ForgeDirection from, int amount, boolean doTransfer) {
        int side;
        int metaside = this.func_145832_p() + 2;
        if (metaside == ((side = from.ordinal()) ^ 1) && this.liquidTank2.getFluid() != null) {
            int amountH = Math.min(8, this.liquidTank2.getFluidAmount());
            amountH = this.liquidTank2.drain((int)amountH, (boolean)doTransfer).amount;
            return new GasStack((Gas)EnergyConfigHandler.gasHydrogen, amountH);
        }
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1) && this.liquidTank.getFluid() != null) {
            int amountO = Math.min(8, this.liquidTank.getFluidAmount());
            amountO = this.liquidTank.drain((int)amountO, (boolean)doTransfer).amount;
            return new GasStack((Gas)EnergyConfigHandler.gasOxygen, amountO);
        }
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public GasStack drawGas(ForgeDirection from, int amount) {
        return this.drawGas(from, amount, true);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public boolean canDrawGas(ForgeDirection from, Gas type) {
        int side;
        int metaside = this.func_145832_p() + 2;
        if (metaside == ((side = from.ordinal()) ^ 1)) {
            return type.getName().equals("hydrogen");
        }
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1)) {
            return type.getName().equals("oxygen");
        }
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.ITubeConnection", modID="Mekanism")
    public boolean canTubeConnect(ForgeDirection from) {
        int side;
        int metaside = this.func_145832_p() + 2;
        if (metaside == ((side = from.ordinal()) ^ 1)) {
            return true;
        }
        return 7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1);
    }

    @Override
    public void setOxygenStored(float amount) {
        this.liquidTank.setFluid(new FluidStack(AsteroidsModule.fluidOxygenGas, (int)amount));
    }

    @Override
    public float getOxygenStored() {
        return this.liquidTank.getFluidAmount();
    }

    public int getHydrogenStored() {
        return this.liquidTank2.getFluidAmount();
    }

    @Override
    public float getMaxOxygenStored() {
        return this.liquidTank.getCapacity();
    }

    private int getOxygenOutputDirection() {
        int metaside;
        return 7 - (metaside ^ ((metaside = this.func_145832_p() + 2) > 3 ? 0 : 1)) ^ 1;
    }

    private int getHydrogenOutputDirection() {
        int metaside = this.func_145832_p() + 2;
        return metaside ^ 1;
    }

    private boolean produceOxygen(ForgeDirection outputDirection) {
        float provide = this.getOxygenProvide(outputDirection);
        if (provide > 0.0f) {
            TileEntity outputTile = new BlockVec3(this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_145850_b);
            IOxygenNetwork outputNetwork = NetworkHelper.getOxygenNetworkFromTileEntity(outputTile, outputDirection);
            if (outputNetwork != null) {
                TileEntity[] tileEntityArray = new TileEntity[]{this};
                float powerRequest = outputNetwork.getRequest(tileEntityArray);
                if (powerRequest > 0.0f) {
                    float toSend = Math.min(this.getOxygenStored(), provide);
                    float rejectedPower = outputNetwork.produce(toSend, this);
                    this.provideOxygen(Math.max(toSend - rejectedPower, 0.0f), true);
                    return true;
                }
            } else if (outputTile instanceof IOxygenReceiver) {
                float requestedOxygen = ((IOxygenReceiver)outputTile).getOxygenRequest(outputDirection.getOpposite());
                if (requestedOxygen > 0.0f) {
                    float toSend = Math.min(this.getOxygenStored(), provide);
                    float acceptedOxygen = ((IOxygenReceiver)outputTile).receiveOxygen(outputDirection.getOpposite(), toSend, true);
                    this.provideOxygen(acceptedOxygen, true);
                    return true;
                }
            } else if (EnergyConfigHandler.isMekanismLoaded() && outputTile instanceof IGasHandler && ((IGasHandler)outputTile).canReceiveGas(outputDirection.getOpposite(), (Gas)EnergyConfigHandler.gasOxygen)) {
                GasStack toSend = new GasStack((Gas)EnergyConfigHandler.gasOxygen, (int)Math.floor(Math.min(this.getOxygenStored(), provide)));
                int acceptedOxygen = 0;
                try {
                    acceptedOxygen = ((IGasHandler)outputTile).receiveGas(outputDirection.getOpposite(), toSend);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.provideOxygen(acceptedOxygen, true);
                return true;
            }
        }
        return false;
    }

    private boolean produceHydrogen(ForgeDirection outputDirection) {
        float provide = this.getHydrogenProvide(outputDirection);
        if (provide > 0.0f) {
            TileEntity outputTile = new BlockVec3(this).modifyPositionFromSide(outputDirection).getTileEntity((IBlockAccess)this.field_145850_b);
            IHydrogenNetwork outputNetwork = NetworkHelper.getHydrogenNetworkFromTileEntity(outputTile, outputDirection);
            if (outputNetwork != null) {
                TileEntity[] tileEntityArray = new TileEntity[]{this};
                float powerRequest = outputNetwork.getRequest(tileEntityArray);
                if (powerRequest > 0.0f) {
                    float toSend = Math.min((float)this.getHydrogenStored(), provide);
                    float rejectedPower = outputNetwork.produce(toSend, this);
                    this.provideHydrogen((int)Math.max(toSend - rejectedPower, 0.0f), true);
                    return true;
                }
            } else if (outputTile instanceof TileEntityMethaneSynthesizer) {
                float requestedHydrogen = ((TileEntityMethaneSynthesizer)outputTile).getHydrogenRequest(outputDirection.getOpposite()).floatValue();
                if (requestedHydrogen > 0.0f) {
                    float toSend = Math.min((float)this.getHydrogenStored(), provide);
                    float acceptedHydrogen = ((TileEntityMethaneSynthesizer)outputTile).receiveHydrogen(outputDirection.getOpposite(), toSend, true);
                    this.provideHydrogen((int)acceptedHydrogen, true);
                    return true;
                }
            } else if (EnergyConfigHandler.isMekanismLoaded() && outputTile instanceof IGasHandler && ((IGasHandler)outputTile).canReceiveGas(outputDirection.getOpposite(), (Gas)EnergyConfigHandler.gasHydrogen)) {
                GasStack toSend = new GasStack((Gas)EnergyConfigHandler.gasHydrogen, (int)Math.floor(Math.min((float)this.getHydrogenStored(), provide)));
                int acceptedHydrogen = 0;
                try {
                    acceptedHydrogen = ((IGasHandler)outputTile).receiveGas(outputDirection.getOpposite(), toSend);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.provideHydrogen(acceptedHydrogen, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public float provideOxygen(ForgeDirection from, float request, boolean doProvide) {
        if (this.getOxygenOutputDirection() == from.ordinal()) {
            return this.provideOxygen(request, doProvide);
        }
        return 0.0f;
    }

    public float provideOxygen(float request, boolean doProvide) {
        if (request > 0.0f) {
            float requestedOxygen = Math.min(request, (float)this.liquidTank.getFluidAmount());
            if (doProvide) {
                this.setOxygenStored((float)this.liquidTank.getFluidAmount() - requestedOxygen);
            }
            return requestedOxygen;
        }
        return 0.0f;
    }

    public int provideHydrogen(int request, boolean doProvide) {
        if (request > 0) {
            int currentHydrogen = this.liquidTank2.getFluidAmount();
            int requestedHydrogen = Math.min(request, currentHydrogen);
            if (doProvide) {
                this.liquidTank2.setFluid(new FluidStack(FluidRegistry.getFluid((String)"hydrogen"), currentHydrogen - requestedHydrogen));
            }
            return requestedHydrogen;
        }
        return 0;
    }

    @Override
    public float getOxygenProvide(ForgeDirection direction) {
        return this.getOxygenOutputDirection() == direction.ordinal() ? Math.min(500.0f, this.getOxygenStored()) : 0.0f;
    }

    public float getHydrogenProvide(ForgeDirection direction) {
        return this.getHydrogenOutputDirection() == direction.ordinal() ? (float)Math.min(500, this.getHydrogenStored()) : 0.0f;
    }

    @Override
    public boolean shouldPullOxygen() {
        return false;
    }

    @Override
    public float receiveOxygen(ForgeDirection from, float receive, boolean doReceive) {
        return 0.0f;
    }

    @Override
    public float getOxygenRequest(ForgeDirection direction) {
        return 0.0f;
    }

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN)) {
            return false;
        }
        if (type == NetworkType.OXYGEN) {
            return this.getOxygenOutputDirection() == direction.ordinal();
        }
        if (type == NetworkType.HYDROGEN) {
            return this.getHydrogenOutputDirection() == direction.ordinal();
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        return false;
    }
}

