/*
 * Decompiled with CFR 0.152.
 */
package modwarriors.notenoughkeys.gui;

import modwarriors.notenoughkeys.Helper;
import modwarriors.notenoughkeys.gui.GuiSubKeybindsMenu;
import modwarriors.notenoughkeys.keys.KeyHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiSubKeybindsScrollPanel
extends GuiSlot {
    protected static final ResourceLocation WIDGITS = new ResourceLocation("textures/gui/widgets.png");
    private GuiSubKeybindsMenu controls;
    private GameSettings options;
    private Minecraft mc;
    private String[] message;
    private int _mouseX;
    private int _mouseY;
    private int selected = -1;
    public KeyBinding[] keyBindings;

    public GuiSubKeybindsScrollPanel(GuiSubKeybindsMenu controls, GameSettings options, Minecraft mc, KeyBinding[] kbs) {
        super(mc, controls.field_146294_l, controls.field_146295_m, 16, controls.field_146295_m - 32 + 4, 25);
        this.controls = controls;
        this.options = options;
        this.mc = mc;
        this.keyBindings = kbs;
    }

    protected int func_148127_b() {
        return this.keyBindings.length;
    }

    protected void func_148144_a(int i, boolean doubleClick, int mouseX, int mouseY) {
        if (!doubleClick) {
            if (this.selected == -1) {
                this.selected = i;
            } else {
                KeyBinding glob = this.getGlobalKeybind(this.selected);
                this.saveKeyBinding(glob, -100);
            }
        }
    }

    protected boolean func_148131_a(int i) {
        return false;
    }

    protected void func_148123_a() {
    }

    public void func_148128_a(int mX, int mY, float f) {
        this._mouseX = mX;
        this._mouseY = mY;
        if (this.selected != -1 && !Mouse.isButtonDown((int)0) && Mouse.getDWheel() == 0 && Mouse.next() && Mouse.getEventButtonState()) {
            KeyBinding glob = this.getGlobalKeybind(this.selected);
            this.saveKeyBinding(glob, -100 + Mouse.getEventButton());
        }
        super.func_148128_a(mX, mY, f);
    }

    protected void func_148126_a(int index, int xPosition, int yPosition, int l, Tessellator tessellator, int mouseX, int mouseY) {
        if (this.keyBindings[index] == null) {
            return;
        }
        String s = I18n.func_135052_a((String)this.keyBindings[index].func_151464_g(), (Object[])new Object[0]);
        int width = 70;
        int height = 20;
        boolean flag = this._mouseX >= (xPosition -= 20) && this._mouseY >= yPosition && this._mouseX < xPosition + width && this._mouseY < yPosition + height;
        int k = flag ? 2 : 1;
        this.mc.field_71446_o.func_110577_a(WIDGITS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.controls.func_73729_b(xPosition, yPosition, 0, 46 + k * 20, width / 2, height);
        this.controls.func_73729_b(xPosition + width / 2, yPosition, 200 - width / 2, 46 + k * 20, width / 2, height);
        this.controls.func_73731_b(this.mc.field_71466_p, s, xPosition + width + 4, yPosition + 6, -1);
        this.drawAltStrings(xPosition, yPosition, this.keyBindings[index]);
        boolean conflict = false;
        KeyBinding globKb = this.getGlobalKeybind(index);
        conflict = KeyHelper.conflictingKeys.contains(globKb);
        String str = (conflict ? EnumChatFormatting.RED : "") + GameSettings.func_74298_c((int)this.keyBindings[index].func_151463_i());
        str = index == this.selected ? EnumChatFormatting.WHITE + "> " + EnumChatFormatting.YELLOW + "??? " + EnumChatFormatting.WHITE + "<" : str;
        this.controls.func_73732_a(this.mc.field_71466_p, str, xPosition + width / 2, yPosition + (height - 8) / 2, -1);
    }

    private void drawAltStrings(int slotX, int slotY, KeyBinding keyBinding) {
        float scale = 0.5f;
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        boolean[] modifiers = KeyHelper.alternates.get(keyBinding.func_151464_g());
        if (modifiers != null) {
            if (modifiers[0]) {
                this.drawAltString("SHIFT", (int)(1.0f / scale * (float)(slotX - 4)), (int)(1.0f / scale * (float)(slotY + 2)) + 3);
            }
            if (modifiers[1]) {
                this.drawAltString("CTRL", (int)(1.0f / scale * (float)(slotX - 4)), (int)(1.0f / scale * (float)(slotY + 2)) + 13);
            }
            if (modifiers[2]) {
                this.drawAltString("ALT", (int)(1.0f / scale * (float)(slotX - 4)), (int)(1.0f / scale * (float)(slotY + 2)) + 23);
            }
        }
        GL11.glPopMatrix();
    }

    private void drawAltString(String altType, int x, int y) {
        this.controls.func_73731_b(this.mc.field_71466_p, altType, x - this.mc.field_71466_p.func_78256_a(altType), y, -1);
    }

    public KeyBinding getGlobalKeybind(int localIndex) {
        if (localIndex < 0) {
            return null;
        }
        return KeyHelper.getKeybind(this.keyBindings[localIndex]);
    }

    public boolean keyTyped(char c, int keycode) {
        if (this.selected != -1) {
            KeyBinding keyBinding = this.getGlobalKeybind(this.selected);
            boolean isCompatible = KeyHelper.alternates.containsKey(keyBinding.func_151464_g());
            boolean isSpecialKey = Helper.isSpecialKey(keycode);
            if (!isCompatible || !isSpecialKey) {
                this.saveKeyBinding(keyBinding, keycode == 1 ? 0 : keycode);
                return false;
            }
        }
        return true;
    }

    private void saveKeyBinding(KeyBinding key, int keycode) {
        KeyHelper.saveKeyBinding(key, keycode, new boolean[]{Helper.isShiftKeyDown(), Helper.isCtrlKeyDown(), Helper.isAltKeyDown()});
        this.selected = -1;
    }
}

