/*
 * Decompiled with CFR 0.152.
 */
package modwarriors.notenoughkeys.keys;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import modwarriors.notenoughkeys.Helper;
import modwarriors.notenoughkeys.NotEnoughKeys;
import modwarriors.notenoughkeys.api.KeyBindingPressedEvent;
import modwarriors.notenoughkeys.gui.GuiControlsOverride;
import modwarriors.notenoughkeys.gui.GuiKeybindsMenu;
import modwarriors.notenoughkeys.keys.KeyHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class KeyEvents {
    private Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui != null && event.gui.getClass().equals(GuiControls.class) && !(event.gui instanceof GuiControlsOverride)) {
            event.gui = new GuiKeybindsMenu();
        }
    }

    @SubscribeEvent
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        this.refreshBindings(-1);
    }

    @SubscribeEvent
    public void onMouseButtonEvent(MouseEvent event) {
        if (event.button >= 0) {
            this.refreshBindings(event.button + 100);
        }
    }

    private void refreshBindings(int keycode) {
        for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (keycode >= 0 && keyBinding.func_151463_i() != keycode) continue;
            boolean isInternal = keyBinding.func_151470_d();
            boolean isKeyboard = Helper.isKeyPressed_KeyBoard(keyBinding);
            if (!KeyHelper.alternates.containsKey(keyBinding.func_151464_g())) {
                if (isInternal == isKeyboard) continue;
                this.setKeyPressed(keyBinding, isKeyboard);
                continue;
            }
            boolean isSpecial = KeyHelper.isKeyBindingPressed(keyBinding);
            if (Minecraft.func_71410_x().field_71462_r != null) continue;
            MinecraftForge.EVENT_BUS.post((Event)new KeyBindingPressedEvent(keyBinding, KeyHelper.alternates.get(keyBinding.func_151464_g()), isSpecial));
        }
    }

    private void setKeyPressed(KeyBinding keyBinding, boolean isPressed) {
        try {
            ObfuscationReflectionHelper.setPrivateValue(KeyBinding.class, (Object)keyBinding, (Object)isPressed, (String[])new String[]{"pressed", "field_74513_e"});
            if (isPressed) {
                int pressTime = (Integer)ObfuscationReflectionHelper.getPrivateValue(KeyBinding.class, (Object)keyBinding, (String[])new String[]{"pressTime", "field_151474_i"});
                ObfuscationReflectionHelper.setPrivateValue(KeyBinding.class, (Object)keyBinding, (Object)(pressTime + 1), (String[])new String[]{"pressTime", "field_151474_i"});
            }
        }
        catch (Exception e) {
            NotEnoughKeys.logger.error("A key with the description '" + keyBinding.func_151464_g() + "' from category '" + keyBinding.func_151466_e() + "' and keycode '" + keyBinding.func_151463_i() + "' could not be set from pressed state '" + keyBinding.func_151470_d() + "' to state '" + isPressed + "'. This is an eror. PLEASE report this to the issues stub on github.");
            e.printStackTrace();
        }
    }
}

