/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.undo;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import oreexcavation.core.OreExcavation;
import oreexcavation.utils.BlockPos;

public class BlockHistory {
    public final BlockPos pos;
    public final Block block;
    public final int meta;
    public final NBTTagCompound tileData;

    public BlockHistory(BlockPos pos, Block block, int meta, NBTTagCompound tileData) {
        this.pos = pos;
        this.block = block;
        this.meta = meta;
        this.tileData = tileData;
    }

    public BlockHistory(BlockSnapshot snapshot) {
        this.pos = new BlockPos(snapshot.x, snapshot.y, snapshot.z);
        this.block = snapshot.getReplacedBlock();
        this.meta = snapshot.meta;
        TileEntity tile = snapshot.getTileEntity();
        if (tile != null) {
            this.tileData = new NBTTagCompound();
            try {
                snapshot.getTileEntity().func_145841_b(this.tileData);
            }
            catch (Exception e) {
                OreExcavation.logger.error("Unable to save undo state for tile entity: " + snapshot.getTileEntity().toString(), (Throwable)e);
            }
        } else {
            this.tileData = null;
        }
    }

    public BlockHistory(BlockSnapshot snapshot, NBTTagCompound tileNBT) {
        this.pos = new BlockPos(snapshot.x, snapshot.y, snapshot.z);
        this.block = snapshot.getReplacedBlock();
        this.meta = snapshot.meta;
        this.tileData = tileNBT;
    }

    public void restoreBlock(World world) {
        world.func_147465_d(this.pos.getX(), this.pos.getY(), this.pos.getZ(), this.block, this.meta, 2);
        TileEntity tile = world.func_147438_o(this.pos.getX(), this.pos.getY(), this.pos.getZ());
        if (tile != null && this.tileData != null) {
            tile.func_145839_a(this.tileData);
        }
    }
}

