/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad.common.event;

import com.robrit.snad.common.util.ConfigurationData;
import com.robrit.snad.common.util.LogHelper;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    private static Configuration configuration;
    private static File configFile;

    public static void init() {
        ConfigurationHandler.setConfiguration(new Configuration(configFile));
    }

    public static void updateConfiguration() {
        try {
            configuration.load();
            ConfigurationData.SPEED_INCREASE_VALUE = configuration.get("General Configs", "Speed Increase Multiplier", 2).getInt();
        }
        catch (Exception exception) {
            LogHelper.error("Unable to read configuration for Snad");
            LogHelper.error(exception);
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(Configuration newConfiguration) {
        configuration = newConfiguration;
    }

    public static File getConfigFile() {
        return configFile;
    }

    public static void setConfigFile(File newConfigFile) {
        configFile = newConfigFile;
    }

    @SubscribeEvent
    public static void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("snad")) {
            ConfigurationHandler.updateConfiguration();
        }
    }
}

