/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.widgets.CarbonButton;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;

public class BooleanElement
extends ConfigElement {
    private CarbonButton trueButton;
    private CarbonButton falseButton;

    public BooleanElement(IValueNode value) {
        super(value);
    }

    public BooleanElement(IArrayNode array, IValueNode value) {
        super(array, value);
    }

    public BooleanElement(ICompoundNode compound, IValueNode value) {
        super(compound, value);
    }

    @Override
    public void init() {
        super.init();
        int width = this.isArray() ? 72 : (this.isCompound() ? 52 : 36);
        this.trueButton = this.addChild(new CarbonButton(0, 0, width, 18, I18n.func_135052_a((String)"gui.carbonconfig.boolean.true", (Object[])new Object[0]), this::onTrue), this.isArray() ? ConfigElement.GuiAlign.CENTER : ConfigElement.GuiAlign.RIGHT, this.isArray() ? width / 2 : width + (this.isCompound() ? 1 : 0));
        this.falseButton = this.addChild(new CarbonButton(0, 0, width + (this.isCompound() ? 1 : 0), 18, I18n.func_135052_a((String)"gui.carbonconfig.boolean.false", (Object[])new Object[0]), this::onFalse), this.isArray() ? ConfigElement.GuiAlign.CENTER : ConfigElement.GuiAlign.RIGHT, this.isArray() ? -(width / 2) : 0);
        this.updateData();
    }

    private void updateData() {
        boolean isTrue = Boolean.parseBoolean(this.value.get());
        this.trueButton.field_146124_l = !isTrue;
        this.falseButton.field_146124_l = isTrue;
    }

    @Override
    public void tick() {
        super.tick();
        this.updateData();
    }

    protected void onTrue(GuiButton button) {
        this.value.set("true");
    }

    protected void onFalse(GuiButton button) {
        this.value.set("false");
    }
}

