/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.widgets.screen.AbstractScrollList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class ElementList
extends AbstractScrollList<Element> {
    int listWidth = 220;
    int scrollPadding = 124;
    Consumer<Element> callback;

    public ElementList(int width, int height, int screenY, int listY, int itemHeight) {
        super(width, height, screenY, listY, itemHeight);
        this.setRenderSelection(false);
    }

    @Override
    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.children().get(index));
    }

    public void setCallback(Consumer<Element> callback) {
        this.callback = callback;
    }

    public void addElement(Element element) {
        this.addEntry(element);
    }

    public void addElements(List<Element> elements) {
        elements.forEach(this::addEntry);
    }

    public void updateList(List<Element> elements) {
        super.replaceEntries(elements);
    }

    public void removeElement(Element element) {
        this.removeEntry(element);
    }

    public int size() {
        return this.children().size();
    }

    @Override
    public void setSelected(Element p_93462_) {
        super.setSelected(p_93462_);
        if (this.callback != null && this.getSelected() != null) {
            this.callback.accept((Element)this.getSelected());
        }
    }

    public void scrollToElement(Element element, boolean center) {
        int index = this.children().indexOf(element);
        if (index == -1) {
            return;
        }
        this.scrollToElement(index, center);
    }

    public void scrollToSelected(boolean center) {
        if (this.getSelected() == null) {
            return;
        }
        this.scrollToElement((Element)this.getSelected(), center);
    }

    public void scrollToElement(int index, boolean center) {
        if (center) {
            index -= this.height / this.itemHeight / 3;
        }
        this.setScrollAmount(Math.max(0, index) * this.itemHeight + this.headerHeight);
    }

    public void setListWidth(int listWidth) {
        this.listWidth = listWidth;
    }

    public void setScrollPadding(int scrollPadding) {
        this.scrollPadding = scrollPadding;
    }

    @Override
    public int getRowWidth() {
        return this.listWidth;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width / 2 + this.scrollPadding;
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public static void renderBackground(int x0, int x1, int y0, int y1, float scroll, BackgroundTexture texture) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.getBackgroundTexture());
        int color = texture.getBackgroundBrightness();
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        tes.func_78376_a(color, color, color);
        tes.func_78374_a((double)x0, (double)y1, 0.0, (double)((float)x0 / 32.0f), (double)(((float)y1 + scroll) / 32.0f));
        tes.func_78374_a((double)x1, (double)y1, 0.0, (double)((float)x1 / 32.0f), (double)(((float)y1 + scroll) / 32.0f));
        tes.func_78374_a((double)x1, (double)y0, 0.0, (double)((float)x1 / 32.0f), (double)(((float)y0 + scroll) / 32.0f));
        tes.func_78374_a((double)x0, (double)y0, 0.0, (double)((float)x0 / 32.0f), (double)(((float)y0 + scroll) / 32.0f));
        tes.func_78381_a();
    }

    public static void renderListOverlay(int x0, int x1, int y0, int y1, int width, int height, BackgroundTexture texture) {
        Tessellator tes = Tessellator.field_78398_a;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.getForegroundTexture());
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)519);
        int color = texture.getForegroundBrightness();
        tes.func_78382_b();
        tes.func_78376_a(color, color, color);
        tes.func_78374_a((double)x0, (double)y0, -100.0, 0.0, (double)((float)y0 / 32.0f));
        tes.func_78374_a((double)(x0 + width), (double)y0, -100.0, (double)((float)width / 32.0f), (double)((float)y0 / 32.0f));
        tes.func_78374_a((double)(x0 + width), 0.0, -100.0, (double)((float)width / 32.0f), 0.0);
        tes.func_78374_a((double)x0, 0.0, -100.0, 0.0, 0.0);
        tes.func_78374_a((double)x0, (double)height, -100.0, 0.0, (double)((float)height / 32.0f));
        tes.func_78374_a((double)(x0 + width), (double)height, -100.0, (double)((float)width / 32.0f), (double)((float)height / 32.0f));
        tes.func_78374_a((double)(x0 + width), (double)y1, -100.0, (double)((float)width / 32.0f), (double)((float)y1 / 32.0f));
        tes.func_78374_a((double)x0, (double)y1, -100.0, 0.0, (double)((float)y1 / 32.0f));
        tes.func_78381_a();
        GL11.glDepthFunc((int)515);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)1);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)3553);
        tes.func_78382_b();
        tes.func_78370_a(0, 0, 0, 0);
        tes.func_78377_a((double)x0, (double)(y0 + 4), 0.0);
        tes.func_78377_a((double)x1, (double)(y0 + 4), 0.0);
        tes.func_78370_a(0, 0, 0, 255);
        tes.func_78377_a((double)x1, (double)y0, 0.0);
        tes.func_78377_a((double)x0, (double)y0, 0.0);
        tes.func_78377_a((double)x0, (double)y1, 0.0);
        tes.func_78377_a((double)x1, (double)y1, 0.0);
        tes.func_78370_a(0, 0, 0, 0);
        tes.func_78377_a((double)x1, (double)(y1 - 4), 0.0);
        tes.func_78377_a((double)x0, (double)(y1 - 4), 0.0);
        tes.func_78381_a();
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
    }
}

