/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.ISuggestionRenderer;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.screen.EditStringScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.CarbonEditBox;
import carbonconfiglib.utils.ParseResult;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class RegistryElement
extends ConfigElement {
    CarbonEditBox edit;
    ParseResult<Boolean> result;
    ISuggestionRenderer renderer;

    public RegistryElement(IValueNode value, ISuggestionRenderer renderer) {
        super(value);
        this.renderer = renderer;
    }

    public RegistryElement(IArrayNode array, IValueNode value, ISuggestionRenderer renderer) {
        super(array, value);
        this.renderer = renderer;
    }

    public RegistryElement(ICompoundNode compound, IValueNode value, ISuggestionRenderer renderer) {
        super(compound, value);
        this.renderer = renderer;
    }

    public static DataType createForType(Class<?> clz, String defaultValue) {
        ISuggestionRenderer renderer = ISuggestionRenderer.Registry.getRendererForType(clz);
        return new DataType(false, defaultValue, K -> new RegistryElement((IValueNode)K, renderer), (K, V) -> new RegistryElement((IArrayNode)K, (IValueNode)V, renderer), (K, V) -> new RegistryElement((ICompoundNode)K, (IValueNode)V, renderer));
    }

    @Override
    public void init() {
        super.init();
        if (this.isArray()) {
            this.edit = this.addChild(new CarbonEditBox(this.font, 0, 0, 130, 18), ConfigElement.GuiAlign.CENTER, 0);
            this.edit.func_146180_a(this.value.get());
            this.edit.setListener(T -> {
                this.edit.func_146193_g(0xE0E0E0);
                this.result = null;
                if (!T.isEmpty() && !(this.result = this.value.isValid((String)T)).getValue().booleanValue()) {
                    this.edit.func_146193_g(0xFF0000);
                    return;
                }
                this.value.set((String)T);
            });
        } else {
            this.addChild(new CarbonButton(0, 0, 72, 18, I18n.func_135052_a((String)"gui.carbonconfig.edit", (Object[])new Object[0]), this::onPress));
        }
    }

    private void onPress(GuiButton button) {
        this.mc.func_147108_a((GuiScreen)new EditStringScreen(this.mc.field_71462_r, this.name, this.value, this.owner.getCustomTexture()));
    }

    @Override
    protected int getMaxX(int prevMaxX) {
        return prevMaxX - (this.renderer == null ? 0 : 25);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.edit != null) {
            this.edit.tick();
        }
    }

    @Override
    public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        IChatComponent result;
        super.render(x, top, left, width, height, mouseX, mouseY, selected, partialTicks);
        if (this.renderer != null && (result = this.renderer.renderSuggestion(this.value.get(), left + 20, top)) != null && mouseX >= left + 20 && mouseX <= left + 40 && mouseY >= top && mouseY <= top + 20) {
            this.owner.addTooltips(result);
        }
        if (this.edit != null && this.edit.isMouseOver(mouseX, mouseY) && this.result != null && !this.result.getValue().booleanValue()) {
            this.owner.addTooltips(new ChatComponentText(this.result.getError().getMessage()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
        }
    }

    @Override
    public void updateValues() {
        if (this.edit != null) {
            this.edit.func_146180_a(this.value.get());
        }
    }
}

