/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.carbon;

import carbonconfiglib.api.IReloadMode;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.carbon.CarbonArray;
import carbonconfiglib.gui.impl.carbon.CarbonCompound;
import carbonconfiglib.gui.impl.carbon.CarbonValue;
import carbonconfiglib.gui.impl.carbon.IValueActions;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ConfigLeaf
implements IConfigNode {
    ConfigEntry<?> entry;
    IStructuredData data;
    IStructuredData.StructureType type;
    IReloadMode mode;
    IValueActions value;

    public ConfigLeaf(ConfigEntry<?> entry) {
        this.entry = entry;
        this.data = entry.getDataType();
        this.type = this.data.getDataType();
        this.mode = entry.getReloadState();
    }

    @Override
    public INode asNode() {
        if (this.value == null) {
            switch (this.type) {
                case COMPOUND: {
                    this.value = new CarbonCompound(this.mode, this.data.asCompound(), this.getName(), this.getTooltip(), this.entry.serialize(), this.entry.serializeDefault(), this.entry::canSetValue, () -> this.entry.getSuggestions(T -> true), this::save);
                    break;
                }
                case LIST: {
                    this.value = new CarbonArray(this.mode, this.data.asList(), this.getName(), this.getTooltip(), this.entry.serialize(), this.entry.serializeDefault(), this.entry::canSetValue, () -> this.entry.getSuggestions(T -> true), this::save);
                    break;
                }
                case SIMPLE: {
                    this.value = new CarbonValue(this.mode, this.getName(), this.getTooltip(), DataType.bySimple(this.entry.getDataType().asSimple()), this.entry.areSuggestionsForced(), () -> this.entry.getSuggestions(T -> true), this.entry.serialize(), this.entry.serializeDefault(), this.entry::canSetValue, this::save);
                }
            }
        }
        return this.value;
    }

    private void save(String value, IValueActions actions) {
        if (this.entry instanceof ConfigEntry.ParsedArray) {
            this.entry.deserializeValue(Helpers.removeLayer(value, 0));
            return;
        }
        this.entry.deserializeValue(value);
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged();
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        if (this.value != null) {
            this.value.setDefault();
        }
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
    }

    @Override
    public boolean requiresRestart() {
        return this.mode == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.mode == ReloadMode.WORLD;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public IChatComponent getName() {
        return IConfigNode.createLabel(this.entry.getKey());
    }

    @Override
    public IChatComponent getTooltip() {
        String limit;
        ChatComponentText comp = new ChatComponentText("");
        comp.func_150257_a(new ChatComponentText(this.entry.getKey()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
        String[] array = this.entry.getComment();
        if (array != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                comp.func_150258_a("\n").func_150258_a(array[i++]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY));
            }
        }
        if ((limit = this.entry.getLimitations()) != null && !limit.trim().isEmpty()) {
            comp.func_150258_a("\n").func_150257_a(new ChatComponentTranslation(limit, new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.BLUE)));
        }
        return comp;
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return this.type;
    }
}

