/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.api.IConfigProxy;
import carbonconfiglib.config.Config;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.impl.carbon.ConfigRoot;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.networking.carbon.ConfigRequestPacket;
import carbonconfiglib.networking.carbon.SaveConfigPacket;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.MultilinePolicy;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.PacketBuffer;
import speiger.src.collections.objects.lists.ObjectArrayList;

public class ModConfig
implements IModConfig {
    String modId;
    ConfigHandler handler;
    Config config;
    Path path;

    public ModConfig(String modId, ConfigHandler handler) {
        this(modId, handler, handler.getConfig(), handler.getConfigFile());
    }

    public ModConfig(String modId, ConfigHandler handler, Config config, Path path) {
        this.modId = modId;
        this.handler = handler;
        this.config = config;
        this.path = path;
    }

    @Override
    public boolean canCreateConfigs() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean createConfig(Path path) {
        Helpers.ensureFolder(path.getParent());
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(this.config.serialize(this.handler.getMultilinePolicy()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public IModConfig loadFromFile(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        Config copy = this.config.copy();
        try {
            ConfigHandler.load(this.handler, copy, Files.readAllLines(path), false);
            return new ModConfig(this.modId, this.handler, this.config, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IModConfig loadFromNetworking(UUID requestId, Consumer<Predicate<PacketBuffer>> network) {
        NetworkModConfig config = new NetworkModConfig(this.modId, this.handler, this.config.copy());
        CarbonConfig.NETWORK.sendToServer(new ConfigRequestPacket(requestId, this.handler.getConfigIdentifer()));
        network.accept(config);
        return config;
    }

    @Override
    public String getFileName() {
        return this.handler.getConfig().getName().concat(".cfg");
    }

    @Override
    public String getConfigName() {
        return this.handler.getSubFolder().isEmpty() ? this.handler.getConfig().getName() : this.handler.getConfigIdentifer();
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public boolean isDynamicConfig() {
        return this.handler.getProxy().isDynamicProxy();
    }

    @Override
    public boolean isLocalConfig() {
        return this.path == this.handler.getConfigFile();
    }

    @Override
    public List<IModConfig.IConfigTarget> getPotentialFiles() {
        ObjectArrayList<IModConfig.IConfigTarget> result = new ObjectArrayList<IModConfig.IConfigTarget>();
        for (IConfigProxy.IPotentialTarget iPotentialTarget : this.handler.getProxy().getPotentialConfigs()) {
            Path file = this.handler.createConfigFile(iPotentialTarget.getFolder());
            if (iPotentialTarget instanceof PerWorldProxy.WorldTarget) {
                result.add(new IModConfig.WorldConfigTarget((PerWorldProxy.WorldTarget)iPotentialTarget, file));
                continue;
            }
            result.add(new IModConfig.SimpleConfigTarget(iPotentialTarget, file));
        }
        return result;
    }

    @Override
    public ConfigType getConfigType() {
        return this.handler.getConfigType();
    }

    @Override
    public IConfigNode getRootNode() {
        return new ConfigRoot(this.config);
    }

    @Override
    public boolean isDefault() {
        return this.config.isDefault();
    }

    @Override
    public void restoreDefault() {
        this.config.resetDefault();
    }

    @Override
    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);){
            writer.write(this.config.serialize(this.handler.getMultilinePolicy()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class NetworkModConfig
    extends ModConfig
    implements Predicate<PacketBuffer> {
        public NetworkModConfig(String modId, ConfigHandler handler, Config config) {
            super(modId, handler, config, null);
        }

        @Override
        public boolean canCreateConfigs() {
            return false;
        }

        @Override
        public boolean test(PacketBuffer t) {
            try {
                ConfigHandler.load(this.handler, this.config, ObjectArrayList.wrap(t.func_150789_c(262144).split("\n")), false);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public void save() {
            CarbonConfig.NETWORK.sendToServer(new SaveConfigPacket(this.handler.getConfigIdentifer(), this.config.serialize(MultilinePolicy.DISABLED)));
        }
    }
}

