/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.forge.ForgeValue;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.IChatComponent;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.utils.ObjectLists;
import speiger.src.collections.utils.Stack;

public class ForgeArray
implements IArrayNode {
    IChatComponent name;
    IChatComponent tooltip;
    DataType type;
    ReloadMode mode;
    Function<String, ParseResult<?>> isValid;
    Supplier<List<ISuggestionProvider.Suggestion>> suggestions;
    Consumer<List<String>> saved;
    List<ForgeValue> values = new ObjectArrayList<ForgeValue>();
    Stack<List<String>> previous = new ObjectArrayList<List<String>>();
    List<String> currentValues;
    List<String> defaults;

    public ForgeArray(IChatComponent name, IChatComponent tooltip, ReloadMode mode, DataType type, List<String> value, List<String> defaultValue, Supplier<List<ISuggestionProvider.Suggestion>> suggestions, Function<String, ParseResult<?>> isValid, Consumer<List<String>> saved) {
        this.name = name;
        this.tooltip = tooltip;
        this.isValid = isValid;
        this.mode = mode;
        this.type = type;
        this.currentValues = value;
        this.previous.push(new ObjectArrayList<String>((Collection<String>)this.currentValues));
        this.defaults = defaultValue;
        this.suggestions = suggestions;
        this.saved = saved;
        this.reload();
    }

    public void save() {
        this.saved.accept(this.currentValues);
    }

    protected void reload() {
        this.values.clear();
        for (int i = 0; i < this.currentValues.size(); ++i) {
            this.values.add(new ForgeValue(this.name, this.tooltip, this.mode, this.type, this.currentValues.get(i), i >= this.defaults.size() ? null : this.defaults.get(i), () -> ObjectLists.empty(), this.isValid::apply, this::save));
        }
    }

    private void save(String value, ForgeValue entry) {
        int index = this.values.indexOf(entry);
        if (index == -1) {
            return;
        }
        this.currentValues.set(index, value);
    }

    protected List<String> getPrev() {
        return this.previous.top();
    }

    @Override
    public boolean isChanged() {
        return !this.getPrev().equals(this.currentValues);
    }

    @Override
    public boolean isDefault() {
        return this.currentValues.equals(this.defaults);
    }

    @Override
    public void setPrevious() {
        this.currentValues.clear();
        this.currentValues.addAll(this.getPrev());
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
        this.reload();
    }

    @Override
    public void setDefault() {
        this.currentValues.clear();
        this.currentValues.addAll(this.defaults);
        this.reload();
    }

    @Override
    public void moveDown(int index) {
        this.swapValues(index, index + 1);
    }

    @Override
    public void moveUp(int index) {
        this.swapValues(index, index - 1);
    }

    private void swapValues(int from, int to) {
        if (from >= this.values.size() || from < 0) {
            return;
        }
        if (to >= this.values.size() || to < 0) {
            return;
        }
        this.currentValues.set(from, this.currentValues.set(to, this.currentValues.get(from)));
        this.values.get(from).set(this.currentValues.get(from));
        this.values.get(to).set(this.currentValues.get(to));
    }

    @Override
    public void createTemp() {
        this.previous.push(new ObjectArrayList<String>((Collection<String>)this.currentValues));
        this.reload();
    }

    @Override
    public void apply() {
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
        int m = this.currentValues.size();
        for (int i = 0; i < m; ++i) {
            this.values.get(i).save();
        }
    }

    @Override
    public IStructuredData.StructureType getInnerType() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public IStructuredData.StructureType getNodeType() {
        return IStructuredData.StructureType.LIST;
    }

    @Override
    public boolean requiresRestart() {
        return this.mode == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.mode == ReloadMode.WORLD;
    }

    @Override
    public IChatComponent getName() {
        return this.name;
    }

    @Override
    public IChatComponent getTooltip() {
        return this.tooltip;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public INode get(int index) {
        return this.values.get(index);
    }

    @Override
    public List<ISuggestionProvider.Suggestion> getSuggestions() {
        return this.suggestions.get();
    }

    @Override
    public void createNode() {
        String value = this.defaults.isEmpty() ? this.type.getDefaultValue() : this.defaults.get(0);
        this.currentValues.add(value);
        this.values.add(new ForgeValue(this.name, this.tooltip, this.mode, this.type, value, null, () -> ObjectLists.empty(), this.isValid::apply, this::save));
    }

    @Override
    public void removeNode(int index) {
        this.values.remove(index);
        this.currentValues.remove(index);
    }

    @Override
    public int indexOf(INode value) {
        return this.values.indexOf(value);
    }
}

