/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.impl.forge.ForgeRoot;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.Event;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import speiger.src.collections.objects.utils.ObjectLists;

public class ForgeConfig
implements IModConfig {
    ModContainer container;
    Configuration config;
    String configName;

    public ForgeConfig(ModContainer container, Configuration config) {
        this(container, config, config.getConfigFile().toPath().getFileName().toString());
    }

    public ForgeConfig(ModContainer container, Configuration config, String configName) {
        this.container = container;
        this.config = config;
        this.configName = configName;
    }

    @Override
    public String getFileName() {
        return this.configName;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getModId() {
        return this.container.getModId();
    }

    @Override
    public boolean isDynamicConfig() {
        return false;
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.SHARED;
    }

    @Override
    public boolean isLocalConfig() {
        return true;
    }

    @Override
    public boolean isDefault() {
        return !this.scanConfigs(this::isNotDefault);
    }

    @Override
    public void restoreDefault() {
        for (String section : this.config.getCategoryNames()) {
            for (Property prop : this.config.getCategory(section).values()) {
                prop.setToDefault();
            }
        }
    }

    @Override
    public boolean canCreateConfigs() {
        return false;
    }

    @Override
    public boolean createConfig(Path path) {
        return false;
    }

    @Override
    public IConfigNode getRootNode() {
        return new ForgeRoot(this.config, this.configName);
    }

    @Override
    public List<IModConfig.IConfigTarget> getPotentialFiles() {
        return ObjectLists.empty();
    }

    @Override
    public IModConfig loadFromFile(Path path) {
        return null;
    }

    @Override
    public IModConfig loadFromNetworking(UUID requestId, Consumer<Predicate<PacketBuffer>> network) {
        return null;
    }

    @Override
    public void save() {
        boolean needsRestart = this.scanConfigs(this::hasRestartChanged);
        this.config.save();
        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.container.getModId(), null, Minecraft.func_71410_x().field_71441_e != null, needsRestart);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.getResult().equals((Object)Event.Result.DENY)) {
            MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.PostConfigChangedEvent(this.container.getModId(), null, Minecraft.func_71410_x().field_71441_e != null, needsRestart));
        }
    }

    private boolean scanConfigs(Predicate<Property> props) {
        for (String section : this.config.getCategoryNames()) {
            for (Property prop : this.config.getCategory(section).values()) {
                if (!props.test(prop)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRestartChanged(Property property) {
        return property.hasChanged() && property.requiresMcRestart();
    }

    private boolean isNotDefault(Property property) {
        return !property.isDefault();
    }

    public static Configuration copy(Configuration config) {
        Configuration newConfig = new Configuration();
        for (String entry : config.getCategoryNames()) {
            ForgeConfig.copy(config.getCategory(entry), newConfig.getCategory(entry));
        }
        return newConfig;
    }

    public static void copy(ConfigCategory category, ConfigCategory newCategory) {
        newCategory.setComment(category.getComment());
        newCategory.setLanguageKey(category.getLanguagekey());
        for (Map.Entry entry : category.entrySet()) {
            newCategory.put((String)entry.getKey(), ForgeConfig.copy((Property)entry.getValue()));
        }
        for (ConfigCategory child : category.getChildren()) {
            ForgeConfig.copy(child, new ConfigCategory(child.getName(), newCategory));
        }
    }

    public static Property copy(Property prop) {
        if (prop.isList()) {
            Property newProp = new Property(prop.getName(), prop.getStringList(), prop.getType());
            newProp.setDefaultValues(prop.getDefaults());
            newProp.comment = prop.comment;
            newProp.setLanguageKey(prop.getLanguageKey());
            newProp.setRequiresMcRestart(prop.requiresMcRestart());
            newProp.setRequiresWorldRestart(prop.requiresWorldRestart());
            newProp.setValidValues(prop.getValidValues());
            return newProp;
        }
        Property newProp = new Property(prop.getName(), prop.getStringList(), prop.getType());
        newProp.setDefaultValues(prop.getDefaults());
        newProp.comment = prop.comment;
        newProp.setLanguageKey(prop.getLanguageKey());
        newProp.setRequiresMcRestart(prop.requiresMcRestart());
        newProp.setRequiresWorldRestart(prop.requiresWorldRestart());
        newProp.setValidValues(prop.getValidValues());
        return newProp;
    }
}

