/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.impl.minecraft.MinecraftConfig;
import carbonconfiglib.utils.ParseResult;
import net.minecraft.world.GameRules;

public interface IGameRuleValue {
    public void set(String var1);

    public ParseResult<Boolean> isValid(String var1);

    public String get();

    public String getDefault();

    public String getDescriptionId();

    public DataType getType();

    public static IGameRuleValue bool(String key, GameRules rules) {
        return new BooleanEntry(key, rules);
    }

    public static class BooleanEntry
    implements IGameRuleValue {
        String key;
        boolean value;
        GameRules rules;

        private BooleanEntry(String key, GameRules rules) {
            this.key = key;
            this.value = rules.func_82766_b(key);
            this.rules = rules;
        }

        @Override
        public void set(String value) {
            this.value = Boolean.parseBoolean(value);
            this.rules.func_82764_b(this.key, Boolean.toString(this.value));
        }

        @Override
        public ParseResult<Boolean> isValid(String value) {
            return ParseResult.success(true);
        }

        @Override
        public String get() {
            return Boolean.toString(this.value);
        }

        @Override
        public String getDefault() {
            return String.valueOf(MinecraftConfig.DEFAULTS.func_82766_b(this.key));
        }

        @Override
        public String getDescriptionId() {
            return "gamerule." + this.key;
        }

        @Override
        public DataType getType() {
            return DataType.BOOLEAN;
        }
    }
}

