/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.gui.impl.minecraft.MinecraftRoot;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.networking.minecraft.RequestGameRulesPacket;
import carbonconfiglib.networking.minecraft.SaveGameRulesPacket;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.SaveFormatComparator;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectLinkedOpenHashMap;
import speiger.src.collections.objects.maps.impl.hash.Object2ObjectOpenHashMap;

public class MinecraftConfig
implements IModConfig {
    public static final GameRules DEFAULTS = new GameRules();
    private static final Map<String, Category> CATEOGIRES = MinecraftConfig.createCategories();
    protected GameRules current;
    List<IGameRuleValue> values = new ObjectArrayList<IGameRuleValue>();
    Map<Category, List<IGameRuleValue>> keys = new Object2ObjectLinkedOpenHashMap<Category, List<IGameRuleValue>>();

    public MinecraftConfig() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null || server.field_71305_c.length <= 0) {
            return;
        }
        WorldServer world = server.field_71305_c[0];
        if (world == null) {
            return;
        }
        this.setRules(world.func_72912_H().func_82574_x());
    }

    protected MinecraftConfig(GameRules current) {
        this.setRules(current);
    }

    protected void setRules(GameRules current) {
        this.current = current;
        this.collect();
    }

    private void collect() {
        for (String key : this.current.func_82763_b()) {
            this.add(key, IGameRuleValue.bool(key, this.current));
        }
    }

    private void add(String key, IGameRuleValue value) {
        this.keys.computeIfAbsent(CATEOGIRES.getOrDefault(key, Category.MODDED), T -> new ObjectArrayList()).add(value);
        this.values.add(value);
    }

    @Override
    public String getFileName() {
        return "level.dat";
    }

    @Override
    public String getConfigName() {
        return "Game Rules";
    }

    @Override
    public String getModId() {
        return "minecraft";
    }

    @Override
    public boolean isDynamicConfig() {
        return true;
    }

    @Override
    public boolean isLocalConfig() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() != null;
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.SERVER;
    }

    @Override
    public IConfigNode getRootNode() {
        return new MinecraftRoot(this.keys);
    }

    @Override
    public boolean isDefault() {
        for (IGameRuleValue value : this.values) {
            if (Objects.equals(value.get(), value.getDefault())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void restoreDefault() {
        for (IGameRuleValue value : this.values) {
            value.set(value.getDefault());
        }
    }

    @Override
    public List<IModConfig.IConfigTarget> getPotentialFiles() {
        ISaveFormat storage = Minecraft.func_71410_x().func_71359_d();
        Path basePath = Minecraft.func_71410_x().field_71412_D.toPath().resolve("saves");
        ObjectArrayList<IModConfig.IConfigTarget> folders = new ObjectArrayList<IModConfig.IConfigTarget>();
        try {
            for (SaveFormatComparator sum : storage.func_75799_b()) {
                try {
                    Path path = basePath.resolve(sum.func_75786_a()).resolve("level.dat");
                    if (Files.notExists(path, new LinkOption[0])) continue;
                    folders.add(new IModConfig.WorldConfigTarget(new PerWorldProxy.WorldTarget(sum, path.getParent(), path), path));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folders;
    }

    @Override
    public boolean canCreateConfigs() {
        return false;
    }

    @Override
    public boolean createConfig(Path path) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IModConfig loadFromFile(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            FileConfig fileConfig = new FileConfig(path, CompressedStreamTools.func_74796_a((InputStream)stream));
            return fileConfig;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IModConfig loadFromNetworking(UUID requestId, Consumer<Predicate<PacketBuffer>> network) {
        NetworkConfig config = new NetworkConfig();
        network.accept(config);
        CarbonConfig.NETWORK.sendToServer(new RequestGameRulesPacket(requestId));
        return config;
    }

    @Override
    public void save() {
        if (this.current == null) {
            return;
        }
        this.current.func_82768_a(this.current.func_82770_a());
    }

    public static Map<String, Category> createCategories() {
        EnumMap<Category, String[]> keys = new EnumMap<Category, String[]>(Category.class);
        keys.put(Category.CHAT, new String[]{"announceAdvancements", "logAdminCommands", "commandBlockOutput", "sendCommandFeedback", "showDeathMessages"});
        keys.put(Category.DROPS, new String[]{"doTileDrops", "doEntityDrops", "doMobLoot"});
        keys.put(Category.MISC, new String[]{"maxCommandChainLength", "reducedDebugInfo"});
        keys.put(Category.MOBS, new String[]{"mobGriefing", "maxEntityCramming"});
        keys.put(Category.PLAYER, new String[]{"spectatorsGenerateChunks", "disableElytraMovementCheck", "keepInventory", "naturalRegeneration", "spawnRadius", "doLimitedCrafting"});
        keys.put(Category.SPAWNING, new String[]{"doMobSpawning"});
        keys.put(Category.WORLD, new String[]{"doDaylightCycle", "randomTickSpeed", "doFireTick", "doWeatherCycle"});
        Object2ObjectOpenHashMap<String, Category> result = new Object2ObjectOpenHashMap<String, Category>();
        for (Map.Entry entry : keys.entrySet()) {
            Category key = entry.getKey();
            for (String value : (String[])entry.getValue()) {
                result.put(value, key);
            }
        }
        return result;
    }

    public static class NetworkConfig
    extends MinecraftConfig
    implements Predicate<PacketBuffer> {
        @Override
        public void save() {
            if (this.current == null) {
                return;
            }
            CarbonConfig.NETWORK.sendToServer(new SaveGameRulesPacket(this.current));
        }

        @Override
        public boolean test(PacketBuffer buffer) {
            try {
                this.setRules(FileConfig.parse(buffer.func_150793_b()));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    public static class FileConfig
    extends MinecraftConfig {
        Path file;
        NBTTagCompound tag;

        public FileConfig(Path file, NBTTagCompound tag) {
            super(FileConfig.parse(tag.func_74775_l("Data").func_74775_l("GameRules")));
            this.file = file;
            this.tag = tag;
        }

        private static GameRules parse(NBTTagCompound tag) {
            GameRules rules = new GameRules();
            rules.func_82768_a(tag);
            return rules;
        }

        @Override
        public void save() {
            this.tag.func_74775_l("Data").func_74782_a("GameRules", (NBTBase)this.current.func_82770_a());
            try (OutputStream stream = Files.newOutputStream(this.file, new OpenOption[0]);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.tag, (OutputStream)stream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static enum Category {
        CHAT("gamerule.category.chat"),
        DROPS("gamerule.category.drops"),
        MISC("gamerule.category.misc"),
        MOBS("gamerule.category.mobs"),
        PLAYER("gamerule.category.player"),
        SPAWNING("gamerule.category.spawning"),
        WORLD("gamerule.category.updates"),
        MODDED("gamerule.category.modded");

        String key;

        private Category(String key) {
            this.key = key;
        }

        public String getDescriptionId() {
            return this.key;
        }
    }
}

