/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.gui.impl.minecraft.MinecraftValue;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class MinecraftLeaf
implements IConfigNode {
    IGameRuleValue entry;
    MinecraftValue value;

    public MinecraftLeaf(IGameRuleValue entry) {
        this.entry = entry;
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public INode asNode() {
        if (this.value == null) {
            this.value = new MinecraftValue(this.entry);
        }
        return this.value;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        return this.value != null && this.value.isChanged();
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        if (this.value != null) {
            this.value.setDefault();
        }
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public boolean requiresReload() {
        return false;
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public IChatComponent getName() {
        return IConfigNode.createLabel(I18n.func_135052_a((String)this.entry.getDescriptionId(), (Object[])new Object[0]));
    }

    @Override
    public IChatComponent getTooltip() {
        String id = this.entry.getDescriptionId();
        ChatComponentText result = new ChatComponentText("");
        result.func_150257_a(new ChatComponentTranslation(id, new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
        id = id + ".description";
        if (I18n.func_135052_a((String)id, (Object[])new Object[0]) != id) {
            result.func_150258_a("\n").func_150257_a(new ChatComponentTranslation(id, new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)));
        }
        return result;
    }
}

