/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.minecraft;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.impl.minecraft.IGameRuleValue;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.utils.ObjectLists;

public class MinecraftValue
implements IValueNode {
    ObjectArrayList<String> previous = new ObjectArrayList();
    IGameRuleValue entry;
    String defaultValue;
    String current;

    public MinecraftValue(IGameRuleValue entry) {
        this.entry = entry;
        this.defaultValue = entry.getDefault();
        this.current = entry.get();
        this.previous.push(this.current);
    }

    public void save() {
        this.entry.set(this.current);
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.current, this.defaultValue);
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.previous.top(), this.current);
    }

    @Override
    public void setDefault() {
        this.current = this.defaultValue;
    }

    @Override
    public void setPrevious() {
        this.current = (String)this.previous.top();
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
    }

    @Override
    public void createTemp() {
        this.previous.push(this.current);
    }

    @Override
    public void apply() {
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
    }

    @Override
    public String get() {
        return this.current;
    }

    @Override
    public void set(String value) {
        this.current = value;
    }

    @Override
    public ParseResult<Boolean> isValid(String value) {
        return this.entry.isValid(value);
    }

    @Override
    public IStructuredData.StructureType getNodeType() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public boolean requiresReload() {
        return false;
    }

    @Override
    public IChatComponent getName() {
        return IConfigNode.createLabel(I18n.func_135052_a((String)this.entry.getDescriptionId(), (Object[])new Object[0]));
    }

    @Override
    public IChatComponent getTooltip() {
        String id = this.entry.getDescriptionId();
        ChatComponentText result = new ChatComponentText("");
        result.func_150257_a(new ChatComponentTranslation(id, new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
        id = id + ".description";
        if (I18n.func_135052_a((String)id, (Object[])new Object[0]) != id) {
            result.func_150258_a("\n").func_150257_a(new ChatComponentTranslation(id, new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)));
        }
        return result;
    }

    @Override
    public DataType getDataType() {
        return this.entry.getType();
    }

    @Override
    public boolean isForcingSuggestions() {
        return false;
    }

    @Override
    public List<ISuggestionProvider.Suggestion> getSuggestions() {
        return ObjectLists.empty();
    }
}

