/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ArrayElement;
import carbonconfiglib.gui.config.CompoundElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.CompoundScreen;
import carbonconfiglib.gui.screen.ListSelectionScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;

public class ArrayScreen
extends ListScreen {
    GuiScreen prev;
    IArrayNode array;
    IStructuredData.StructureType innerType;
    Runnable closeListener;

    public ArrayScreen(IArrayNode entry, GuiScreen prev, BackgroundTexture.BackgroundHolder customTexture) {
        super(entry.getName(), customTexture);
        this.prev = prev;
        this.array = entry;
        this.innerType = entry.getInnerType();
        this.array.createTemp();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m;
        this.addWidget(new CarbonButton(x - 92, y - 27, 80, 20, I18n.func_135052_a((String)"gui.carbonconfig.apply", (Object[])new Object[0]), this::apply));
        this.addWidget(new CarbonButton(x - 10, y - 27, 20, 20, "+", this::createEntry));
        this.addWidget(new CarbonButton(x + 12, y - 27, 80, 20, I18n.func_135052_a((String)"gui.carbonconfig.back", (Object[])new Object[0]), this::goBack));
    }

    @Override
    protected boolean shouldHaveTooltips() {
        return true;
    }

    @Override
    protected boolean shouldHaveSearch() {
        return false;
    }

    public void setAbortListener(Runnable run) {
        this.closeListener = run;
    }

    private void notifyClose() {
        this.array.setPrevious();
        if (this.closeListener == null) {
            return;
        }
        this.closeListener.run();
    }

    @Override
    public void onClose() {
        this.notifyClose();
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void apply(GuiButton button) {
        this.array.apply();
        this.field_146297_k.func_147108_a(this.prev);
    }

    private void goBack(GuiButton button) {
        if (this.array.isChanged()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((T, V) -> {
                if (T) {
                    this.array.setPrevious();
                }
                this.field_146297_k.func_147108_a((GuiScreen)(T ? this.prev : this));
            }, new ChatComponentTranslation("gui.carbonconfig.warn.changed", new Object[0]).func_150254_d(), new ChatComponentTranslation("gui.carbonconfig.warn.changed.desc", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)).func_150254_d(), 0));
            return;
        }
        this.array.setPrevious();
        this.field_146297_k.func_147108_a(this.prev);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        switch (this.innerType) {
            case COMPOUND: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    elements.accept(new CompoundElement(this.array, this.array.get(i).asCompound()));
                }
                break;
            }
            case LIST: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    elements.accept(new ArrayElement(this.array, this.array.get(i).asArray()));
                }
                break;
            }
            case SIMPLE: {
                int m = this.array.size();
                for (int i = 0; i < m; ++i) {
                    IValueNode node = this.array.get(i).asValue();
                    ConfigElement element = node.getDataType().create(this.array, node);
                    if (element == null) continue;
                    elements.accept(element);
                }
                break;
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = this.title.func_150254_d();
        this.field_146289_q.func_78276_b(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, 30, -1);
    }

    public void createEntry(GuiButton button) {
        int size = this.array.size();
        this.array.createNode();
        if (this.array.getSuggestions().size() > 0) {
            ListSelectionScreen screen = new ListSelectionScreen(this, this.array.get(size), this.innerType == IStructuredData.StructureType.COMPOUND ? ListSelectionScreen.NodeSupplier.ofCompound(this.array) : ListSelectionScreen.NodeSupplier.ofValue(), this.getCustomTexture());
            screen.withListener(() -> this.postCreate(size, true), () -> this.array.removeNode(size)).disableAbortWarning();
            this.field_146297_k.func_147108_a((GuiScreen)screen);
            return;
        }
        this.postCreate(size, false);
    }

    private void postCreate(int size, boolean reopen) {
        INode node = this.array.get(size);
        switch (node.getNodeType()) {
            case COMPOUND: {
                CompoundScreen compoundScreen = new CompoundScreen(node.asCompound(), this, this.getCustomTexture());
                compoundScreen.setAbortListener(() -> this.array.removeNode(size));
                this.field_146297_k.func_147108_a((GuiScreen)compoundScreen);
                this.lastScroll = Double.MAX_VALUE;
                break;
            }
            case LIST: {
                ArrayScreen arrayScreen = new ArrayScreen(node.asArray(), this, this.getCustomTexture());
                arrayScreen.setAbortListener(() -> this.array.removeNode(size));
                this.field_146297_k.func_147108_a((GuiScreen)arrayScreen);
                this.lastScroll = Double.MAX_VALUE;
                break;
            }
            case SIMPLE: {
                ConfigElement element = node.asValue().getDataType().create(this.array, node.asValue());
                if (element == null) break;
                this.addEntry(element);
                this.visibleList.addElement(element);
                this.visibleList.setScrollAmount(this.visibleList.getMaxScroll());
            }
        }
        if (reopen) {
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    @Override
    public void removeEntry(Element element) {
        int index = this.allEntries.indexOf(element);
        if (index == -1) {
            return;
        }
        this.visibleList.removeElement(element);
        this.allEntries.remove(index);
        this.array.removeNode(index);
        this.visibleList.setScrollAmount(this.visibleList.getScrollAmount());
    }
}

