/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ArrayElement;
import carbonconfiglib.gui.config.CompoundElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.FolderElement;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.config.SelectionElement;
import carbonconfiglib.gui.screen.MultiChoiceScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.CarbonEditBox;
import carbonconfiglib.gui.widgets.CarbonIconCheckbox;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import speiger.src.collections.objects.lists.ObjectArrayList;

public class ConfigScreen
extends ListScreen {
    private static final Comparator<Element> SORTER = (K, V) -> {
        int sort = (V instanceof FolderElement ? 1 : 0) - (K instanceof FolderElement ? 1 : 0);
        return sort != 0 ? sort : String.CASE_INSENSITIVE_ORDER.compare(K.getName(), V.getName());
    };
    GuiScreen parent;
    IModConfig config;
    IConfigNode node;
    CarbonIconCheckbox deepSearch;
    CarbonIconCheckbox onlyChanged;
    CarbonIconCheckbox onlyNonDefault;
    boolean wasChanged = false;
    Navigator nav;
    List<Element> cache = null;

    public ConfigScreen(Navigator nav, IModConfig config, GuiScreen parent) {
        this(nav, config, parent, BackgroundTexture.DEFAULT.asHolder());
    }

    public ConfigScreen(Navigator nav, IModConfig config, GuiScreen parent, BackgroundTexture.BackgroundHolder customTexture) {
        super((IChatComponent)new ChatComponentText(""), customTexture);
        this.nav = nav;
        this.config = config;
        this.node = config.getRootNode();
        this.parent = parent;
        this.nav.setScreenForLayer(this);
    }

    public ConfigScreen(Navigator nav, IConfigNode node, GuiScreen parent, BackgroundTexture.BackgroundHolder customTexture) {
        super((IChatComponent)new ChatComponentText(""), customTexture);
        this.nav = nav;
        this.node = node;
        this.parent = parent;
        this.nav.setScreenForLayer(this);
    }

    @Override
    public void func_73866_w_() {
        String walkNode;
        super.func_73866_w_();
        int x = this.field_146294_l / 2 - 100;
        int y = this.field_146295_m;
        if (this.node.isRoot()) {
            this.addWidget(new CarbonButton(x - 51, y - 27, 100, 20, I18n.func_135052_a((String)"gui.carbonconfig.save", (Object[])new Object[0]), this::save));
            this.addWidget(new CarbonButton(x + 51, y - 27, 100, 20, I18n.func_135052_a((String)"gui.carbonconfig.reset", (Object[])new Object[0]), this::reset));
            this.addWidget(new CarbonButton(x + 153, y - 27, 100, 20, I18n.func_135052_a((String)"gui.carbonconfig.back", (Object[])new Object[0]), this::goBack));
        } else {
            this.addWidget(new CarbonButton(x + 101, y - 27, 100, 20, I18n.func_135052_a((String)"gui.carbonconfig.back", (Object[])new Object[0]), this::goBack));
            this.addWidget(new CarbonButton(x - 1, y - 27, 100, 20, I18n.func_135052_a((String)"gui.carbonconfig.home", (Object[])new Object[0]), this::goToRoot));
        }
        if (this.shouldHaveSearch()) {
            this.deepSearch = this.addWidget(new CarbonIconCheckbox(x + 205, 25, 20, 20, Icon.SEARCH_SELECTED, Icon.SEARCH, false).withListener(this::onDeepSearch).setTooltip(this, "gui.carbonconfig.deepsearch"));
            this.onlyChanged = this.addWidget(new CarbonIconCheckbox(x + 227, 25, 20, 20, Icon.SET_DEFAULT, Icon.REVERT, false).withListener(this::onChangedButton).setTooltip(this, "gui.carbonconfig.changed_only"));
            this.onlyNonDefault = this.addWidget(new CarbonIconCheckbox(x + 249, 25, 20, 20, Icon.NOT_DEFAULT_SELECTED, Icon.NOT_DEFAULT, false).withListener(this::onDefaultButton).setTooltip(this, "gui.carbonconfig.default_only"));
        }
        if ((walkNode = this.nav.getWalkNode()) != null) {
            FolderElement element = this.getElement(walkNode);
            if (element != null) {
                element.onPress(null);
            }
            this.nav.consumeWalker();
        }
    }

    private void onDeepSearch() {
        if (this.onlyChanged.selected() || this.onlyNonDefault.selected()) {
            this.deepSearch.setSelected(false);
        } else {
            this.wasChanged = true;
        }
    }

    private void onChangedButton() {
        this.deepSearch.setSelected(false);
        this.onlyNonDefault.setSelected(false);
    }

    private void onDefaultButton() {
        this.deepSearch.setSelected(false);
        this.onlyChanged.setSelected(false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.shouldHaveSearch() && (this.onlyChanged.selected() || this.onlyNonDefault.selected() || this.wasChanged)) {
            this.onSearchChange(this.searchBox, this.searchBox.func_146179_b().toLowerCase(Locale.ROOT));
            this.wasChanged = this.onlyChanged.selected() || this.onlyNonDefault.selected();
        }
    }

    @Override
    public void handleForground(int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawScrollingString(this.field_146289_q, this.nav.getHeader(), 50.0f, 6.0f, this.field_146294_l - 100, 10.0f, ConfigElement.GuiAlign.CENTER, -1, 0);
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        if (mouseX >= 50.0 && mouseX <= (double)(this.field_146294_l - 100) && mouseY >= 6.0 && mouseY <= 16.0) {
            float scroll = GuiUtils.calculateScrollOffset(this.field_146294_l - 100, this.field_146289_q, ConfigElement.GuiAlign.CENTER, this.nav.getHeader(), 0);
            GuiScreen screen = this.nav.getScreen(this.field_146289_q, (int)(mouseX - (double)ConfigElement.GuiAlign.CENTER.align(50, this.field_146294_l - 100, this.field_146289_q.func_78256_a(this.nav.getHeader())) - (double)scroll));
            if (screen instanceof ConfigScreen) {
                this.field_146297_k.func_147108_a(screen);
                return true;
            }
            if (screen != null) {
                this.leave();
                return true;
            }
        }
        return super.mouseClick(mouseX, mouseY, button);
    }

    @Override
    protected List<Element> sortElements(List<Element> list) {
        list.sort(SORTER);
        return list;
    }

    private void goToRoot(GuiButton button) {
        ConfigScreen prev = this;
        ConfigScreen parent = this;
        while (parent instanceof ConfigScreen) {
            prev = parent;
            parent = parent.parent;
        }
        if (prev != this) {
            this.field_146297_k.func_147108_a((GuiScreen)prev);
        }
    }

    private void leave() {
        ConfigScreen prev = this;
        ConfigScreen parent = this;
        while (parent instanceof ConfigScreen) {
            prev = parent;
            parent = parent.parent;
        }
        if (prev != this) {
            GuiScreen toOpen = prev.parent;
            if (this.node.isRoot() && prev.isChanged()) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((T, K) -> this.field_146297_k.func_147108_a((GuiScreen)(T ? toOpen : this)), new ChatComponentTranslation("gui.carbonconfig.warn.changed", new Object[0]).func_150254_d(), new ChatComponentTranslation("gui.carbonconfig.warn.changed.desc", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)).func_150254_d(), 0));
                return;
            }
            this.field_146297_k.func_147108_a(toOpen);
        }
    }

    private void reset(GuiButton button) {
        this.field_146297_k.func_147108_a((GuiScreen)new MultiChoiceScreen(T -> {
            if (T.isMain()) {
                this.processAction(IConfigNode::setDefault);
            } else if (T.isOther()) {
                this.processAction(IConfigNode::setPrevious);
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }, (IChatComponent)new ChatComponentTranslation("gui.carbonconfig.reset_all.title", new Object[0]), new ChatComponentTranslation("gui.carbonconfig.reset_all.message", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)), (IChatComponent)new ChatComponentTranslation("gui.carbonconfig.reset_all.default", new Object[0]), (IChatComponent)new ChatComponentTranslation("gui.carbonconfig.reset_all.reset", new Object[0]), (IChatComponent)new ChatComponentTranslation("gui.carbonconfig.reset_all.cancel", new Object[0])));
    }

    private void save(GuiButton button) {
        List<IConfigNode> value = this.processedChanged(IConfigNode::save);
        this.config.save();
        if (this.findFirst(IConfigNode::requiresRestart, value)) {
            MultiChoiceScreen choice = new MultiChoiceScreen(T -> this.field_146297_k.func_147108_a(this.parent), (IChatComponent)new ChatComponentTranslation("gui.carbonconfig.restart.title", new Object[0]), new ChatComponentTranslation("gui.carbonconfig.restart.message", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)), (IChatComponent)new ChatComponentTranslation("gui.carbonconfig.ok", new Object[0]));
            this.field_146297_k.func_147108_a((GuiScreen)choice);
            return;
        }
        if (this.field_146297_k.field_71441_e != null && this.findFirst(IConfigNode::requiresReload, value)) {
            MultiChoiceScreen choice = new MultiChoiceScreen(T -> this.field_146297_k.func_147108_a(this.parent), (IChatComponent)new ChatComponentTranslation("gui.carbonconfig.reload.title", new Object[0]), new ChatComponentTranslation("gui.carbonconfig.reload.message", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)), (IChatComponent)new ChatComponentTranslation("gui.carbonconfig.ok", new Object[0]));
            this.field_146297_k.func_147108_a((GuiScreen)choice);
            return;
        }
        this.field_146297_k.func_147108_a(this.parent);
    }

    private <T> boolean findFirst(Predicate<T> filter, List<T> elements) {
        int m = elements.size();
        for (int i = 0; i < m; ++i) {
            if (!filter.test(elements.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<IConfigNode> processedChanged(Consumer<IConfigNode> action) {
        ObjectArrayList<IConfigNode> output = new ObjectArrayList<IConfigNode>();
        LinkedList<IConfigNode> nodes = new LinkedList<IConfigNode>();
        nodes.push(this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.pop();
            if (!node.isLeaf()) {
                node.getChildren().forEach(nodes::push);
                continue;
            }
            if (!node.isChanged()) continue;
            action.accept(node);
            output.add(node);
        }
        return output;
    }

    private void processAction(Consumer<IConfigNode> action) {
        LinkedList<IConfigNode> nodes = new LinkedList<IConfigNode>();
        nodes.push(this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.pop();
            if (!node.isLeaf()) {
                node.getChildren().forEach(nodes::push);
                continue;
            }
            action.accept(node);
        }
    }

    @Override
    protected void onSearchChange(CarbonEditBox box, String value) {
        if (!(this.deepSearch.selected() && !value.isEmpty() || this.onlyChanged.selected() || this.onlyNonDefault.selected())) {
            super.onSearchChange(box, value);
            return;
        }
        if (this.cache == null) {
            this.cache = this.sortElements(ConfigScreen.getAllElements(this.node));
            this.cache.forEach(this::addInternal);
        }
        if (this.onlyNonDefault.selected()) {
            ObjectArrayList<Element> subCache = new ObjectArrayList<Element>();
            for (Element element : this.cache) {
                if (element.isDefault()) continue;
                subCache.add(element);
            }
            super.onSearchChange(box, value, subCache);
            return;
        }
        if (this.onlyChanged.selected()) {
            ObjectArrayList<Element> subCache = new ObjectArrayList<Element>();
            for (Element element : this.cache) {
                if (!element.isChanged()) continue;
                subCache.add(element);
            }
            super.onSearchChange(box, value, subCache);
            return;
        }
        super.onSearchChange(box, value, this.cache);
    }

    private void goBack(GuiButton button) {
        if (this.node.isRoot() && this.isChanged()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                public void func_73878_a(boolean result, int p_73878_2_) {
                    ConfigScreen.this.field_146297_k.func_147108_a((GuiScreen)(result ? ConfigScreen.this.parent : ConfigScreen.this));
                }
            }, new ChatComponentTranslation("gui.carbonconfig.warn.changed", new Object[0]).func_150254_d(), new ChatComponentTranslation("gui.carbonconfig.warn.changed.desc", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)).func_150254_d(), 0));
            return;
        }
        this.field_146297_k.func_147108_a(this.parent);
    }

    private boolean isChanged() {
        LinkedList<IConfigNode> nodes = new LinkedList<IConfigNode>();
        nodes.push(this.node);
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.pop();
            if (!node.isLeaf()) {
                node.getChildren().forEach(nodes::push);
                continue;
            }
            if (!node.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getListWidth() {
        return 340;
    }

    @Override
    protected int getScrollPadding() {
        return 175;
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (IConfigNode child : this.node.getChildren()) {
            if (child.isLeaf()) {
                switch (child.getDataStructure()) {
                    case COMPOUND: {
                        elements.accept(new CompoundElement(INode.asCompound(child)));
                        break;
                    }
                    case LIST: {
                        elements.accept(new ArrayElement(INode.asArray(child)));
                        break;
                    }
                    case SIMPLE: {
                        IValueNode node = INode.asValue(child);
                        if (node == null) break;
                        if (node.isForcingSuggestions()) {
                            elements.accept(new SelectionElement(node));
                            break;
                        }
                        ConfigElement element = node.getDataType().create(node);
                        if (element == null) break;
                        elements.accept(element);
                    }
                }
                continue;
            }
            elements.accept(new FolderElement(child, this.nav));
        }
    }

    private static List<Element> getAllElements(IConfigNode initGui) {
        LinkedList<IConfigNode> nodes = new LinkedList<IConfigNode>();
        nodes.push(initGui);
        ObjectArrayList<Element> results = new ObjectArrayList<Element>();
        while (!nodes.isEmpty()) {
            IConfigNode node = (IConfigNode)nodes.pop();
            if (!node.isLeaf()) {
                node.getChildren().forEach(nodes::push);
                continue;
            }
            switch (node.getDataStructure()) {
                case COMPOUND: {
                    results.add(new CompoundElement(INode.asCompound(node)));
                    break;
                }
                case LIST: {
                    results.add(new ArrayElement(INode.asArray(node)));
                    break;
                }
                case SIMPLE: {
                    IValueNode value = INode.asValue(node);
                    if (value == null) break;
                    if (value.isForcingSuggestions()) {
                        results.add(new SelectionElement(value));
                        break;
                    }
                    ConfigElement element = value.getDataType().create(value);
                    if (element == null) break;
                    results.add(element);
                }
            }
        }
        return results;
    }

    public FolderElement getElement(String name) {
        for (Element element : this.allEntries) {
            FolderElement folder;
            if (!(element instanceof FolderElement) || (folder = (FolderElement)element).getNode() == null || !name.equalsIgnoreCase(folder.getNode().getNodeName())) continue;
            return folder;
        }
        return null;
    }

    public static class Navigator {
        private static final IChatComponent SPLITTER = new ChatComponentText(" > ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD).func_150227_a(Boolean.valueOf(true)));
        List<String> layer = new ObjectArrayList<String>();
        List<GuiScreen> screenByIndex = new ObjectArrayList<GuiScreen>();
        List<String> walker = null;
        String buildCache = null;

        private Navigator() {
        }

        public Navigator(IChatComponent base) {
            this.layer.add(base.func_150254_d());
        }

        public static Navigator create(IModConfig config) {
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(config.getModId());
            Navigator nav = new Navigator((IChatComponent)new ChatComponentText(container == null ? "Unknown" : container.getName()));
            nav.setScreenForLayer(null);
            return nav.add((IChatComponent)new ChatComponentTranslation("gui.carbonconfig.type." + config.getConfigType().name().toLowerCase(), new Object[0]));
        }

        public Navigator add(IChatComponent name) {
            return this.add(name, null);
        }

        public Navigator add(IChatComponent name, String walkerEntry) {
            Navigator nav = new Navigator();
            nav.layer.addAll(this.layer);
            nav.screenByIndex.addAll(this.screenByIndex);
            nav.layer.add(name.func_150254_d());
            if (this.walker != null && this.walker.size() > 1 && walkerEntry != null && this.walker.indexOf(walkerEntry.toLowerCase(Locale.ROOT)) == 0) {
                nav.walker = new ObjectArrayList<String>();
                for (int i = 1; i < this.walker.size(); ++i) {
                    nav.walker.add(this.walker.get(i));
                }
            }
            return nav;
        }

        public Navigator withWalker(String ... traversePath) {
            this.walker = new ObjectArrayList<String>();
            for (String path : traversePath) {
                this.walker.add(path.toLowerCase(Locale.ROOT));
            }
            return this;
        }

        public void setScreenForLayer(GuiScreen owner) {
            if (this.layer.size() > this.screenByIndex.size()) {
                this.screenByIndex.add(owner);
            } else {
                this.screenByIndex.set(this.layer.size() - 1, owner);
            }
        }

        public GuiScreen getScreen(FontRenderer font, int x) {
            int splitterWidth = font.func_78256_a(SPLITTER.func_150254_d());
            int m = this.layer.size();
            for (int i = 0; i < m; ++i) {
                int width = font.func_78256_a(this.layer.get(i));
                if (x >= 0 && x <= width) {
                    return this.screenByIndex.get(i);
                }
                x -= width;
                x -= splitterWidth;
            }
            return null;
        }

        protected void consumeWalker() {
            this.walker = null;
        }

        protected String getWalkNode() {
            return this.walker == null ? null : this.walker.get(0);
        }

        public String getHeader() {
            if (this.buildCache == null) {
                StringBuilder builder = new StringBuilder();
                String splitter = SPLITTER.func_150254_d();
                int m = this.layer.size();
                for (int i = 0; i < m; ++i) {
                    builder.append(this.layer.get(i));
                    if (i == m - 1) continue;
                    builder.append(splitter);
                }
                this.buildCache = builder.toString();
            }
            return this.buildCache;
        }
    }
}

