/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.IModConfigs;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.IIgnoreSearch;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.ConfigScreen;
import carbonconfiglib.gui.screen.RequestScreen;
import carbonconfiglib.gui.screen.SelectFileScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.CarbonIconButton;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.Icon;
import carbonconfiglib.gui.widgets.screen.IInteractable;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import speiger.src.collections.objects.lists.ObjectArrayList;

public class ConfigSelectorScreen
extends ListScreen {
    IModConfigs configs;
    GuiScreen parent;
    IChatComponent modName;
    Label toAdd;

    public ConfigSelectorScreen(IModConfigs configs, GuiScreen parent) {
        this(configs, configs.getBackground(), parent);
    }

    public ConfigSelectorScreen(IModConfigs configs, BackgroundTexture.BackgroundHolder customTexture, GuiScreen parent) {
        super((IChatComponent)new ChatComponentTranslation("gui.carbonconfig.select_config", new Object[0]), customTexture);
        this.configs = configs;
        this.parent = parent;
        this.modName = new ChatComponentText(configs.getModName());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m;
        this.addWidget(new CarbonButton(x - 80, y - 27, 160, 20, I18n.func_135052_a((String)"gui.carbonconfig.back", (Object[])new Object[0]), T -> this.onClose()));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String modName = this.modName.func_150254_d();
        this.field_146289_q.func_78276_b(modName, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(modName) / 2, 8, -1);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        this.toAdd = new Label(new ChatComponentTranslation("gui.carbonconfig.configs.local", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD).func_150227_a(Boolean.valueOf(true))));
        this.addConfigs(ConfigType.CLIENT, false, elements);
        this.addConfigs(ConfigType.SHARED, false, elements);
        this.toAdd = null;
        if (this.field_146297_k.field_71441_e != null) {
            if (!this.field_146297_k.func_71387_A()) {
                if (!this.isInstalledOnServer()) {
                    return;
                }
                if (this.isLanServer()) {
                    return;
                }
                if (!CarbonConfig.NETWORK.hasPermissions()) {
                    return;
                }
                this.toAdd = new Label(new ChatComponentTranslation("gui.carbonconfig.configs.multiplayer", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD).func_150227_a(Boolean.valueOf(true))));
                this.addConfigs(ConfigType.SHARED, true, elements);
            } else {
                this.toAdd = new Label(new ChatComponentTranslation("gui.carbonconfig.configs.world", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD).func_150227_a(Boolean.valueOf(true))));
            }
        } else {
            this.toAdd = new Label(new ChatComponentTranslation("gui.carbonconfig.configs.world", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD).func_150227_a(Boolean.valueOf(true))));
        }
        this.addConfigs(ConfigType.SERVER, true, elements);
        this.toAdd = null;
    }

    private void addConfigs(ConfigType type, boolean multiplayer, Consumer<Element> elements) {
        this.configs.getConfigInstances(type).forEach(T -> {
            if (this.toAdd != null) {
                elements.accept(this.toAdd);
                this.toAdd = null;
            }
            elements.accept(new DirectConfig((IModConfig)T, this.modName, this, multiplayer));
        });
    }

    @Override
    public void onClose() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    private boolean isInstalledOnServer() {
        return CarbonConfig.NETWORK.isInstalledOnServer();
    }

    private boolean isLanServer() {
        ServerData data = this.field_146297_k.func_147104_D();
        return data != null && data.func_152585_d();
    }

    public static class DirectConfig
    extends Element {
        List<IInteractable> children = new ObjectArrayList<IInteractable>();
        GuiScreen parent;
        IModConfig handler;
        CarbonButton button;
        CarbonIconButton reset;
        boolean multi;
        boolean multiplayer;
        ConfigScreen.Navigator nav;
        IChatComponent type;
        IChatComponent fileName;
        IChatComponent baseName;

        public DirectConfig(IModConfig handler, IChatComponent baseName, GuiScreen parent, boolean multiplayer) {
            super((IChatComponent)new ChatComponentText(handler.getFileName()));
            this.nav = new ConfigScreen.Navigator(baseName);
            this.nav.setScreenForLayer(parent);
            this.handler = handler;
            this.baseName = baseName;
            this.parent = parent;
            this.multiplayer = multiplayer;
        }

        @Override
        public void init() {
            this.multi = this.shouldCreatePick();
            if (this.multi) {
                this.button = new CarbonButton(0, 0, 82, 20, I18n.func_135052_a((String)"gui.carbonconfig.pick_file", (Object[])new Object[0]), this::onPick);
                this.children.add(this.button);
            } else {
                this.button = new CarbonButton(0, 0, 60, 20, I18n.func_135052_a((String)"gui.carbonconfig.modify", (Object[])new Object[0]), this::onEdit);
                this.reset = new CarbonIconButton(0, 0, 20, 20, Icon.REVERT, "", this::reset).setIconOnly();
                this.reset.field_146124_l = !this.handler.isDefault() && !this.isInWorldConfig();
                this.children.add(this.button);
                this.children.add(this.reset);
            }
            this.type = new ChatComponentTranslation("gui.carbonconfig.type." + this.handler.getConfigType().name().toLowerCase(), new Object[0]);
            this.fileName = new ChatComponentText(this.handler.getFileName()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY));
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.field_146128_h = left + width - 82;
            this.button.field_146129_i = top + 2;
            this.button.render(this.mc, mouseX, mouseY, partialTicks);
            if (this.reset != null) {
                this.reset.field_146128_h = left + width - 20;
                this.reset.field_146129_i = top + 2;
                this.reset.render(this.mc, mouseX, mouseY, partialTicks);
            }
            GuiUtils.drawScrollingString(this.font, this.type.func_150254_d(), left + 5, top, 130.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawScrollingString(this.font, this.fileName.func_150254_d(), left + 5, top + 9, 130.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawTextureRegion(left - 20, top, 22.0f, 22.0f, this.getIcon(), 16.0f, 16.0f);
        }

        @Override
        public List<? extends IInteractable> children() {
            return this.children;
        }

        private boolean shouldCreatePick() {
            return this.handler.isDynamicConfig() && !this.isInWorldConfig();
        }

        private boolean isInWorldConfig() {
            return this.mc.field_71441_e != null && (this.handler.getConfigType() == ConfigType.SERVER || this.handler.getConfigType() == ConfigType.SHARED && this.multiplayer);
        }

        private Icon getIcon() {
            return (this.multi ? Icon.MULTITYPE_ICON : Icon.TYPE_ICON).get((Object)this.handler.getConfigType());
        }

        private void onPick(GuiButton button) {
            this.mc.func_147108_a((GuiScreen)new SelectFileScreen(this.baseName, this.owner.getCustomTexture(), this.parent, this.handler));
        }

        private void reset(CarbonIconButton button) {
            this.handler.restoreDefault();
            this.handler.save();
            this.reset.field_146124_l = !this.handler.isDefault();
        }

        private void onEdit(GuiButton button) {
            if (this.isInWorldConfig() && !this.mc.func_71387_A()) {
                this.mc.func_147108_a((GuiScreen)new RequestScreen(this.owner.getCustomTexture(), this.nav.add(this.type), this.parent, this.handler));
            } else {
                this.mc.func_147108_a((GuiScreen)new ConfigScreen(this.nav.add(this.type), this.handler, this.parent, this.owner.getCustomTexture()));
            }
        }
    }

    public static class Label
    extends Element
    implements IIgnoreSearch {
        public Label(IChatComponent name) {
            super(name);
        }

        @Override
        public boolean shouldIgnoreSearch() {
            return true;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.renderText(this.name, left, top + 1, width, height, ConfigElement.GuiAlign.CENTER, -1);
        }
    }
}

