/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.ISuggestionRenderer;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ElementList;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ListSelectionScreen
extends ListScreen {
    INode node;
    NodeSupplier supplier;
    GuiScreen parent;
    GuiButton apply;
    Runnable abortListener;
    Runnable successListener;
    boolean dontWarn;

    public ListSelectionScreen(GuiScreen parent, INode node, NodeSupplier supplier, BackgroundTexture.BackgroundHolder customTexture) {
        super(node.getName(), customTexture);
        this.parent = parent;
        this.supplier = supplier;
        this.node = node;
        this.node.createTemp();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.visibleList.setRenderSelection(true);
        this.loadDefault();
        this.visibleList.setCallback(T -> this.setValue(((SelectionElement)T).getSuggestion().getValue()));
        int x = this.field_146294_l / 2 - 100;
        int y = this.field_146295_m;
        this.apply = this.addWidget(new CarbonButton(x + 10, y - 27, 85, 20, I18n.func_135052_a((String)"gui.carbonconfig.pick", (Object[])new Object[0]), this::save));
        this.addWidget(new CarbonButton(x + 105, y - 27, 85, 20, I18n.func_135052_a((String)"gui.carbonconfig.cancel", (Object[])new Object[0]), this::cancel));
    }

    public ListSelectionScreen withListener(Runnable success, Runnable abort) {
        this.successListener = success;
        this.abortListener = abort;
        return this;
    }

    public ListSelectionScreen disableAbortWarning() {
        this.dontWarn = true;
        return this;
    }

    protected void loadDefault() {
        this.findDefault(this.supplier.getValue(this.node));
    }

    protected void setValue(String value) {
        this.supplier.setValue(this.node, value);
    }

    protected void findDefault(String defaultValue) {
        for (Element element : this.allEntries) {
            if (!((SelectionElement)element).getSuggestion().getValue().equals(defaultValue)) continue;
            this.visibleList.setSelected(element);
            break;
        }
        this.visibleList.scrollToSelected(true);
    }

    @Override
    protected List<Element> sortElements(List<Element> list) {
        list.sort(Comparator.comparing(Element::getName, String.CASE_INSENSITIVE_ORDER));
        return list;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.apply.field_146124_l = this.node.isChanged();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String title = this.title.func_150254_d();
        this.field_146289_q.func_78276_b(title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(title) / 2, 8, -1);
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (ISuggestionProvider.Suggestion entry : this.supplier.getSuggestions(this.node)) {
            elements.accept(new SelectionElement(entry, this.visibleList));
        }
    }

    @Override
    public void onClose() {
        this.abort();
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void save(GuiButton button) {
        this.node.apply();
        if (this.successListener != null) {
            this.successListener.run();
        } else {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    private void cancel(GuiButton button) {
        if (this.node.isChanged() && !this.dontWarn) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((T, V) -> {
                if (T) {
                    this.abort();
                }
                this.field_146297_k.func_147108_a((GuiScreen)(T ? this.parent : this));
            }, new ChatComponentTranslation("gui.carbonconfig.warn.changed", new Object[0]).func_150254_d(), new ChatComponentTranslation("gui.carbonconfig.warn.changed.desc", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)).func_150254_d(), 0));
            return;
        }
        this.abort();
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void abort() {
        this.node.setPrevious();
        if (this.abortListener != null) {
            this.abortListener.run();
        }
    }

    private class SelectionElement
    extends Element {
        ISuggestionProvider.Suggestion suggestion;
        ElementList myList;
        int lastClick;
        ISuggestionRenderer renderer;
        boolean loaded;

        public SelectionElement(ISuggestionProvider.Suggestion suggestion, ElementList list) {
            super((IChatComponent)new ChatComponentTranslation(suggestion.getName(), new Object[0]));
            this.lastClick = -1;
            this.loaded = false;
            this.suggestion = suggestion;
            this.myList = list;
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            IChatComponent comp;
            ISuggestionRenderer renderer = this.getRenderer();
            if (renderer != null && (comp = renderer.renderSuggestion(this.suggestion.getValue(), left, top)) != null && mouseX >= left && mouseX <= left + 20 && mouseY >= top && mouseY <= top + 20) {
                this.owner.addTooltips(comp);
            }
            this.renderText(new ChatComponentText("").func_150255_a(new ChatStyle().func_150238_a(this.myList.getSelected() == this ? EnumChatFormatting.YELLOW : EnumChatFormatting.WHITE)).func_150257_a(this.name), left + (renderer != null ? 20 : 0), top, width - 5, height - 1, ConfigElement.GuiAlign.LEFT, -1);
        }

        private ISuggestionRenderer getRenderer() {
            if (this.loaded) {
                return this.renderer;
            }
            this.loaded = true;
            if (this.suggestion.getType() != null) {
                this.renderer = ISuggestionRenderer.Registry.getRendererForType(this.suggestion.getType());
            }
            return this.renderer;
        }

        public ISuggestionProvider.Suggestion getSuggestion() {
            return this.suggestion;
        }

        @Override
        public boolean mouseClick(double p_94737_, double p_94738_, int p_94739_) {
            if (this.myList.getSelected() == this) {
                if (this.lastClick >= 0 && this.myList.getLastTick() - this.lastClick <= 5) {
                    ListSelectionScreen.this.save(null);
                    return true;
                }
                this.lastClick = this.myList.getLastTick();
            } else {
                this.lastClick = this.myList.getLastTick();
            }
            this.myList.setSelected(this);
            return true;
        }
    }

    public static class NodeSupplier {
        Function<INode, String> getter;
        BiConsumer<INode, String> setter;
        Function<INode, List<ISuggestionProvider.Suggestion>> provider;

        private NodeSupplier(Function<INode, String> getter, BiConsumer<INode, String> setter, Function<INode, List<ISuggestionProvider.Suggestion>> provider) {
            this.getter = getter;
            this.setter = setter;
            this.provider = provider;
        }

        public static NodeSupplier ofValue() {
            return new NodeSupplier(T -> T.asValue().get(), (N, S) -> N.asValue().set((String)S), T -> T.asValue().getSuggestions());
        }

        public static NodeSupplier ofCompound(IArrayNode node) {
            return new NodeSupplier(T -> T.asCompound().get(), (N, S) -> N.asCompound().set((String)S), T -> node.getSuggestions());
        }

        public String getValue(INode node) {
            return this.getter.apply(node);
        }

        public List<ISuggestionProvider.Suggestion> getSuggestions(INode node) {
            return this.provider.apply(node);
        }

        public void setValue(INode node, String value) {
            this.setter.accept(node, value);
        }
    }
}

