/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.screen.CarbonScreen;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;

public class MultiChoiceScreen
extends CarbonScreen {
    protected IChatComponent title;
    private final IChatComponent message;
    protected IChatComponent mainButton;
    protected IChatComponent otherButton;
    protected IChatComponent cancelButton;
    protected List<String> output;
    protected final Consumer<Result> callback;

    public MultiChoiceScreen(Consumer<Result> callback, IChatComponent title, IChatComponent message, IChatComponent mainButton) {
        this(callback, title, message, mainButton, null, null);
    }

    public MultiChoiceScreen(Consumer<Result> callback, IChatComponent title, IChatComponent message, IChatComponent mainButton, IChatComponent otherButton, IChatComponent cancelButton) {
        this.title = title;
        this.callback = callback;
        this.message = message;
        this.mainButton = mainButton;
        this.otherButton = otherButton;
        this.cancelButton = cancelButton;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.output = this.field_146289_q.func_78271_c(this.message.func_150254_d(), this.field_146294_l - 50);
        this.addButtons(MathHelper.func_76125_a((int)(this.messageTop() + this.messageHeight() + 20), (int)(this.field_146295_m / 6 + 96), (int)(this.field_146295_m - 24)));
    }

    protected void addButtons(int y) {
        boolean singleOption = this.otherButton == null && this.cancelButton == null;
        this.addWidget(new CarbonButton(this.field_146294_l / 2 - 50 - (singleOption ? 50 : 105), y, singleOption ? 200 : 100, 20, this.mainButton.func_150254_d(), T -> this.callback.accept(Result.MAIN)));
        if (singleOption) {
            return;
        }
        this.addWidget(new CarbonButton(this.field_146294_l / 2 - 50, y, 100, 20, this.otherButton.func_150254_d(), T -> this.callback.accept(Result.OTHER)));
        this.addWidget(new CarbonButton(this.field_146294_l / 2 - 50 + 105, y, 100, 20, this.cancelButton.func_150254_d(), T -> this.callback.accept(Result.CANCEL)));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.title.func_150254_d(), this.field_146294_l / 2, this.titleTop(), 0xFFFFFF);
        int yOffset = this.messageTop();
        for (String s : this.output) {
            this.func_73732_a(this.field_146289_q, s, this.field_146294_l / 2, yOffset, 0xFFFFFF);
            yOffset += 9;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private int titleTop() {
        int i = (this.field_146295_m - this.messageHeight()) / 2;
        return MathHelper.func_76125_a((int)(i - 20 - 9), (int)10, (int)80);
    }

    private int messageTop() {
        return this.titleTop() + 20;
    }

    private int messageHeight() {
        return this.output.size() * 9;
    }

    @Override
    public boolean charTyped(char character, int keyCode) {
        if (keyCode == 1) {
            this.callback.accept(Result.CANCEL);
            return true;
        }
        return super.charTyped(character, keyCode);
    }

    public static enum Result {
        MAIN,
        OTHER,
        CANCEL;


        public boolean isCancel() {
            return this == CANCEL;
        }

        public boolean isMain() {
            return this == MAIN;
        }

        public boolean isOther() {
            return this == OTHER;
        }
    }
}

