/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.screen;

import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.config.ListScreen;
import carbonconfiglib.gui.screen.ConfigScreen;
import carbonconfiglib.gui.widgets.CarbonButton;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.screen.IInteractable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.storage.SaveFormatComparator;
import speiger.src.collections.objects.utils.ObjectLists;

public class SelectFileScreen
extends ListScreen {
    private static final IChatComponent TEXT = new ChatComponentTranslation("gui.carbonconfig.select_world", new Object[0]);
    IModConfig config;
    GuiScreen parent;

    public SelectFileScreen(IChatComponent name, BackgroundTexture.BackgroundHolder customTexture, GuiScreen parent, IModConfig config) {
        super(name, customTexture);
        this.config = config;
        this.parent = parent;
    }

    @Override
    protected void collectElements(Consumer<Element> elements) {
        for (IModConfig.IConfigTarget target : this.config.getPotentialFiles()) {
            if (Files.notExists(target.getConfigFile(), new LinkOption[0]) && !this.config.canCreateConfigs()) continue;
            elements.accept(new WorldElement(target, this.config, this.parent, this.title));
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m;
        this.addWidget(new CarbonButton(x - 80, y - 27, 160, 20, I18n.func_135052_a((String)"gui.carbonconfig.back", (Object[])new Object[0]), T -> this.onClose()));
    }

    @Override
    protected int getElementHeight() {
        return 28;
    }

    @Override
    public void onClose() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String text = TEXT.func_150254_d();
        this.field_146289_q.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, 8, -1);
    }

    private static class WorldElement
    extends Element {
        IModConfig config;
        IModConfig.IConfigTarget target;
        GuiScreen parent;
        CarbonButton button;
        IChatComponent title;
        IChatComponent path;
        ConfigScreen.Navigator nav;

        public WorldElement(IModConfig.IConfigTarget target, IModConfig config, GuiScreen parent, IChatComponent prevName) {
            super((IChatComponent)new ChatComponentText(target.getName()));
            this.nav = new ConfigScreen.Navigator(prevName);
            this.nav.setScreenForLayer(parent);
            this.target = target;
            this.config = config;
            this.parent = parent;
        }

        @Override
        public void init() {
            this.button = new CarbonButton(0, 0, 62, 20, I18n.func_135052_a((String)"gui.carbonconfig.pick", (Object[])new Object[0]), this::onPick);
            if (this.target instanceof IModConfig.WorldConfigTarget) {
                IModConfig.WorldConfigTarget world = (IModConfig.WorldConfigTarget)this.target;
                SaveFormatComparator sum = world.getSummary();
                this.title = new ChatComponentText(sum.func_75788_b());
                this.path = new ChatComponentText(sum.func_75786_a()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY));
            } else {
                this.title = new ChatComponentText(this.target.getName());
                Path folder = this.target.getFolder();
                int index = folder.getNameCount();
                this.path = new ChatComponentText(folder.subpath(index - 3, index).toString()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY));
            }
        }

        @Override
        public void render(int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.field_146128_h = left + width - 62;
            this.button.field_146129_i = top + 2;
            this.button.render(this.mc, mouseX, mouseY, partialTicks);
            GuiUtils.drawScrollingString(this.font, this.title.func_150254_d(), left + 5, top + 2, 150.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
            GuiUtils.drawScrollingString(this.font, this.path.func_150254_d(), left + 5, top + 12, 150.0f, 10.0f, ConfigElement.GuiAlign.LEFT, -1, 0);
        }

        @Override
        public List<? extends IInteractable> children() {
            return ObjectLists.singleton(this.button);
        }

        private void onPick(GuiButton button) {
            Path file = this.target.getConfigFile();
            if (Files.notExists(file, new LinkOption[0]) && !this.config.createConfig(file)) {
                return;
            }
            IModConfig config = this.config.loadFromFile(file);
            if (config == null) {
                this.mc.func_147108_a(this.parent);
                return;
            }
            this.mc.func_147108_a((GuiScreen)new ConfigScreen(this.nav.add(this.path.func_150259_f().func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.WHITE))), config, this.parent, this.owner.getCustomTexture()));
        }
    }
}

