/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.widgets;

import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.widgets.Icon;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    private static final float U_SCALE = 0.00390625f;
    private static final float V_SCALE = 0.00390625f;
    private static final ScissorsStack STACK = new ScissorsStack();

    public static float calculateScrollOffset(float width, FontRenderer font, ConfigElement.GuiAlign align, String text, int seed) {
        int textWidth = font.func_78256_a(text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(GuiUtils.milliTime() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            return (float)GuiUtils.lerp(offset, 0.0, diff);
        }
        return 0.0f;
    }

    public static void drawScrollingString(FontRenderer font, String text, float x, float y, float width, float height, ConfigElement.GuiAlign align, int color, int seed) {
        int textWidth = font.func_78256_a(text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(GuiUtils.milliTime() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            GuiUtils.pushScissors((int)x, (int)y, (int)width, (int)height);
            font.func_85187_a(text, (int)(x - align.align(width) + align.align(textWidth) + (float)GuiUtils.lerp(offset, 0.0, diff)), (int)(y + height / 2.0f - (float)(font.field_78288_b / 3)), color, false);
            GuiUtils.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        font.func_85187_a(text, (int)(x - align.align(width) + offset), (int)(y + height / 2.0f - (float)(font.field_78288_b / 3)), color, false);
    }

    public static void drawScrollingShadowString(FontRenderer font, String text, float x, float y, float width, float height, ConfigElement.GuiAlign align, int color, int seed) {
        int textWidth = font.func_78256_a(text);
        if ((float)textWidth > width) {
            float diff = (float)textWidth - width + 2.0f;
            double timer = (double)(GuiUtils.milliTime() + (long)seed) / 1000.0;
            double minDiff = Math.max((double)diff * 0.5, 3.0);
            double offset = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * timer / minDiff)) / 2.0 + (double)0.01f + (double)align.alignCenter();
            GuiUtils.pushScissors((int)x, (int)y, (int)width, (int)height);
            font.func_78261_a(text, (int)(x - align.align(width) + align.align(textWidth) + (float)GuiUtils.lerp(offset, 0.0, diff)), (int)(y + height / 2.0f - (float)(font.field_78288_b / 3)), color);
            GuiUtils.popScissors();
            return;
        }
        float offset = align.align(textWidth);
        font.func_78261_a(text, (int)(x - align.align(width) + offset), (int)(y + height / 2.0f - (float)(font.field_78288_b / 3)), color);
    }

    private static long milliTime() {
        return System.nanoTime() / 1000000L;
    }

    private static double lerp(double value, double min, double max) {
        return min + value * (max - min);
    }

    public static void pushScissors(int x, int y, int width, int height) {
        GuiUtils.pushScissors(new Rect(x, y, width, height));
    }

    public static void pushScissors(Rect rect) {
        STACK.push(rect);
        GuiUtils.applyScissors(rect);
    }

    public static void popScissors() {
        GuiUtils.applyScissors(STACK.pop());
    }

    private static void applyScissors(Rect rect) {
        if (rect == null) {
            GL11.glDisable((int)3089);
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int bottom = rect.maxY;
        double scaledHeight = (double)mc.field_71440_d / res.func_78324_d();
        double scaledWidth = (double)mc.field_71443_c / res.func_78327_c();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)rect.getX() * scaledWidth)), (int)((int)((double)mc.field_71440_d - (double)bottom * scaledHeight)), (int)((int)((double)rect.getWidth() * scaledWidth)), (int)((int)((double)rect.getHeigth() * scaledHeight)));
    }

    public static void drawTextureWithBorder(ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(res);
        GuiUtils.drawTexture(x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    private static void drawTexture(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)1);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTextured(x, y, u, v, leftBorder, topBorder, zLevel, tessellator);
        GuiUtils.drawTextured(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel, tessellator);
        GuiUtils.drawTextured(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel, tessellator);
        GuiUtils.drawTextured(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel, tessellator);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTextured(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel, tessellator);
            GuiUtils.drawTextured(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel, tessellator);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTextured(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel, tessellator);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTextured(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel, tessellator);
            GuiUtils.drawTextured(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel, tessellator);
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    private static void drawTextured(int x, int y, int u, int v, int width, int height, float zLevel, Tessellator builder) {
        builder.func_78374_a((double)x, (double)(y + height), (double)zLevel, (double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f));
        builder.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f));
        builder.func_78374_a((double)(x + width), (double)y, (double)zLevel, (double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f));
        builder.func_78374_a((double)x, (double)y, (double)zLevel, (double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f));
    }

    public static void drawTextureRegion(float x, float y, float width, float height, Icon icon, float texWidth, float texHeight) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon.getTexture());
        GuiUtils.drawTextureRegion(x, y, icon.getX(), icon.getY(), width, height, texWidth, texHeight, icon.getSheetWidth(), icon.getSheetHeight());
    }

    public static void drawTextureRegion(float x, float y, int xOff, int yOff, float width, float height, Icon icon, float texWidth, float texHeight) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon.getTexture());
        GuiUtils.drawTextureRegion(x, y, icon.getX() + (float)xOff, icon.getY() + (float)yOff, width, height, texWidth, texHeight, icon.getSheetWidth(), icon.getSheetHeight());
    }

    public static void drawTextureRegion(float x, float y, float texX, float texY, float width, float height, float texWidth, float texHeight, float textureWidth, float textureHeight) {
        float maxX = x + width;
        float maxY = y + height;
        float t_minX = texX / textureWidth;
        float t_minY = texY / textureHeight;
        float t_maxX = (texX + texWidth) / textureWidth;
        float t_maxY = (texY + texHeight) / textureHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)maxY, 0.0, (double)t_minX, (double)t_maxY);
        tessellator.func_78374_a((double)maxX, (double)maxY, 0.0, (double)t_maxX, (double)t_maxY);
        tessellator.func_78374_a((double)maxX, (double)y, 0.0, (double)t_maxX, (double)t_minY);
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)t_minX, (double)t_minY);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)1);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public static class ScissorsStack {
        Deque<Rect> stack = new ArrayDeque<Rect>();

        public void push(Rect owner) {
            if (this.stack.isEmpty()) {
                this.stack.push(owner);
                return;
            }
            owner.limit(this.stack.peek());
        }

        public Rect pop() {
            this.stack.pop();
            return this.stack.peek();
        }
    }

    public static class Rect {
        int minX;
        int minY;
        int maxX;
        int maxY;

        public Rect(int x, int y, int width, int heigth) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + width;
            this.maxY = y + heigth;
        }

        public void limit(Rect rect) {
            this.minX = Math.max(rect.minX, this.minX);
            this.minY = Math.max(rect.minY, this.minY);
            this.maxX = Math.min(rect.maxX, this.maxX);
            this.maxY = Math.min(rect.maxY, this.maxY);
        }

        public int getX() {
            return this.minX;
        }

        public int getY() {
            return this.minY;
        }

        public int getWidth() {
            return this.maxX - this.minX;
        }

        public int getHeigth() {
            return this.maxY - this.minY;
        }
    }
}

