/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.api.ConfigType;
import carbonconfiglib.api.IConfigProxy;
import carbonconfiglib.api.SimpleConfigProxy;
import carbonconfiglib.config.ConfigSettings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.SaveFormatComparator;
import net.minecraft.world.storage.SaveFormatOld;
import speiger.src.collections.objects.lists.ObjectArrayList;

public final class PerWorldProxy
implements IConfigProxy {
    public static final IConfigProxy INSTANCE = new PerWorldProxy(PerWorldProxy.getGameDirectory().resolve("multiplayerconfigs"), PerWorldProxy.getGameDirectory().resolve("defaultconfigs"), PerWorldProxy.getGameDirectory().resolve("saves"));
    Path baseClientPath;
    Path baseServerPath;
    Path saveFolders;

    private PerWorldProxy(Path baseClientPath, Path baseServerPath, Path saveFolders) {
        this.baseClientPath = baseClientPath;
        this.baseServerPath = baseServerPath;
        this.saveFolders = saveFolders;
    }

    private static Path getGameDirectory() {
        return Loader.instance().getConfigDir().toPath().getParent();
    }

    public static boolean isProxy(IConfigProxy proxy) {
        return proxy instanceof PerWorldProxy;
    }

    public static ConfigSettings perWorld() {
        return ConfigSettings.withFolderProxy(INSTANCE).withType(ConfigType.SERVER);
    }

    @Override
    public Path getBasePaths(Path relativeFile) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            Path path = ((SaveFormatOld)server.func_71254_M()).field_75808_a.toPath().resolve(server.func_71270_I()).resolve("serverconfig");
            if (Files.exists(path.resolve(relativeFile), new LinkOption[0])) {
                return path;
            }
        } else if (FMLCommonHandler.instance().getSide().isClient() && CarbonConfig.NETWORK.isInWorld()) {
            return this.baseClientPath;
        }
        return this.baseServerPath;
    }

    @Override
    public List<? extends IConfigProxy.IPotentialTarget> getPotentialConfigs() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            return this.getLevels();
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return Collections.singletonList(new SimpleConfigProxy.SimpleTarget(((SaveFormatOld)server.func_71254_M()).field_75808_a.toPath().resolve(server.func_71270_I()).resolve("serverconfig"), "server"));
    }

    @SideOnly(value=Side.CLIENT)
    private List<IConfigProxy.IPotentialTarget> getLevels() {
        ISaveFormat storage = Minecraft.func_71410_x().func_71359_d();
        ObjectArrayList<IConfigProxy.IPotentialTarget> folders = new ObjectArrayList<IConfigProxy.IPotentialTarget>();
        if (Files.exists(this.baseServerPath, new LinkOption[0])) {
            folders.add(new SimpleConfigProxy.SimpleTarget(this.baseServerPath, "Default Config"));
        }
        try {
            Path basePath = Minecraft.func_71410_x().field_71412_D.toPath().resolve("saves");
            for (SaveFormatComparator sum : storage.func_75799_b()) {
                try {
                    Path path = basePath.resolve(sum.func_75786_a()).resolve("level.dat");
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    folders.add(new WorldTarget(sum, path.getParent(), path));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folders;
    }

    @Override
    public boolean isDynamicProxy() {
        return true;
    }

    public static class WorldTarget
    implements IConfigProxy.IPotentialTarget {
        SaveFormatComparator summary;
        Path worldFile;
        Path folder;

        public WorldTarget(SaveFormatComparator summary, Path worldFile, Path folder) {
            this.summary = summary;
            this.worldFile = worldFile;
            this.folder = folder;
        }

        @Override
        public Path getFolder() {
            return this.folder;
        }

        @Override
        public String getName() {
            return this.summary.func_75788_b();
        }

        public Path getWorldFile() {
            return this.worldFile;
        }

        public SaveFormatComparator getSummary() {
            return this.summary;
        }
    }
}

