/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl.entries;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.api.buffer.IWriteBuffer;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.MultilinePolicy;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureList;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.sets.ObjectLinkedOpenHashSet;
import speiger.src.collections.objects.utils.ObjectSets;

public class RegistryKeyValue
extends ConfigEntry.CollectionConfigEntry<String, Set<String>> {
    FMLControlledNamespacedRegistry<?> registry;
    Class<?> clz;
    Predicate<String> filter;

    public RegistryKeyValue(String key, FMLControlledNamespacedRegistry<?> registry, Class<?> clz, Set<String> defaultValue, Predicate<String> filter, String ... comment) {
        super(key, defaultValue, comment);
        this.registry = registry;
        this.clz = clz;
        this.filter = filter;
        this.addSuggestionProvider(new RegistryKeySuggestions(this));
    }

    public static <E> Builder<E> builder(String key, Class<E> clz) {
        return new Builder(key, clz);
    }

    protected RegistryKeyValue copy() {
        return new RegistryKeyValue(this.getKey(), this.registry, this.clz, (Set)this.getDefault(), this.filter, this.getComment());
    }

    @Override
    protected String serializedValue(MultilinePolicy policy, Set<String> value) {
        String[] result = new String[value.size()];
        int i = 0;
        for (String entry : value) {
            result[i] = entry.toString();
        }
        return this.serializeArray(policy, result);
    }

    @Override
    public ParseResult<Set<String>> parseValue(String value) {
        String[] values = Helpers.splitArray(value, ",");
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet();
        int m = values.length;
        for (int i = 0; i < m; ++i) {
            String location = new String(values[i]);
            if (location == null || this.filter != null && !this.filter.test(location)) continue;
            result.add(location);
        }
        return ParseResult.success(result);
    }

    @Override
    public ParseResult<Boolean> canSet(Set<String> value) {
        ParseResult<Boolean> result = super.canSet(value);
        if (result.hasError()) {
            return result;
        }
        for (String entry : value) {
            if (!this.registry.func_148741_d(entry)) {
                return ParseResult.partial(false, NoSuchElementException::new, "Value [" + entry + "] doesn't exist in the registry");
            }
            if (this.filter == null || this.filter.test(entry)) continue;
            return ParseResult.partial(false, IllegalArgumentException::new, "Value [" + entry + "] isn't allowed");
        }
        return ParseResult.success(true);
    }

    private ParseResult<String> parseEntry(String value) {
        if (!this.registry.func_148741_d(value) || this.filter != null && !this.filter.test(value)) {
            return ParseResult.error(value, "Id [" + value + "] isn't valid");
        }
        return ParseResult.success(value);
    }

    @Override
    public IStructuredData getDataType() {
        return StructureList.ListBuilder.variants(IStructuredData.EntryDataType.STRING, String.class, this::parseEntry, Function.identity()).addSuggestions(ISuggestionProvider.wrapper(this::getSuggestions)).build(true);
    }

    @Override
    public char getPrefix() {
        return 'K';
    }

    @Override
    public String getLimitations() {
        return "";
    }

    @Override
    public void serialize(IWriteBuffer buffer) {
        Set value = (Set)this.getValue();
        buffer.writeVarInt(value.size());
        for (String entry : value) {
            buffer.writeString(entry.toString());
        }
    }

    @Override
    protected void deserializeValue(IReadBuffer buffer) {
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet();
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            String entry = new String(buffer.readString());
            if (entry == null) continue;
            result.add(entry);
        }
    }

    @Override
    protected Set<String> create(String value) {
        return ObjectSets.singleton(value);
    }

    public static class Builder<E> {
        Class<E> clz;
        String key;
        Set<E> unparsedValues = new ObjectLinkedOpenHashSet<E>();
        Set<String> values = new ObjectLinkedOpenHashSet<String>();
        Predicate<String> filter;
        String[] comments;

        private Builder(String key, Class<E> clz) {
            this.key = key;
            this.clz = clz;
        }

        public Builder<E> addDirectDefault(E ... elements) {
            this.unparsedValues.addAll(ObjectArrayList.wrap(elements));
            return this;
        }

        public Builder<E> addDirectDefaults(Collection<E> elements) {
            this.unparsedValues.addAll(elements);
            return this;
        }

        public Builder<E> addDefault(String ... elements) {
            this.values.addAll(ObjectArrayList.wrap(elements));
            return this;
        }

        public Builder<E> addDefaults(Collection<String> elements) {
            this.values.addAll(elements);
            return this;
        }

        public Builder<E> withFilter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<E> withComment(String ... comments) {
            this.comments = comments;
            return this;
        }

        private void parseValues(FMLControlledNamespacedRegistry<E> registry) {
            for (E entry : this.unparsedValues) {
                String location = registry.func_148750_c(entry);
                if (location == null) continue;
                this.values.add(location);
            }
            this.unparsedValues.clear();
        }

        public RegistryKeyValue build(FMLControlledNamespacedRegistry<E> registry) {
            this.parseValues(registry);
            return new RegistryKeyValue(this.key, registry, this.clz, this.values, this.filter, this.comments);
        }

        public RegistryKeyValue build(FMLControlledNamespacedRegistry<E> registry, ConfigSection section) {
            this.parseValues(registry);
            return section.add(new RegistryKeyValue(this.key, registry, this.clz, this.values, this.filter, this.comments));
        }
    }

    public static class RegistryKeySuggestions
    implements ISuggestionProvider {
        RegistryKeyValue value;

        public RegistryKeySuggestions(RegistryKeyValue value) {
            this.value = value;
        }

        @Override
        public void provideSuggestions(Consumer<ISuggestionProvider.Suggestion> output, Predicate<ISuggestionProvider.Suggestion> filter) {
            for (String entry : this.value.registry.func_148742_b()) {
                String key = entry.toString();
                ISuggestionProvider.Suggestion suggestion = ISuggestionProvider.Suggestion.namedTypeValue(key, key, this.value.clz);
                if (!filter.test(suggestion)) continue;
                output.accept(suggestion);
            }
        }
    }
}

