/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.impl.entries;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.api.buffer.IReadBuffer;
import carbonconfiglib.api.buffer.IWriteBuffer;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.MultilinePolicy;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import carbonconfiglib.utils.structure.StructureList;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.sets.ObjectLinkedOpenHashSet;
import speiger.src.collections.objects.utils.ObjectSets;

public class RegistryValue<T>
extends ConfigEntry.CollectionConfigEntry<T, Set<T>> {
    FMLControlledNamespacedRegistry<T> registry;
    Class<T> clz;
    Predicate<T> filter;

    protected RegistryValue(String key, FMLControlledNamespacedRegistry<T> registry, Class<T> clz, Set<T> defaultValue, Predicate<T> filter, String ... comment) {
        super(key, defaultValue, comment);
        this.registry = registry;
        this.clz = clz;
        this.filter = filter;
        this.addSuggestionProvider(new RegistrySuggestions(this));
    }

    public static <E> Builder<E> builder(String key, Class<E> clz) {
        return new Builder(key, clz);
    }

    @Override
    protected RegistryValue<T> copy() {
        return new RegistryValue<T>(this.getKey(), this.registry, this.clz, (Set)this.getDefault(), this.filter, this.getComment());
    }

    @Override
    protected String serializedValue(MultilinePolicy policy, Set<T> value) {
        String[] result = new String[value.size()];
        int i = 0;
        for (T entry : value) {
            result[i] = this.registry.func_148750_c(entry).toString();
        }
        return this.serializeArray(policy, result);
    }

    @Override
    public ParseResult<Set<T>> parseValue(String value) {
        String[] values = Helpers.splitArray(value, ",");
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet();
        int m = values.length;
        for (int i = 0; i < m; ++i) {
            Object entry = this.registry.func_82594_a(values[i]);
            if (entry == null || this.filter != null && !this.filter.test(entry)) continue;
            result.add(entry);
        }
        return ParseResult.success(result);
    }

    @Override
    public ParseResult<Boolean> canSet(Set<T> value) {
        ParseResult<Boolean> result = super.canSet(value);
        if (result.hasError()) {
            return result;
        }
        for (T entry : value) {
            if (this.registry.func_148750_c(entry) == null) {
                return ParseResult.partial(false, NoSuchElementException::new, "Value [" + entry + "] doesn't exist in the registry");
            }
            if (this.filter == null || this.filter.test(entry)) continue;
            return ParseResult.partial(false, IllegalArgumentException::new, "Value [" + this.registry.func_148750_c(entry) + "] isn't allowed");
        }
        return ParseResult.success(true);
    }

    private ParseResult<T> parseEntry(String value) {
        Object entry = this.registry.func_82594_a(value);
        if (entry == null || this.filter != null && !this.filter.test(entry)) {
            return ParseResult.error(value, "Id [" + value + "] isn't valid");
        }
        return ParseResult.success(entry);
    }

    @Override
    public IStructuredData getDataType() {
        return StructureList.ListBuilder.variants(IStructuredData.EntryDataType.STRING, this.clz, this::parseEntry, arg_0 -> this.registry.func_148750_c(arg_0)).addSuggestions(ISuggestionProvider.wrapper(this::getSuggestions)).build(true);
    }

    @Override
    public char getPrefix() {
        return 'R';
    }

    @Override
    public String getLimitations() {
        return "";
    }

    @Override
    public void serialize(IWriteBuffer buffer) {
        Set value = (Set)this.getValue();
        buffer.writeVarInt(value.size());
        for (Object entry : value) {
            buffer.writeVarInt(this.registry.getId(entry));
        }
    }

    @Override
    protected void deserializeValue(IReadBuffer buffer) {
        ObjectLinkedOpenHashSet result = new ObjectLinkedOpenHashSet();
        int size = buffer.readVarInt();
        for (int i = 0; i < size; ++i) {
            Object entry = this.registry.getRaw(buffer.readVarInt());
            if (entry == null) continue;
            result.add(entry);
        }
    }

    @Override
    protected Set<T> create(T value) {
        return ObjectSets.singleton(value);
    }

    public static class Builder<E> {
        Class<E> clz;
        String key;
        Set<E> values = new ObjectLinkedOpenHashSet<E>();
        Predicate<E> filter;
        String[] comments;

        private Builder(String key, Class<E> clz) {
            this.key = key;
            this.clz = clz;
        }

        public Builder<E> addDefault(E ... elements) {
            this.values.addAll(ObjectArrayList.wrap(elements));
            return this;
        }

        public Builder<E> addDefaults(Collection<E> elements) {
            this.values.addAll(elements);
            return this;
        }

        public Builder<E> withFilter(Predicate<E> filter) {
            this.filter = filter;
            return this;
        }

        public Builder<E> withComment(String ... comments) {
            this.comments = comments;
            return this;
        }

        public RegistryValue<E> build(FMLControlledNamespacedRegistry<E> registry) {
            return new RegistryValue<E>(this.key, registry, this.clz, this.values, this.filter, this.comments);
        }

        public RegistryValue<E> build(FMLControlledNamespacedRegistry<E> registry, ConfigSection section) {
            return section.add(new RegistryValue<E>(this.key, registry, this.clz, this.values, this.filter, this.comments));
        }
    }

    public static class RegistrySuggestions<T>
    implements ISuggestionProvider {
        RegistryValue<T> value;

        public RegistrySuggestions(RegistryValue<T> value) {
            this.value = value;
        }

        @Override
        public void provideSuggestions(Consumer<ISuggestionProvider.Suggestion> output, Predicate<ISuggestionProvider.Suggestion> filter) {
            for (Object entry : (Collection)this.value.registry) {
                String key = this.value.registry.func_148750_c(entry).toString();
                ISuggestionProvider.Suggestion suggestion = ISuggestionProvider.Suggestion.namedTypeValue(key, key, this.value.clz);
                if (!filter.test(suggestion)) continue;
                output.accept(suggestion);
            }
        }
    }
}

