/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking;

import carbonconfiglib.networking.CarbonChannel;
import carbonconfiglib.networking.ICarbonPacket;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.sets.ObjectOpenHashSet;

@ChannelHandler.Sharable
public class CarbonNetwork
extends SimpleChannelInboundHandler<ICarbonPacket> {
    public static final String VERSION = "1.0.0";
    private EnumMap<Side, FMLEmbeddedChannel> channel;
    Set<UUID> clientInstalledPlayers = new ObjectOpenHashSet<UUID>();
    boolean serverInstalled = false;
    boolean hasPermissions = false;

    public void init() {
        this.channel = NetworkRegistry.INSTANCE.newChannel("carbonconfig", new ChannelHandler[]{new CarbonChannel(), this});
    }

    protected void channelRead0(ChannelHandlerContext ctx, ICarbonPacket msg) throws Exception {
        try {
            this.handlePacket(msg, (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writePacket(ICarbonPacket packet, PacketBuffer buffer) {
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <T extends ICarbonPacket> T readPacket(PacketBuffer buffer, Supplier<T> values) {
        try {
            ICarbonPacket packet = (ICarbonPacket)values.get();
            packet.read(buffer);
            return (T)packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void handlePacket(ICarbonPacket packet, INetHandler provider) {
        try {
            EntityPlayer player = this.getPlayer(provider);
            packet.process(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isInWorld() {
        return this.getClientPlayer() != null;
    }

    public boolean hasPermissions() {
        return this.hasPermissions;
    }

    public void setPermissions(boolean value) {
        this.hasPermissions = value;
    }

    protected EntityPlayer getPlayer(INetHandler handler) {
        EntityPlayerMP entity = handler instanceof NetHandlerPlayServer ? ((NetHandlerPlayServer)handler).field_147369_b : null;
        return entity != null ? entity : this.getClientPlayer();
    }

    @SideOnly(value=Side.CLIENT)
    protected EntityPlayer getClientPlayer() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc == null ? null : mc.field_71439_g;
    }

    public void sendToServer(ICarbonPacket packet) {
        FMLEmbeddedChannel data = this.channel.get(Side.CLIENT);
        data.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        data.writeOutbound(new Object[]{packet});
    }

    public void sendToAllPlayers(ICarbonPacket packet) {
        for (EntityPlayer entityPlayer : this.getAllPlayers()) {
            FMLEmbeddedChannel data = this.channel.get(Side.SERVER);
            data.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            data.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayer);
            data.writeOutbound(new Object[]{packet});
        }
    }

    public void onPlayerJoined(EntityPlayer player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.add(player.func_110124_au());
        } else {
            this.serverInstalled = true;
        }
    }

    public void onPlayerLeft(EntityPlayer player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.remove(player.func_110124_au());
        } else {
            this.serverInstalled = false;
        }
    }

    private List<EntityPlayerMP> getAllPlayers() {
        ObjectArrayList<EntityPlayerMP> players = new ObjectArrayList<EntityPlayerMP>();
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
            if (!this.isInstalledOnClient(player)) continue;
            players.add(player);
        }
        return players;
    }

    public boolean isInstalled(EntityPlayer player) {
        return player instanceof EntityPlayerMP ? this.isInstalledOnClient((EntityPlayerMP)player) : this.isInstalledOnServer();
    }

    public boolean isInstalledOnClient(EntityPlayerMP player) {
        return this.clientInstalledPlayers.contains(player.func_110124_au());
    }

    public boolean isInstalledOnServer() {
        return this.serverInstalled;
    }

    public void sendToPlayer(ICarbonPacket packet, EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new RuntimeException("Sending a Packet to a PlayerEntity from client is not allowed");
        }
        FMLEmbeddedChannel data = this.channel.get(Side.SERVER);
        data.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        data.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        data.writeOutbound(new Object[]{packet});
    }
}

