/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import carbonconfiglib.utils.MultilinePolicy;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.UserListOpsEntry;

public class ConfigRequestPacket
implements ICarbonPacket {
    UUID id;
    String identifier;

    public ConfigRequestPacket() {
    }

    public ConfigRequestPacket(UUID id, String identifier) {
        this.id = id;
        this.identifier = identifier;
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        buffer.writeLong(this.id.getMostSignificantBits());
        buffer.writeLong(this.id.getLeastSignificantBits());
        buffer.func_150785_a(this.identifier);
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        this.id = new UUID(buffer.readLong(), buffer.readLong());
        this.identifier = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void process(EntityPlayer player) {
        if (!this.canIgnorePermissionCheck() && !this.hasPermissions(player, 4)) {
            return;
        }
        ConfigHandler handler = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        try {
            buf.func_150785_a(handler.getConfig().serialize(MultilinePolicy.DISABLED));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.id, data), player);
    }

    private boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        UserListOpsEntry entry = (UserListOpsEntry)server.func_71203_ab().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return entry != null && entry.func_152644_a() >= value;
    }

    private boolean canIgnorePermissionCheck() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return !server.func_71262_S() && server instanceof IntegratedServer && ((IntegratedServer)server).func_71344_c();
    }
}

