/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.minecraft;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.UserListOpsEntry;

public class RequestGameRulesPacket
implements ICarbonPacket {
    UUID requestId;

    public RequestGameRulesPacket() {
    }

    public RequestGameRulesPacket(UUID requestId) {
        this.requestId = requestId;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeLong(this.requestId.getMostSignificantBits());
        buffer.writeLong(this.requestId.getLeastSignificantBits());
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.requestId = new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    public void process(EntityPlayer player) {
        if (!this.canIgnorePermissionCheck() && !this.hasPermissions(player, 4)) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        try {
            buf.func_150786_a(server.field_71305_c[0].func_82736_K().func_82770_a());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.requestId, data), player);
    }

    private boolean hasPermissions(EntityPlayer player, int value) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        UserListOpsEntry entry = (UserListOpsEntry)server.func_71203_ab().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return entry != null && entry.func_152644_a() >= value;
    }

    private boolean canIgnorePermissionCheck() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        return !server.func_71262_S() && server instanceof IntegratedServer && ((IntegratedServer)server).func_71344_c();
    }
}

