/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.snyc;

import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.snyc.SyncPacket;
import carbonconfiglib.utils.SyncType;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import speiger.src.collections.objects.lists.ObjectArrayList;

public class BulkSyncPacket
implements ICarbonPacket {
    List<SyncPacket> packets = new ObjectArrayList<SyncPacket>();

    public BulkSyncPacket() {
    }

    public BulkSyncPacket(List<SyncPacket> packets) {
        this.packets = packets;
    }

    public static BulkSyncPacket create(Collection<ConfigHandler> toSync, SyncType type, boolean forceSync) {
        ObjectArrayList<SyncPacket> result = new ObjectArrayList<SyncPacket>();
        for (ConfigHandler handler : toSync) {
            SyncPacket packet = SyncPacket.create(handler, type, forceSync);
            if (packet == null) continue;
            result.add(packet);
        }
        return result.isEmpty() ? null : new BulkSyncPacket(result);
    }

    @Override
    public void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.packets.size());
        for (SyncPacket packet : this.packets) {
            packet.write(buffer);
        }
    }

    @Override
    public void read(PacketBuffer buffer) throws IOException {
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            SyncPacket packet = new SyncPacket();
            packet.read(buffer);
            this.packets.add(packet);
        }
    }

    @Override
    public void process(EntityPlayer player) {
        ReloadMode result = null;
        for (SyncPacket packet : this.packets) {
            result = ReloadMode.or(result, packet.processEntry(player));
        }
        if (result != null) {
            player.func_145747_a(result.getName());
        }
    }
}

