/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.bytes.functions;

import java.util.Comparator;
import java.util.Objects;

public interface ByteComparator
extends Comparator<Byte> {
    @Override
    public int compare(byte var1, byte var2);

    @Override
    @Deprecated
    default public int compare(Byte o1, Byte o2) {
        return this.compare((byte)o1, (byte)o2);
    }

    public static ByteComparator of(Comparator<Byte> c) {
        Objects.requireNonNull(c);
        return (K, V) -> c.compare(K, V);
    }

    default public ByteComparator reversed() {
        return new Reversed(this);
    }

    public static class Reversed
    implements ByteComparator {
        ByteComparator original;

        public Reversed(ByteComparator original) {
            this.original = original;
        }

        @Override
        public int compare(byte o1, byte o2) {
            return this.original.compare(o2, o1);
        }

        @Override
        public ByteComparator reversed() {
            return this.original;
        }
    }
}

