/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.collections;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Objects;
import speiger.src.collections.chars.collections.CharCollection;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.functions.CharConsumer;
import speiger.src.collections.chars.utils.CharArrays;
import speiger.src.collections.chars.utils.CharIterators;

public abstract class AbstractCharCollection
extends AbstractCollection<Character>
implements CharCollection {
    @Override
    public abstract CharIterator iterator();

    @Override
    @Deprecated
    public boolean add(Character e) {
        return CharCollection.super.add(e);
    }

    @Override
    public boolean addAll(CharCollection c) {
        boolean modified = false;
        CharIterator iter = c.iterator();
        while (iter.hasNext()) {
            modified |= ((AbstractCollection)this).add(iter.nextChar());
        }
        return modified;
    }

    @Override
    public CharCollection copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean contains(Object e) {
        return CharCollection.super.contains(e);
    }

    @Override
    public boolean contains(char e) {
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.nextChar() != e) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends Character> c) {
        return c instanceof CharCollection ? this.addAll((CharCollection)c) : super.addAll(c);
    }

    @Override
    public boolean containsAll(CharCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return true;
        }
        CharIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.nextChar())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return c instanceof CharCollection ? this.containsAll((CharCollection)c) : super.containsAll(c);
    }

    @Override
    @Deprecated
    public boolean containsAny(Collection<?> c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        for (Object e : c) {
            if (!this.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(CharCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        CharIterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.contains(iter.nextChar())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean remove(Object e) {
        return CharCollection.super.remove(e);
    }

    @Override
    public boolean remChar(char e) {
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.nextChar() != e) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(CharCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        boolean modified = false;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!c.contains(iter.nextChar())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(CharCollection c, CharConsumer r) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(r);
        boolean modified = false;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            char e = iter.nextChar();
            if (!c.contains(e)) continue;
            r.accept(e);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(CharCollection c) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            boolean modified = !this.isEmpty();
            this.clear();
            return modified;
        }
        boolean modified = false;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (c.contains(iter.nextChar())) continue;
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(CharCollection c, CharConsumer r) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(r);
        if (c.isEmpty()) {
            boolean modified = !this.isEmpty();
            this.forEach(r);
            this.clear();
            return modified;
        }
        boolean modified = false;
        CharIterator iter = this.iterator();
        while (iter.hasNext()) {
            char e = iter.nextChar();
            if (c.contains(e)) continue;
            r.accept(e);
            iter.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public char[] toCharArray() {
        if (this.isEmpty()) {
            return CharArrays.EMPTY_ARRAY;
        }
        return this.toCharArray(new char[this.size()]);
    }

    @Override
    public char[] toCharArray(char[] a) {
        if (a == null || a.length < this.size()) {
            a = new char[this.size()];
        }
        CharIterators.unwrap(a, this.iterator());
        if (a.length > this.size()) {
            a[this.size()] = '\u0000';
        }
        return a;
    }
}

