/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.maps.impl.hash;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.functions.CharConsumer;
import speiger.src.collections.chars.functions.consumer.CharObjectConsumer;
import speiger.src.collections.chars.functions.function.CharCharUnaryOperator;
import speiger.src.collections.chars.functions.function.CharFunction;
import speiger.src.collections.chars.functions.function.CharObjectUnaryOperator;
import speiger.src.collections.chars.functions.function.CharPredicate;
import speiger.src.collections.chars.maps.abstracts.AbstractChar2ObjectMap;
import speiger.src.collections.chars.maps.interfaces.Char2ObjectMap;
import speiger.src.collections.chars.sets.AbstractCharSet;
import speiger.src.collections.chars.sets.CharSet;
import speiger.src.collections.ints.functions.consumer.IntCharConsumer;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.consumer.ObjectCharConsumer;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.sets.AbstractObjectSet;
import speiger.src.collections.objects.sets.ObjectSet;
import speiger.src.collections.utils.HashUtil;
import speiger.src.collections.utils.ITrimmable;

public class Char2ObjectOpenHashMap<V>
extends AbstractChar2ObjectMap<V>
implements ITrimmable {
    protected transient char[] keys;
    protected transient V[] values;
    protected transient boolean containsNull;
    protected transient int minCapacity;
    protected transient int nullIndex;
    protected transient int maxFill;
    protected transient int mask;
    protected transient Char2ObjectMap.FastEntrySet<V> entrySet;
    protected transient CharSet keySet;
    protected transient ObjectCollection<V> valuesC;
    protected int size;
    protected final float loadFactor;

    public Char2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Char2ObjectOpenHashMap(int minCapacity) {
        this(minCapacity, 0.75f);
    }

    public Char2ObjectOpenHashMap(int minCapacity, float loadFactor) {
        if (minCapacity < 0) {
            throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new IllegalStateException("Load Factor is not between 0 and 1");
        }
        this.loadFactor = loadFactor;
        this.minCapacity = this.nullIndex = HashUtil.arraySize(minCapacity, loadFactor);
        this.mask = this.nullIndex - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * loadFactor), this.nullIndex - 1);
        this.keys = new char[this.nullIndex + 1];
        this.values = new Object[this.nullIndex + 1];
    }

    public Char2ObjectOpenHashMap(Character[] keys, V[] values) {
        this(keys, values, 0.75f);
    }

    public Char2ObjectOpenHashMap(Character[] keys, V[] values, float loadFactor) {
        this(keys.length, loadFactor);
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        int m = keys.length;
        for (int i = 0; i < m; ++i) {
            this.put(keys[i].charValue(), values[i]);
        }
    }

    public Char2ObjectOpenHashMap(char[] keys, V[] values) {
        this(keys, values, 0.75f);
    }

    public Char2ObjectOpenHashMap(char[] keys, V[] values, float loadFactor) {
        this(keys.length, loadFactor);
        if (keys.length != values.length) {
            throw new IllegalStateException("Input Arrays are not equal size");
        }
        int m = keys.length;
        for (int i = 0; i < m; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public Char2ObjectOpenHashMap(Map<? extends Character, ? extends V> map) {
        this(map, 0.75f);
    }

    public Char2ObjectOpenHashMap(Map<? extends Character, ? extends V> map, float loadFactor) {
        this(map.size(), loadFactor);
        this.putAll(map);
    }

    public Char2ObjectOpenHashMap(Char2ObjectMap<V> map) {
        this(map, 0.75f);
    }

    public Char2ObjectOpenHashMap(Char2ObjectMap<V> map, float loadFactor) {
        this(map.size(), loadFactor);
        this.putAll(map);
    }

    @Override
    public V put(char key, V value) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            this.insert(-slot - 1, key, value);
            return this.getDefaultReturnValue();
        }
        V oldValue = this.values[slot];
        this.values[slot] = value;
        return oldValue;
    }

    @Override
    public V putIfAbsent(char key, V value) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            this.insert(-slot - 1, key, value);
            return this.getDefaultReturnValue();
        }
        if (Objects.equals(this.values[slot], this.getDefaultReturnValue())) {
            V oldValue = this.values[slot];
            this.values[slot] = value;
            return oldValue;
        }
        return this.values[slot];
    }

    @Override
    public boolean containsKey(char key) {
        return this.findIndex(key) >= 0;
    }

    @Override
    @Deprecated
    public boolean containsKey(Object key) {
        return this.findIndex(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.containsNull && Objects.equals(this.values[this.nullIndex], value)) {
            return true;
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == '\u0000' || !Objects.equals(value, this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(char key) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            return this.getDefaultReturnValue();
        }
        return this.removeIndex(slot);
    }

    @Override
    public V removeOrDefault(char key, V defaultValue) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            return defaultValue;
        }
        return this.removeIndex(slot);
    }

    @Override
    public V remove(Object key) {
        int slot = this.findIndex(key);
        if (slot < 0) {
            return this.getDefaultReturnValue();
        }
        return this.removeIndex(slot);
    }

    @Override
    public boolean remove(char key, V value) {
        if (key == '\u0000') {
            if (this.containsNull && Objects.equals(value, this.values[this.nullIndex])) {
                this.removeNullIndex();
                return true;
            }
            return false;
        }
        int pos = HashUtil.mix(Character.hashCode(key)) & this.mask;
        char current = this.keys[pos];
        if (current == '\u0000') {
            return false;
        }
        if (current == key && Objects.equals(value, this.values[pos])) {
            this.removeIndex(pos);
            return true;
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != '\u0000') continue;
            return false;
        } while (current != key || !Objects.equals(value, this.values[pos]));
        this.removeIndex(pos);
        return true;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Objects.requireNonNull(value);
        if (key == null || key instanceof Character && ((Character)key).charValue() == '\u0000') {
            if (this.containsNull && Objects.equals(value, this.values[this.nullIndex])) {
                this.removeNullIndex();
                return true;
            }
            return false;
        }
        int pos = HashUtil.mix(key.hashCode()) & this.mask;
        char current = this.keys[pos];
        if (current == '\u0000') {
            return false;
        }
        if (Objects.equals(key, Character.valueOf(current)) && Objects.equals(value, this.values[pos])) {
            this.removeIndex(pos);
            return true;
        }
        do {
            ++pos;
            current = this.keys[pos &= this.mask];
            if (current != '\u0000') continue;
            return false;
        } while (!Objects.equals(key, Character.valueOf(current)) || !Objects.equals(value, this.values[pos]));
        this.removeIndex(pos);
        return true;
    }

    @Override
    public V get(char key) {
        int slot = this.findIndex(key);
        return slot < 0 ? this.getDefaultReturnValue() : this.values[slot];
    }

    @Override
    public V get(Object key) {
        int slot = this.findIndex(key);
        return slot < 0 ? this.getDefaultReturnValue() : this.values[slot];
    }

    @Override
    public V getOrDefault(char key, V defaultValue) {
        int slot = this.findIndex(key);
        return slot < 0 ? defaultValue : this.values[slot];
    }

    @Override
    public Char2ObjectOpenHashMap<V> copy() {
        Char2ObjectOpenHashMap<V> map = new Char2ObjectOpenHashMap<V>(0, this.loadFactor);
        map.minCapacity = this.minCapacity;
        map.mask = this.mask;
        map.maxFill = this.maxFill;
        map.nullIndex = this.nullIndex;
        map.containsNull = this.containsNull;
        map.size = this.size;
        map.keys = Arrays.copyOf(this.keys, this.keys.length);
        map.values = Arrays.copyOf(this.values, this.values.length);
        return map;
    }

    @Override
    public ObjectSet<Char2ObjectMap.Entry<V>> char2ObjectEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new MapEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public CharSet keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.valuesC == null) {
            this.valuesC = new Values();
        }
        return this.valuesC;
    }

    @Override
    public void forEach(CharObjectConsumer<V> action) {
        if (this.size() <= 0) {
            return;
        }
        if (this.containsNull) {
            action.accept(this.keys[this.nullIndex], this.values[this.nullIndex]);
        }
        for (int i = this.nullIndex - 1; i >= 0; --i) {
            if (this.keys[i] == '\u0000') continue;
            action.accept(this.keys[i], this.values[i]);
        }
    }

    @Override
    public boolean replace(char key, V oldValue, V newValue) {
        int index = this.findIndex(key);
        if (index < 0 || this.values[index] != oldValue) {
            return false;
        }
        this.values[index] = newValue;
        return true;
    }

    @Override
    public V replace(char key, V value) {
        int index = this.findIndex(key);
        if (index < 0) {
            return this.getDefaultReturnValue();
        }
        V oldValue = this.values[index];
        this.values[index] = value;
        return oldValue;
    }

    @Override
    public V compute(char key, CharObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index < 0) {
            V newValue = mappingFunction.apply(key, (V)this.getDefaultReturnValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.insert(-index - 1, key, newValue);
            return newValue;
        }
        V newValue = mappingFunction.apply(key, this.values[index]);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.removeIndex(index);
            return newValue;
        }
        this.values[index] = newValue;
        return newValue;
    }

    @Override
    public V computeIfAbsent(char key, CharFunction<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index < 0) {
            V newValue = mappingFunction.apply(key);
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.insert(-index - 1, key, newValue);
            return newValue;
        }
        V newValue = this.values[index];
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            newValue = mappingFunction.apply(key);
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public V supplyIfAbsent(char key, ObjectSupplier<V> valueProvider) {
        Objects.requireNonNull(valueProvider);
        int index = this.findIndex(key);
        if (index < 0) {
            V newValue = valueProvider.get();
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.insert(-index - 1, key, newValue);
            return newValue;
        }
        V newValue = this.values[index];
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            newValue = valueProvider.get();
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                return newValue;
            }
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public V computeIfPresent(char key, CharObjectUnaryOperator<V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int index = this.findIndex(key);
        if (index < 0 || Objects.equals(this.values[index], this.getDefaultReturnValue())) {
            return this.getDefaultReturnValue();
        }
        V newValue = mappingFunction.apply(key, this.values[index]);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            this.removeIndex(index);
            return newValue;
        }
        this.values[index] = newValue;
        return newValue;
    }

    @Override
    public V merge(char key, V value, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        V newValue;
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(value);
        int index = this.findIndex(key);
        Object object = newValue = index < 0 || Objects.equals(this.values[index], this.getDefaultReturnValue()) ? value : mappingFunction.apply(this.values[index], value);
        if (Objects.equals(newValue, this.getDefaultReturnValue())) {
            if (index >= 0) {
                this.removeIndex(index);
            }
        } else if (index < 0) {
            this.insert(-index - 1, key, newValue);
        } else {
            this.values[index] = newValue;
        }
        return newValue;
    }

    @Override
    public void mergeAll(Char2ObjectMap<V> m, ObjectObjectUnaryOperator<V, V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        for (Char2ObjectMap.Entry entry : this.getFastIterable(m)) {
            Object newValue;
            char key = entry.getCharKey();
            int index = this.findIndex(key);
            Object object = newValue = index < 0 || Objects.equals(this.values[index], this.getDefaultReturnValue()) ? entry.getValue() : mappingFunction.apply(this.values[index], entry.getValue());
            if (Objects.equals(newValue, this.getDefaultReturnValue())) {
                if (index < 0) continue;
                this.removeIndex(index);
                continue;
            }
            if (index < 0) {
                this.insert(-index - 1, key, newValue);
                continue;
            }
            this.values[index] = newValue;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, null);
    }

    @Override
    public boolean trim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex || this.size >= Math.min((int)Math.ceil((float)request * this.loadFactor), request - 1)) {
            return false;
        }
        try {
            this.rehash(request);
        }
        catch (OutOfMemoryError noMemory) {
            return false;
        }
        return true;
    }

    @Override
    public void clearAndTrim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex) {
            this.clear();
            return;
        }
        this.nullIndex = request;
        this.mask = request - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = new char[request + 1];
        this.values = new Object[request + 1];
        this.size = 0;
        this.containsNull = false;
    }

    protected int findIndex(char key) {
        int pos;
        block4: {
            if (key == '\u0000') {
                return this.containsNull ? this.nullIndex : -(this.nullIndex + 1);
            }
            pos = HashUtil.mix(Character.hashCode(key)) & this.mask;
            char current = this.keys[pos];
            if (current != '\u0000') {
                if (current == key) {
                    return pos;
                }
                do {
                    ++pos;
                    current = this.keys[pos &= this.mask];
                    if (current == '\u0000') break block4;
                } while (current != key);
                return pos;
            }
        }
        return -(pos + 1);
    }

    protected int findIndex(Object key) {
        int pos;
        block5: {
            if (key == null) {
                return this.containsNull ? this.nullIndex : -(this.nullIndex + 1);
            }
            if (key instanceof Character && ((Character)key).charValue() == '\u0000') {
                return this.containsNull ? this.nullIndex : -(this.nullIndex + 1);
            }
            pos = HashUtil.mix(key.hashCode()) & this.mask;
            char current = this.keys[pos];
            if (current != '\u0000') {
                if (Objects.equals(key, Character.valueOf(current))) {
                    return pos;
                }
                do {
                    ++pos;
                    current = this.keys[pos &= this.mask];
                    if (current == '\u0000') break block5;
                } while (!Objects.equals(key, Character.valueOf(current)));
                return pos;
            }
        }
        return -(pos + 1);
    }

    protected V removeIndex(int pos) {
        if (pos == this.nullIndex) {
            return this.containsNull ? this.removeNullIndex() : this.getDefaultReturnValue();
        }
        V value = this.values[pos];
        this.keys[pos] = '\u0000';
        this.values[pos] = null;
        --this.size;
        this.onNodeRemoved(pos);
        this.shiftKeys(pos);
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return value;
    }

    protected V removeNullIndex() {
        V value = this.values[this.nullIndex];
        this.containsNull = false;
        this.keys[this.nullIndex] = '\u0000';
        this.values[this.nullIndex] = null;
        --this.size;
        this.onNodeRemoved(this.nullIndex);
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return value;
    }

    protected void insert(int slot, char key, V value) {
        if (slot == this.nullIndex) {
            this.containsNull = true;
        }
        this.keys[slot] = key;
        this.values[slot] = value;
        this.onNodeAdded(slot);
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
    }

    protected void rehash(int newSize) {
        int newMask = newSize - 1;
        char[] newKeys = new char[newSize + 1];
        Object[] newValues = new Object[newSize + 1];
        int i = this.nullIndex;
        int pos = 0;
        int j = this.size - (this.containsNull ? 1 : 0);
        while (j-- != 0) {
            do {
                if (--i >= 0) continue;
                throw new ConcurrentModificationException("Map was modified during rehash");
            } while (this.keys[i] == '\u0000');
            pos = HashUtil.mix(Character.hashCode(this.keys[i])) & newMask;
            if (newKeys[pos] != '\u0000') {
                do {
                    ++pos;
                } while (newKeys[pos &= newMask] != '\u0000');
            }
            newKeys[pos] = this.keys[i];
            newValues[pos] = this.values[i];
        }
        newValues[newSize] = this.values[this.nullIndex];
        this.nullIndex = newSize;
        this.mask = newMask;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = newKeys;
        this.values = newValues;
    }

    protected void onNodeAdded(int pos) {
    }

    protected void onNodeRemoved(int pos) {
    }

    protected void onNodeMoved(int from, int to) {
    }

    protected void shiftKeys(int startPos) {
        while (true) {
            char current;
            int last = startPos;
            startPos = last + 1 & this.mask;
            while (true) {
                if ((current = this.keys[startPos]) == '\u0000') {
                    this.keys[last] = '\u0000';
                    this.values[last] = null;
                    return;
                }
                int slot = HashUtil.mix(Character.hashCode(current)) & this.mask;
                if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                ++startPos;
                startPos &= this.mask;
            }
            this.keys[last] = current;
            this.values[last] = this.values[startPos];
            this.onNodeMoved(startPos, last);
        }
    }

    private class MapIterator {
        int pos;
        int returnedPos;
        int lastReturned;
        int nextIndex;
        boolean returnNull;
        char[] wrapped;
        int wrappedIndex;

        private MapIterator() {
            this.pos = Char2ObjectOpenHashMap.this.nullIndex;
            this.returnedPos = -1;
            this.lastReturned = -1;
            this.nextIndex = Integer.MIN_VALUE;
            this.returnNull = Char2ObjectOpenHashMap.this.containsNull;
            this.wrapped = null;
            this.wrappedIndex = 0;
        }

        public boolean hasNext() {
            block5: {
                if (this.nextIndex == Integer.MIN_VALUE) {
                    if (this.returnNull) {
                        this.returnNull = false;
                        this.nextIndex = Char2ObjectOpenHashMap.this.nullIndex;
                    } else {
                        do {
                            if (--this.pos >= 0) continue;
                            if (this.wrapped != null && this.wrappedIndex > -this.pos - 1) {
                                this.nextIndex = -this.pos - 1;
                            }
                            break block5;
                        } while (Char2ObjectOpenHashMap.this.keys[this.pos] == '\u0000');
                        this.nextIndex = this.pos;
                    }
                }
            }
            return this.nextIndex != Integer.MIN_VALUE;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.returnedPos = this.pos;
            if (this.nextIndex < 0) {
                this.lastReturned = Integer.MAX_VALUE;
                int value = Char2ObjectOpenHashMap.this.findIndex(this.wrapped[this.nextIndex]);
                if (value < 0) {
                    throw new IllegalStateException("Entry [" + this.nextIndex + "] was removed during Iteration");
                }
                this.nextIndex = Integer.MIN_VALUE;
                return value;
            }
            int value = this.lastReturned = this.nextIndex;
            this.nextIndex = Integer.MIN_VALUE;
            return value;
        }

        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == Char2ObjectOpenHashMap.this.nullIndex) {
                Char2ObjectOpenHashMap.this.containsNull = false;
                Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex] = '\u0000';
                Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex] = null;
            } else if (this.returnedPos >= 0) {
                this.shiftKeys(this.returnedPos);
            } else {
                Char2ObjectOpenHashMap.this.remove(this.wrapped[-this.returnedPos - 1]);
                this.lastReturned = -1;
                return;
            }
            --Char2ObjectOpenHashMap.this.size;
            this.lastReturned = -1;
        }

        private void shiftKeys(int startPos) {
            while (true) {
                char current;
                int last = startPos;
                startPos = last + 1 & Char2ObjectOpenHashMap.this.mask;
                while (true) {
                    if ((current = Char2ObjectOpenHashMap.this.keys[startPos]) == '\u0000') {
                        Char2ObjectOpenHashMap.this.keys[last] = '\u0000';
                        Char2ObjectOpenHashMap.this.values[last] = null;
                        return;
                    }
                    int slot = HashUtil.mix(Character.hashCode(current)) & Char2ObjectOpenHashMap.this.mask;
                    if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                    ++startPos;
                    startPos &= Char2ObjectOpenHashMap.this.mask;
                }
                if (startPos < last) {
                    this.addWrapper(Char2ObjectOpenHashMap.this.keys[startPos]);
                }
                Char2ObjectOpenHashMap.this.keys[last] = current;
                Char2ObjectOpenHashMap.this.values[last] = Char2ObjectOpenHashMap.this.values[startPos];
            }
        }

        private void addWrapper(char value) {
            if (this.wrapped == null) {
                this.wrapped = new char[2];
            } else if (this.wrappedIndex >= this.wrapped.length) {
                char[] newArray = new char[this.wrapped.length * 2];
                System.arraycopy(this.wrapped, 0, newArray, 0, this.wrapped.length);
                this.wrapped = newArray;
            }
            this.wrapped[this.wrappedIndex++] = value;
        }
    }

    private class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return Char2ObjectOpenHashMap.this.values[this.nextEntry()];
        }
    }

    private class KeyIterator
    extends MapIterator
    implements CharIterator {
        private KeyIterator() {
        }

        @Override
        public char nextChar() {
            return Char2ObjectOpenHashMap.this.keys[this.nextEntry()];
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Char2ObjectMap.Entry<V>> {
        MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Char2ObjectMap.Entry<V> next() {
            this.entry = new ValueMapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Char2ObjectMap.Entry<V>> {
        MapEntry entry;

        private FastEntryIterator() {
            this.entry = new MapEntry();
        }

        @Override
        public Char2ObjectMap.Entry<V> next() {
            this.entry.index = this.nextEntry();
            return this.entry;
        }
    }

    private class Values
    extends AbstractObjectCollection<V> {
        private Values() {
        }

        @Override
        public boolean contains(Object e) {
            return Char2ObjectOpenHashMap.this.containsValue(e);
        }

        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectIterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return Char2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Char2ObjectOpenHashMap.this.clear();
        }

        @Override
        public void forEach(Consumer<? super V> action) {
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(Char2ObjectOpenHashMap.this.values[i]);
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<V> action) {
            int index;
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(0, Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex]);
            }
            int n = index = Char2ObjectOpenHashMap.this.containsNull ? 1 : 0;
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(index++, Char2ObjectOpenHashMap.this.values[i]);
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, V> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(input, Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(input, Char2ObjectOpenHashMap.this.values[i]);
            }
        }

        @Override
        public boolean matchesAny(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            if (Char2ObjectOpenHashMap.this.containsNull && filter.test(Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex])) {
                return true;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || !filter.test(Char2ObjectOpenHashMap.this.values[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            if (Char2ObjectOpenHashMap.this.containsNull && filter.test(Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex])) {
                return false;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || !filter.test(Char2ObjectOpenHashMap.this.values[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            if (Char2ObjectOpenHashMap.this.containsNull && !filter.test(Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex])) {
                return false;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || filter.test(Char2ObjectOpenHashMap.this.values[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, V, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            if (Char2ObjectOpenHashMap.this.containsNull) {
                state = operator.apply(state, Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                state = operator.apply(state, Char2ObjectOpenHashMap.this.values[i]);
            }
            return state;
        }

        @Override
        public V reduce(ObjectObjectUnaryOperator<V, V> operator) {
            Objects.requireNonNull(operator);
            Object state = null;
            boolean empty = true;
            if (Char2ObjectOpenHashMap.this.containsNull) {
                state = Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex];
                empty = false;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                if (empty) {
                    empty = false;
                    state = Char2ObjectOpenHashMap.this.values[i];
                    continue;
                }
                state = operator.apply(state, Char2ObjectOpenHashMap.this.values[i]);
            }
            return state;
        }

        @Override
        public V findFirst(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            if (Char2ObjectOpenHashMap.this.containsNull && filter.test(Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex])) {
                return Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex];
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || !filter.test(Char2ObjectOpenHashMap.this.values[i])) continue;
                return Char2ObjectOpenHashMap.this.values[i];
            }
            return null;
        }

        @Override
        public int count(Predicate<V> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            if (Char2ObjectOpenHashMap.this.containsNull && filter.test(Char2ObjectOpenHashMap.this.values[Char2ObjectOpenHashMap.this.nullIndex])) {
                ++result;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || !filter.test(Char2ObjectOpenHashMap.this.values[i])) continue;
                ++result;
            }
            return result;
        }
    }

    private final class KeySet
    extends AbstractCharSet {
        private KeySet() {
        }

        @Override
        public boolean contains(char e) {
            return Char2ObjectOpenHashMap.this.containsKey(e);
        }

        @Override
        public boolean remove(char o) {
            int oldSize = Char2ObjectOpenHashMap.this.size;
            Char2ObjectOpenHashMap.this.remove(o);
            return Char2ObjectOpenHashMap.this.size != oldSize;
        }

        @Override
        public boolean add(char o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Char2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Char2ObjectOpenHashMap.this.clear();
        }

        @Override
        public KeySet copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(CharConsumer action) {
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(Char2ObjectOpenHashMap.this.keys[i]);
            }
        }

        @Override
        public void forEachIndexed(IntCharConsumer action) {
            int index;
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(0, Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex]);
            }
            int n = index = Char2ObjectOpenHashMap.this.containsNull ? 1 : 0;
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(index++, Char2ObjectOpenHashMap.this.keys[i]);
            }
        }

        @Override
        public <E> void forEach(E input, ObjectCharConsumer<E> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(input, Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(input, Char2ObjectOpenHashMap.this.keys[i]);
            }
        }

        @Override
        public boolean matchesAny(CharPredicate filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            if (Char2ObjectOpenHashMap.this.containsNull && filter.test(Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex])) {
                return true;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || !filter.test(Char2ObjectOpenHashMap.this.keys[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(CharPredicate filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            if (Char2ObjectOpenHashMap.this.containsNull && filter.test(Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex])) {
                return false;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || !filter.test(Char2ObjectOpenHashMap.this.keys[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(CharPredicate filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            if (Char2ObjectOpenHashMap.this.containsNull && !filter.test(Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex])) {
                return false;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || filter.test(Char2ObjectOpenHashMap.this.keys[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public char reduce(char identity, CharCharUnaryOperator operator) {
            Objects.requireNonNull(operator);
            char state = identity;
            if (Char2ObjectOpenHashMap.this.containsNull) {
                state = operator.applyAsChar(state, Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex]);
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                state = operator.applyAsChar(state, Char2ObjectOpenHashMap.this.keys[i]);
            }
            return state;
        }

        @Override
        public char reduce(CharCharUnaryOperator operator) {
            Objects.requireNonNull(operator);
            char state = '\u0000';
            boolean empty = true;
            if (Char2ObjectOpenHashMap.this.containsNull) {
                state = Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex];
                empty = false;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                if (empty) {
                    empty = false;
                    state = Char2ObjectOpenHashMap.this.keys[i];
                    continue;
                }
                state = operator.applyAsChar(state, Char2ObjectOpenHashMap.this.keys[i]);
            }
            return state;
        }

        @Override
        public char findFirst(CharPredicate filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return '\u0000';
            }
            if (Char2ObjectOpenHashMap.this.containsNull && filter.test(Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex])) {
                return Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex];
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || !filter.test(Char2ObjectOpenHashMap.this.keys[i])) continue;
                return Char2ObjectOpenHashMap.this.keys[i];
            }
            return '\u0000';
        }

        @Override
        public int count(CharPredicate filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            int result = 0;
            if (Char2ObjectOpenHashMap.this.containsNull && filter.test(Char2ObjectOpenHashMap.this.keys[Char2ObjectOpenHashMap.this.nullIndex])) {
                ++result;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000' || !filter.test(Char2ObjectOpenHashMap.this.keys[i])) continue;
                ++result;
            }
            return result;
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Char2ObjectMap.Entry<V>>
    implements Char2ObjectMap.FastEntrySet<V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Char2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectIterator<Char2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public void forEach(Consumer<? super Char2ObjectMap.Entry<V>> action) {
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(new ValueMapEntry(Char2ObjectOpenHashMap.this.nullIndex));
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(new ValueMapEntry(i));
            }
        }

        @Override
        public void fastForEach(Consumer<? super Char2ObjectMap.Entry<V>> action) {
            MapEntry entry = new MapEntry();
            if (Char2ObjectOpenHashMap.this.containsNull) {
                entry.set(Char2ObjectOpenHashMap.this.nullIndex);
                action.accept(entry);
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                entry.set(i);
                action.accept(entry);
            }
        }

        @Override
        public void forEachIndexed(IntObjectConsumer<Char2ObjectMap.Entry<V>> action) {
            int index;
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(0, (Char2ObjectMap.Entry<ValueMapEntry>)new ValueMapEntry(Char2ObjectOpenHashMap.this.nullIndex));
            }
            int n = index = Char2ObjectOpenHashMap.this.containsNull ? 1 : 0;
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(index++, (Char2ObjectMap.Entry<ValueMapEntry>)new ValueMapEntry(i));
            }
        }

        @Override
        public <E> void forEach(E input, ObjectObjectConsumer<E, Char2ObjectMap.Entry<V>> action) {
            Objects.requireNonNull(action);
            if (this.size() <= 0) {
                return;
            }
            if (Char2ObjectOpenHashMap.this.containsNull) {
                action.accept(input, new ValueMapEntry(Char2ObjectOpenHashMap.this.nullIndex));
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                action.accept(input, new ValueMapEntry(i));
            }
        }

        @Override
        public boolean matchesAny(Predicate<Char2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return false;
            }
            MapEntry entry = new MapEntry();
            if (Char2ObjectOpenHashMap.this.containsNull) {
                entry.set(Char2ObjectOpenHashMap.this.nullIndex);
                if (filter.test(entry)) {
                    return true;
                }
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                entry.set(i);
                if (!filter.test(entry)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean matchesNone(Predicate<Char2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            MapEntry entry = new MapEntry();
            if (Char2ObjectOpenHashMap.this.containsNull) {
                entry.set(Char2ObjectOpenHashMap.this.nullIndex);
                if (filter.test(entry)) {
                    return false;
                }
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                entry.set(i);
                if (!filter.test(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean matchesAll(Predicate<Char2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return true;
            }
            MapEntry entry = new MapEntry();
            if (Char2ObjectOpenHashMap.this.containsNull) {
                entry.set(Char2ObjectOpenHashMap.this.nullIndex);
                if (!filter.test(entry)) {
                    return false;
                }
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                entry.set(i);
                if (filter.test(entry)) continue;
                return false;
            }
            return true;
        }

        @Override
        public <E> E reduce(E identity, BiFunction<E, Char2ObjectMap.Entry<V>, E> operator) {
            Objects.requireNonNull(operator);
            E state = identity;
            if (Char2ObjectOpenHashMap.this.containsNull) {
                state = operator.apply(state, new ValueMapEntry(Char2ObjectOpenHashMap.this.nullIndex));
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                state = operator.apply(state, new ValueMapEntry(i));
            }
            return state;
        }

        @Override
        public Char2ObjectMap.Entry<V> reduce(ObjectObjectUnaryOperator<Char2ObjectMap.Entry<V>, Char2ObjectMap.Entry<V>> operator) {
            Objects.requireNonNull(operator);
            Char2ObjectMap.Entry state = null;
            boolean empty = true;
            if (Char2ObjectOpenHashMap.this.containsNull) {
                state = new ValueMapEntry(Char2ObjectOpenHashMap.this.nullIndex);
                empty = false;
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                if (empty) {
                    empty = false;
                    state = new ValueMapEntry(i);
                    continue;
                }
                state = (Char2ObjectMap.Entry)operator.apply(state, new ValueMapEntry(i));
            }
            return state;
        }

        @Override
        public Char2ObjectMap.Entry<V> findFirst(Predicate<Char2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return null;
            }
            MapEntry entry = new MapEntry();
            if (Char2ObjectOpenHashMap.this.containsNull) {
                entry.set(Char2ObjectOpenHashMap.this.nullIndex);
                if (filter.test(entry)) {
                    return entry;
                }
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                entry.set(i);
                if (!filter.test(entry)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public int count(Predicate<Char2ObjectMap.Entry<V>> filter) {
            Objects.requireNonNull(filter);
            if (this.size() <= 0) {
                return 0;
            }
            MapEntry entry = new MapEntry();
            int result = 0;
            if (Char2ObjectOpenHashMap.this.containsNull) {
                entry.set(Char2ObjectOpenHashMap.this.nullIndex);
                if (filter.test(entry)) {
                    ++result;
                }
            }
            for (int i = Char2ObjectOpenHashMap.this.nullIndex - 1; i >= 0; --i) {
                if (Char2ObjectOpenHashMap.this.keys[i] == '\u0000') continue;
                entry.set(i);
                if (!filter.test(entry)) continue;
                ++result;
            }
            return result;
        }

        @Override
        public int size() {
            return Char2ObjectOpenHashMap.this.size();
        }

        @Override
        public void clear() {
            Char2ObjectOpenHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Char2ObjectMap.Entry) {
                    Char2ObjectMap.Entry entry = (Char2ObjectMap.Entry)o;
                    int index = Char2ObjectOpenHashMap.this.findIndex(entry.getCharKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), Char2ObjectOpenHashMap.this.values[index]);
                    }
                } else {
                    Map.Entry entry = (Map.Entry)o;
                    int index = Char2ObjectOpenHashMap.this.findIndex(entry.getKey());
                    if (index >= 0) {
                        return Objects.equals(entry.getValue(), Char2ObjectOpenHashMap.this.values[index]);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                if (o instanceof Char2ObjectMap.Entry) {
                    Char2ObjectMap.Entry entry = (Char2ObjectMap.Entry)o;
                    return Char2ObjectOpenHashMap.this.remove(entry.getCharKey(), entry.getValue());
                }
                Map.Entry entry = (Map.Entry)o;
                return Char2ObjectOpenHashMap.this.remove(entry.getKey(), entry.getValue());
            }
            return false;
        }
    }

    protected class MapEntry
    implements Char2ObjectMap.Entry<V>,
    Map.Entry<Character, V> {
        public int index = -1;

        public MapEntry() {
        }

        public MapEntry(int index) {
            this.index = index;
        }

        void set(int index) {
            this.index = index;
        }

        @Override
        public char getCharKey() {
            return Char2ObjectOpenHashMap.this.keys[this.index];
        }

        @Override
        public V getValue() {
            return Char2ObjectOpenHashMap.this.values[this.index];
        }

        @Override
        public V setValue(V value) {
            Object oldValue = Char2ObjectOpenHashMap.this.values[this.index];
            Char2ObjectOpenHashMap.this.values[this.index] = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                if (obj instanceof Char2ObjectMap.Entry) {
                    Char2ObjectMap.Entry entry = (Char2ObjectMap.Entry)obj;
                    return this.getCharKey() == entry.getCharKey() && Objects.equals(this.getValue(), entry.getValue());
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                return key instanceof Character && this.getCharKey() == ((Character)key).charValue() && Objects.equals(this.getValue(), value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Character.hashCode(this.getCharKey()) ^ Objects.hashCode(this.getValue());
        }

        public String toString() {
            return Character.toString(this.getCharKey()) + "=" + Objects.toString(this.getValue());
        }
    }

    protected class ValueMapEntry
    extends MapEntry {
        protected char key;
        protected V value;

        public ValueMapEntry(int index) {
            super(index);
            this.key = Char2ObjectOpenHashMap.this.keys[index];
            this.value = Char2ObjectOpenHashMap.this.values[index];
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return super.setValue(value);
        }
    }
}

