/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import speiger.src.collections.chars.collections.AbstractCharCollection;
import speiger.src.collections.chars.collections.CharCollection;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.functions.CharComparator;
import speiger.src.collections.chars.functions.CharConsumer;
import speiger.src.collections.chars.functions.function.CharCharUnaryOperator;
import speiger.src.collections.chars.functions.function.CharPredicate;
import speiger.src.collections.chars.utils.CharArrays;
import speiger.src.collections.chars.utils.CharIterators;
import speiger.src.collections.ints.functions.consumer.IntCharConsumer;
import speiger.src.collections.objects.functions.consumer.ObjectCharConsumer;
import speiger.src.collections.objects.utils.ObjectArrays;
import speiger.src.collections.utils.HashUtil;
import speiger.src.collections.utils.ITrimmable;

public class CharCollections {
    public static final CharCollection EMPTY = new EmptyCollection();

    public static CharCollection empty() {
        return EMPTY;
    }

    public static CharCollection unmodifiable(CharCollection c) {
        return c instanceof UnmodifiableCollection ? c : new UnmodifiableCollection(c);
    }

    public static CharCollection synchronize(CharCollection c) {
        return c instanceof SynchronizedCollection ? c : new SynchronizedCollection(c);
    }

    public static CharCollection synchronize(CharCollection c, Object mutex) {
        return c instanceof SynchronizedCollection ? c : new SynchronizedCollection(c, mutex);
    }

    public static CharCollection singleton(char element) {
        return new SingletonCollection(element);
    }

    protected static CollectionWrapper wrapper() {
        return new CollectionWrapper();
    }

    protected static CollectionWrapper wrapper(int size) {
        return new CollectionWrapper(size);
    }

    protected static DistinctCollectionWrapper distinctWrapper() {
        return new DistinctCollectionWrapper();
    }

    protected static DistinctCollectionWrapper distinctWrapper(int size) {
        return new DistinctCollectionWrapper(size);
    }

    public static class EmptyCollection
    extends AbstractCharCollection {
        @Override
        public boolean add(char o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(char[] e, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(char o) {
            return false;
        }

        @Override
        public boolean containsAll(CharCollection c) {
            return c.isEmpty();
        }

        @Override
        public boolean containsAny(CharCollection c) {
            return false;
        }

        @Override
        @Deprecated
        public boolean containsAny(Collection<?> c) {
            return false;
        }

        @Override
        @Deprecated
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            return ((Collection)o).isEmpty();
        }

        @Override
        @Deprecated
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remChar(char o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return ObjectArrays.EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a != null && a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public char[] toCharArray() {
            return CharArrays.EMPTY_ARRAY;
        }

        @Override
        public char[] toCharArray(char[] a) {
            if (a != null && a.length > 0) {
                a[0] = '\u0000';
            }
            return a;
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.empty();
        }

        @Override
        public void clear() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public EmptyCollection copy() {
            return this;
        }
    }

    public static class UnmodifiableCollection
    implements CharCollection {
        CharCollection c;

        UnmodifiableCollection(CharCollection c) {
            this.c = c;
        }

        @Override
        public boolean add(char o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Character> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(char[] e, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(char o) {
            return this.c.contains(o);
        }

        @Override
        public boolean containsAll(CharCollection c) {
            return this.c.containsAll(c);
        }

        @Override
        public boolean containsAny(CharCollection c) {
            return this.c.containsAny(c);
        }

        @Override
        @Deprecated
        public boolean containsAny(Collection<?> c) {
            return this.c.containsAny(c);
        }

        @Override
        @Deprecated
        public boolean containsAll(Collection<?> c) {
            return this.c.containsAll(c);
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.unmodifiable(this.c.iterator());
        }

        @Override
        public CharCollection copy() {
            return this.c.copy();
        }

        @Override
        @Deprecated
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean removeIf(Predicate<? super Character> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remChar(char o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(CharCollection c, CharConsumer r) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(CharCollection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(CharCollection c, CharConsumer r) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.c.toArray(a);
        }

        @Override
        public char[] toCharArray() {
            return this.c.toCharArray();
        }

        @Override
        public char[] toCharArray(char[] a) {
            return this.c.toCharArray(a);
        }

        @Override
        public void forEach(CharConsumer action) {
            this.c.forEach(action);
        }

        @Override
        @Deprecated
        public void forEach(Consumer<? super Character> action) {
            this.c.forEach(action);
        }

        @Override
        public void forEachIndexed(IntCharConsumer action) {
            this.c.forEachIndexed(action);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || this.c.equals(obj);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public <E> void forEach(E input, ObjectCharConsumer<E> action) {
            this.c.forEach(input, action);
        }

        @Override
        public boolean matchesAny(CharPredicate filter) {
            return this.c.matchesAny(filter);
        }

        @Override
        public boolean matchesNone(CharPredicate filter) {
            return this.c.matchesNone(filter);
        }

        @Override
        public boolean matchesAll(CharPredicate filter) {
            return this.c.matchesAll(filter);
        }

        @Override
        public char reduce(char identity, CharCharUnaryOperator operator) {
            return this.c.reduce(identity, operator);
        }

        @Override
        public char reduce(CharCharUnaryOperator operator) {
            return this.c.reduce(operator);
        }

        @Override
        public char findFirst(CharPredicate filter) {
            return this.c.findFirst(filter);
        }

        @Override
        public int count(CharPredicate filter) {
            return this.c.count(filter);
        }
    }

    public static class SynchronizedCollection
    implements CharCollection {
        CharCollection c;
        protected Object mutex;

        SynchronizedCollection(CharCollection c) {
            this.c = c;
            this.mutex = this;
        }

        SynchronizedCollection(CharCollection c, Object mutex) {
            this.c = c;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(char o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends Character> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(CharCollection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(char[] e, int offset, int length) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(e, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(char o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean containsAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean containsAny(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAny(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(CharCollection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAny(CharCollection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAny(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        @Override
        public CharIterator iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharCollection copy() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.copy();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean removeAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean retainAll(Collection<?> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remChar(char o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remChar(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(CharCollection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(CharCollection c, CharConsumer r) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(c, r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(CharCollection c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(CharCollection c, CharConsumer r) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(c, r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remIf(IntPredicate filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remIf(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char[] toCharArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toCharArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char[] toCharArray(char[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toCharArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(CharConsumer action) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void forEach(Consumer<? super Character> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachIndexed(IntCharConsumer action) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEachIndexed(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.c.equals(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E> void forEach(E input, ObjectCharConsumer<E> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEach(input, action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matchesAny(CharPredicate filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.matchesAny(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matchesNone(CharPredicate filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.matchesNone(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matchesAll(CharPredicate filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.matchesAll(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char reduce(char identity, CharCharUnaryOperator operator) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.reduce(identity, operator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char reduce(CharCharUnaryOperator operator) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.reduce(operator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char findFirst(CharPredicate filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.findFirst(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int count(CharPredicate filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.count(filter);
            }
        }
    }

    private static class SingletonCollection
    extends AbstractCharCollection {
        char element;

        SingletonCollection(char element) {
            this.element = element;
        }

        @Override
        public boolean remChar(char o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(char o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharIterator iterator() {
            return new CharIterator(){
                boolean next = true;

                @Override
                public boolean hasNext() {
                    return this.next;
                }

                @Override
                public char nextChar() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.next = false;
                    return element;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection l = (Collection)o;
            if (l.size() != this.size()) {
                return false;
            }
            Iterator iter = l.iterator();
            if (iter.hasNext() && !Objects.equals(Character.valueOf(this.element), iter.next())) {
                return false;
            }
            return !iter.hasNext();
        }

        @Override
        public int hashCode() {
            return Character.hashCode(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public SingletonCollection copy() {
            return new SingletonCollection(this.element);
        }
    }

    protected static class DistinctCollectionWrapper
    extends AbstractCharCollection {
        char[] keys;
        boolean containsNull;
        int minCapacity;
        int nullIndex;
        int maxFill;
        int mask;
        int size;

        public DistinctCollectionWrapper() {
            this(16);
        }

        public DistinctCollectionWrapper(int size) {
            if (this.minCapacity < 0) {
                throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
            }
            this.minCapacity = this.nullIndex = HashUtil.arraySize(this.minCapacity, 0.75f);
            this.mask = this.nullIndex - 1;
            this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * 0.75f), this.nullIndex - 1);
            this.keys = new char[this.nullIndex + 1];
        }

        @Override
        public boolean add(char o) {
            if (o == '\u0000') {
                if (this.containsNull) {
                    return false;
                }
                this.containsNull = true;
            } else {
                block7: {
                    int pos = HashUtil.mix(Character.hashCode(o)) & this.mask;
                    char current = this.keys[pos];
                    if (current != '\u0000') {
                        if (current == o) {
                            return false;
                        }
                        do {
                            ++pos;
                            current = this.keys[pos &= this.mask];
                            if (current == '\u0000') break block7;
                        } while (current != o);
                        return false;
                    }
                }
                this.keys[pos] = o;
            }
            if (this.size++ >= this.maxFill) {
                this.rehash(HashUtil.arraySize(this.size + 1, 0.75f));
            }
            return true;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Character && ((Character)o).charValue() == '\u0000') {
                return this.containsNull;
            }
            int pos = HashUtil.mix(o.hashCode()) & this.mask;
            char current = this.keys[pos];
            if (current == '\u0000') {
                return false;
            }
            if (Objects.equals(o, Character.valueOf(current))) {
                return true;
            }
            do {
                ++pos;
                current = this.keys[pos &= this.mask];
                if (current != '\u0000') continue;
                return false;
            } while (!Objects.equals(o, Character.valueOf(current)));
            return true;
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Character && ((Character)o).charValue() == '\u0000') {
                return this.containsNull ? this.removeNullIndex() : false;
            }
            int pos = HashUtil.mix(o.hashCode()) & this.mask;
            char current = this.keys[pos];
            if (current == '\u0000') {
                return false;
            }
            if (Objects.equals(o, Character.valueOf(current))) {
                return this.removeIndex(pos);
            }
            do {
                ++pos;
                current = this.keys[pos &= this.mask];
                if (current != '\u0000') continue;
                return false;
            } while (!Objects.equals(o, Character.valueOf(current)));
            return this.removeIndex(pos);
        }

        @Override
        public boolean contains(char o) {
            if (o == '\u0000') {
                return this.containsNull;
            }
            int pos = HashUtil.mix(Character.hashCode(o)) & this.mask;
            char current = this.keys[pos];
            if (current == '\u0000') {
                return false;
            }
            if (current == o) {
                return true;
            }
            do {
                ++pos;
                current = this.keys[pos &= this.mask];
                if (current != '\u0000') continue;
                return false;
            } while (current != o);
            return true;
        }

        @Override
        public boolean remChar(char o) {
            if (o == '\u0000') {
                return this.containsNull ? this.removeNullIndex() : false;
            }
            int pos = HashUtil.mix(Character.hashCode(o)) & this.mask;
            char current = this.keys[pos];
            if (current == '\u0000') {
                return false;
            }
            if (current == o) {
                return this.removeIndex(pos);
            }
            do {
                ++pos;
                current = this.keys[pos &= this.mask];
                if (current != '\u0000') continue;
                return false;
            } while (current != o);
            return this.removeIndex(pos);
        }

        protected boolean removeIndex(int pos) {
            if (pos == this.nullIndex) {
                return this.containsNull ? this.removeNullIndex() : false;
            }
            this.keys[pos] = '\u0000';
            --this.size;
            this.shiftKeys(pos);
            if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
                this.rehash(this.nullIndex / 2);
            }
            return true;
        }

        protected boolean removeNullIndex() {
            this.containsNull = false;
            this.keys[this.nullIndex] = '\u0000';
            --this.size;
            if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
                this.rehash(this.nullIndex / 2);
            }
            return true;
        }

        @Override
        public CharIterator iterator() {
            return new SetIterator();
        }

        @Override
        public void forEach(CharConsumer action) {
            if (this.size() <= 0) {
                return;
            }
            if (this.containsNull) {
                action.accept(this.keys[this.nullIndex]);
            }
            for (int i = this.nullIndex - 1; i >= 0; --i) {
                if (this.keys[i] == '\u0000') continue;
                action.accept(this.keys[i]);
            }
        }

        @Override
        public DistinctCollectionWrapper copy() {
            DistinctCollectionWrapper set = new DistinctCollectionWrapper(0);
            set.minCapacity = this.minCapacity;
            set.mask = this.mask;
            set.maxFill = this.maxFill;
            set.nullIndex = this.nullIndex;
            set.containsNull = this.containsNull;
            set.size = this.size;
            set.keys = Arrays.copyOf(this.keys, this.keys.length);
            return set;
        }

        protected void shiftKeys(int startPos) {
            while (true) {
                char current;
                int last = startPos;
                startPos = last + 1 & this.mask;
                while (true) {
                    if ((current = this.keys[startPos]) == '\u0000') {
                        this.keys[last] = '\u0000';
                        return;
                    }
                    int slot = HashUtil.mix(Character.hashCode(current)) & this.mask;
                    if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                    ++startPos;
                    startPos &= this.mask;
                }
                this.keys[last] = current;
            }
        }

        protected void rehash(int newSize) {
            int newMask = newSize - 1;
            char[] newKeys = new char[newSize + 1];
            int i = this.nullIndex;
            int pos = 0;
            int j = this.size - (this.containsNull ? 1 : 0);
            while (j-- != 0) {
                do {
                    if (--i >= 0) continue;
                    throw new ConcurrentModificationException("Set was modified during rehash");
                } while (this.keys[i] == '\u0000');
                pos = HashUtil.mix(Character.hashCode(this.keys[i])) & newMask;
                if (newKeys[pos] != '\u0000') {
                    do {
                        ++pos;
                    } while (newKeys[pos &= newMask] != '\u0000');
                }
                newKeys[pos] = this.keys[i];
            }
            this.nullIndex = newSize;
            this.mask = newMask;
            this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * 0.75f), this.nullIndex - 1);
            this.keys = newKeys;
        }

        @Override
        public void clear() {
            if (this.size == 0) {
                return;
            }
            this.size = 0;
            this.containsNull = false;
            Arrays.fill(this.keys, '\u0000');
        }

        @Override
        public int size() {
            return this.size;
        }

        private class SetIterator
        implements CharIterator {
            int pos;
            int returnedPos;
            int lastReturned;
            int nextIndex;
            boolean returnNull;
            char[] wrapped;
            int wrappedIndex;

            private SetIterator() {
                this.pos = DistinctCollectionWrapper.this.nullIndex;
                this.returnedPos = -1;
                this.lastReturned = -1;
                this.nextIndex = Integer.MIN_VALUE;
                this.returnNull = DistinctCollectionWrapper.this.containsNull;
                this.wrapped = null;
                this.wrappedIndex = 0;
            }

            @Override
            public boolean hasNext() {
                block5: {
                    if (this.nextIndex == Integer.MIN_VALUE) {
                        if (this.returnNull) {
                            this.returnNull = false;
                            this.nextIndex = DistinctCollectionWrapper.this.nullIndex;
                        } else {
                            do {
                                if (--this.pos >= 0) continue;
                                if (this.wrapped != null && this.wrappedIndex > -this.pos - 1) {
                                    this.nextIndex = -this.pos - 1;
                                }
                                break block5;
                            } while (DistinctCollectionWrapper.this.keys[this.pos] == '\u0000');
                            this.nextIndex = this.pos;
                        }
                    }
                }
                return this.nextIndex != Integer.MIN_VALUE;
            }

            @Override
            public char nextChar() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.returnedPos = this.pos;
                if (this.nextIndex < 0) {
                    this.lastReturned = Integer.MAX_VALUE;
                    char value = this.wrapped[this.nextIndex];
                    this.nextIndex = Integer.MIN_VALUE;
                    return value;
                }
                this.lastReturned = this.nextIndex;
                char value = DistinctCollectionWrapper.this.keys[this.lastReturned];
                this.nextIndex = Integer.MIN_VALUE;
                return value;
            }

            @Override
            public void remove() {
                if (this.lastReturned == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturned == DistinctCollectionWrapper.this.nullIndex) {
                    DistinctCollectionWrapper.this.containsNull = false;
                    DistinctCollectionWrapper.this.keys[DistinctCollectionWrapper.this.nullIndex] = '\u0000';
                } else if (this.returnedPos >= 0) {
                    this.shiftKeys(this.returnedPos);
                } else {
                    DistinctCollectionWrapper.this.remChar(this.wrapped[-this.returnedPos - 1]);
                    this.lastReturned = -1;
                    return;
                }
                --DistinctCollectionWrapper.this.size;
                this.lastReturned = -1;
            }

            private void shiftKeys(int startPos) {
                while (true) {
                    char current;
                    int last = startPos;
                    startPos = last + 1 & DistinctCollectionWrapper.this.mask;
                    while (true) {
                        if ((current = DistinctCollectionWrapper.this.keys[startPos]) == '\u0000') {
                            DistinctCollectionWrapper.this.keys[last] = '\u0000';
                            return;
                        }
                        int slot = HashUtil.mix(Character.hashCode(current)) & DistinctCollectionWrapper.this.mask;
                        if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                        ++startPos;
                        startPos &= DistinctCollectionWrapper.this.mask;
                    }
                    if (startPos < last) {
                        this.addWrapper(DistinctCollectionWrapper.this.keys[startPos]);
                    }
                    DistinctCollectionWrapper.this.keys[last] = current;
                }
            }

            private void addWrapper(char value) {
                if (this.wrapped == null) {
                    this.wrapped = new char[2];
                } else if (this.wrappedIndex >= this.wrapped.length) {
                    char[] newArray = new char[this.wrapped.length * 2];
                    System.arraycopy(this.wrapped, 0, newArray, 0, this.wrapped.length);
                    this.wrapped = newArray;
                }
                this.wrapped[this.wrappedIndex++] = value;
            }
        }
    }

    protected static class CollectionWrapper
    extends AbstractCharCollection
    implements ITrimmable {
        char[] elements;
        int size = 0;

        public CollectionWrapper() {
            this(10);
        }

        public CollectionWrapper(int size) {
            if (size < 0) {
                throw new IllegalStateException("Size has to be 0 or greater");
            }
            this.elements = new char[size];
        }

        @Override
        public boolean add(char o) {
            if (this.size >= this.elements.length) {
                this.elements = Arrays.copyOf(this.elements, (int)Math.min((long)this.elements.length + (long)(this.elements.length >> 1), 0x7FFFFFF7L));
            }
            this.elements[this.size++] = o;
            return true;
        }

        public char getChar(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return this.elements[index];
        }

        @Override
        public boolean remChar(char e) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[i] != e) continue;
                this.removeIndex(i);
                return true;
            }
            return false;
        }

        private void removeIndex(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            --this.size;
            if (index != this.size) {
                System.arraycopy(this.elements, index + 1, this.elements, index, this.size - index);
            }
        }

        @Override
        public CharIterator iterator() {
            return new CharIterator(){
                int index = 0;
                int lastReturned = -1;

                @Override
                public boolean hasNext() {
                    return this.index < size;
                }

                @Override
                public char nextChar() {
                    int i;
                    this.lastReturned = i = this.index++;
                    return elements[this.lastReturned];
                }

                @Override
                public void remove() {
                    if (this.lastReturned == -1) {
                        throw new IllegalStateException();
                    }
                    this.removeIndex(this.lastReturned);
                    this.index = this.lastReturned;
                    this.lastReturned = -1;
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        public void sort(CharComparator c) {
            if (c != null) {
                CharArrays.stableSort(this.elements, this.size, c);
            } else {
                CharArrays.stableSort(this.elements, this.size);
            }
        }

        public void unstableSort(CharComparator c) {
            if (c != null) {
                CharArrays.unstableSort(this.elements, this.size, c);
            } else {
                CharArrays.unstableSort(this.elements, this.size);
            }
        }

        @Override
        public void forEach(CharConsumer action) {
            Objects.requireNonNull(action);
            for (int i = 0; i < this.size; ++i) {
                action.accept(this.elements[i]);
            }
        }

        @Override
        public <E> void forEach(E input, ObjectCharConsumer<E> action) {
            Objects.requireNonNull(action);
            for (int i = 0; i < this.size; ++i) {
                action.accept(input, this.elements[i]);
            }
        }

        @Override
        public boolean trim(int size) {
            if (size > this.size() || this.size() == this.elements.length) {
                return false;
            }
            int value = Math.max(size, this.size());
            this.elements = value == 0 ? CharArrays.EMPTY_ARRAY : Arrays.copyOf(this.elements, value);
            return true;
        }

        @Override
        public void clearAndTrim(int size) {
            if (this.elements.length <= size) {
                this.clear();
                return;
            }
            this.elements = size == 0 ? CharArrays.EMPTY_ARRAY : new char[size];
            this.size = size;
        }

        @Override
        @Deprecated
        public Object[] toArray() {
            Object[] obj = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                obj[i] = Character.valueOf(this.elements[i]);
            }
            return obj;
        }

        @Override
        @Deprecated
        public <E> E[] toArray(E[] a) {
            if (a == null) {
                a = new Object[this.size];
            } else if (a.length < this.size) {
                a = ObjectArrays.newArray(a.getClass().getComponentType(), this.size);
            }
            for (int i = 0; i < this.size; ++i) {
                a[i] = Character.valueOf(this.elements[i]);
            }
            if (a.length > this.size) {
                a[this.size] = null;
            }
            return a;
        }

        @Override
        public char[] toCharArray(char[] a) {
            if (a.length < this.size) {
                a = new char[this.size];
            }
            System.arraycopy(this.elements, 0, a, 0, this.size);
            if (a.length > this.size) {
                a[this.size] = '\u0000';
            }
            return a;
        }
    }
}

