/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.utils;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import speiger.src.collections.chars.collections.CharIterable;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.functions.CharComparator;
import speiger.src.collections.chars.functions.CharConsumer;
import speiger.src.collections.chars.functions.function.CharFunction;
import speiger.src.collections.chars.functions.function.CharPredicate;
import speiger.src.collections.chars.utils.CharCollections;
import speiger.src.collections.chars.utils.CharIterators;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.utils.ISizeProvider;

public class CharIterables {
    public static <E> ObjectIterable<E> map(Iterable<? extends Character> iterable, CharFunction<E> mapper) {
        return new MappedIterable<E>(CharIterables.wrap(iterable), mapper);
    }

    public static <E> ObjectIterable<E> map(CharIterable iterable, CharFunction<E> mapper) {
        return new MappedIterable<E>(iterable, mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterable<E> flatMap(Iterable<? extends Character> iterable, CharFunction<V> mapper) {
        return new FlatMappedIterable(CharIterables.wrap(iterable), mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterable<E> flatMap(CharIterable iterable, CharFunction<V> mapper) {
        return new FlatMappedIterable(iterable, mapper);
    }

    public static <E> ObjectIterable<E> arrayFlatMap(Iterable<? extends Character> iterable, CharFunction<E[]> mapper) {
        return new FlatMappedArrayIterable(CharIterables.wrap(iterable), mapper);
    }

    public static <E> ObjectIterable<E> arrayFlatMap(CharIterable iterable, CharFunction<E[]> mapper) {
        return new FlatMappedArrayIterable(iterable, mapper);
    }

    public static CharIterable filter(Iterable<? extends Character> iterable, CharPredicate filter) {
        return new FilteredIterable(CharIterables.wrap(iterable), filter);
    }

    public static CharIterable filter(CharIterable iterable, CharPredicate filter) {
        return new FilteredIterable(iterable, filter);
    }

    public static CharIterable distinct(CharIterable iterable) {
        return new DistinctIterable(iterable);
    }

    public static CharIterable distinct(Iterable<? extends Character> iterable) {
        return new DistinctIterable(CharIterables.wrap(iterable));
    }

    public static CharIterable repeat(CharIterable iterable, int repeats) {
        return new RepeatingIterable(iterable, repeats);
    }

    public static CharIterable repeat(Iterable<? extends Character> iterable, int repeats) {
        return new RepeatingIterable(CharIterables.wrap(iterable), repeats);
    }

    public static CharIterable limit(CharIterable iterable, long limit) {
        return new LimitedIterable(iterable, limit);
    }

    public static CharIterable limit(Iterable<? extends Character> iterable, long limit) {
        return new LimitedIterable(CharIterables.wrap(iterable), limit);
    }

    public static CharIterable sorted(CharIterable iterable, CharComparator sorter) {
        return new SortedIterable(iterable, sorter);
    }

    public static CharIterable sorted(Iterable<? extends Character> iterable, CharComparator sorter) {
        return new SortedIterable(CharIterables.wrap(iterable), sorter);
    }

    public static CharIterable peek(CharIterable iterable, CharConsumer action) {
        return new PeekIterable(iterable, action);
    }

    public static CharIterable peek(Iterable<? extends Character> iterable, CharConsumer action) {
        return new PeekIterable(CharIterables.wrap(iterable), action);
    }

    public static CharIterable wrap(Iterable<? extends Character> iterable) {
        return new WrappedIterable(iterable);
    }

    private static class PeekIterable
    implements CharIterable,
    ISizeProvider {
        CharIterable iterable;
        CharConsumer action;

        public PeekIterable(CharIterable iterable, CharConsumer action) {
            this.iterable = iterable;
            this.action = action;
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.peek(this.iterable.iterator(), this.action);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(CharConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(this.action.andThen(action));
        }
    }

    private static class DistinctIterable
    implements CharIterable {
        CharIterable iterable;

        public DistinctIterable(CharIterable iterable) {
            this.iterable = iterable;
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.distinct(this.iterable.iterator());
        }

        @Override
        public void forEach(CharConsumer action) {
            Objects.requireNonNull(action);
            CharCollections.DistinctCollectionWrapper filtered = CharCollections.distinctWrapper();
            this.iterable.forEach((char T) -> {
                if (filtered.add(T)) {
                    action.accept(T);
                }
            });
        }
    }

    private static class SortedIterable
    implements CharIterable,
    ISizeProvider {
        CharIterable iterable;
        CharComparator sorter;

        public SortedIterable(CharIterable iterable, CharComparator sorter) {
            this.iterable = iterable;
            this.sorter = sorter;
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.sorted(this.iterable.iterator(), this.sorter);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(CharConsumer action) {
            Objects.requireNonNull(action);
            CharCollections.CollectionWrapper wrapper = CharCollections.wrapper();
            this.iterable.forEach(wrapper::add);
            wrapper.unstableSort(this.sorter);
            wrapper.forEach(action);
        }
    }

    private static class LimitedIterable
    implements CharIterable,
    ISizeProvider {
        CharIterable iterable;
        long limit;

        public LimitedIterable(CharIterable iterable, long limit) {
            this.iterable = iterable;
            this.limit = limit;
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.limit(this.iterable.iterator(), this.limit);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : (int)Math.min((long)prov.size(), this.limit);
        }

        @Override
        public void forEach(CharConsumer action) {
            Objects.requireNonNull(action);
            AtomicLong counter = new AtomicLong();
            this.iterable.forEach((char T) -> {
                if (counter.get() >= this.limit) {
                    return;
                }
                counter.incrementAndGet();
                action.accept(T);
            });
        }
    }

    private static class FilteredIterable
    implements CharIterable {
        CharIterable iterable;
        CharPredicate filter;

        public FilteredIterable(CharIterable iterable, CharPredicate filter) {
            this.iterable = iterable;
            this.filter = filter;
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.filter(this.iterable.iterator(), this.filter);
        }

        @Override
        public void forEach(CharConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((char T) -> {
                if (!this.filter.test(T)) {
                    action.accept(T);
                }
            });
        }
    }

    private static class RepeatingIterable
    implements CharIterable,
    ISizeProvider {
        CharIterable iterable;
        int repeats;

        public RepeatingIterable(CharIterable iterable, int repeats) {
            this.iterable = iterable;
            this.repeats = repeats;
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.repeat(this.iterable.iterator(), this.repeats);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size() * (this.repeats + 1);
        }

        @Override
        public void forEach(CharConsumer action) {
            Objects.requireNonNull(action);
            CharCollections.CollectionWrapper repeater = CharCollections.wrapper();
            this.iterable.forEach(action.andThen(repeater::add));
            for (int i = 0; i < this.repeats; ++i) {
                repeater.forEach(action);
            }
        }
    }

    private static class FlatMappedArrayIterable<T>
    implements ObjectIterable<T> {
        CharIterable iterable;
        CharFunction<T[]> mapper;

        FlatMappedArrayIterable(CharIterable iterable, CharFunction<T[]> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return CharIterators.arrayFlatMap(this.iterable.iterator(), this.mapper);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((char E) -> {
                T[] array = this.mapper.apply(E);
                int i = 0;
                int m = array.length;
                while (i < m) {
                    action.accept((T)array[i++]);
                }
            });
        }
    }

    private static class FlatMappedIterable<T, V extends Iterable<T>>
    implements ObjectIterable<T> {
        CharIterable iterable;
        CharFunction<V> mapper;

        FlatMappedIterable(CharIterable iterable, CharFunction<V> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return CharIterators.flatMap(this.iterable.iterator(), this.mapper);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((char E) -> ((Iterable)this.mapper.apply(E)).forEach(action));
        }
    }

    private static class MappedIterable<T>
    implements ObjectIterable<T>,
    ISizeProvider {
        CharIterable iterable;
        CharFunction<T> mapper;

        MappedIterable(CharIterable iterable, CharFunction<T> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public ObjectIterator<T> iterator() {
            return CharIterators.map(this.iterable.iterator(), this.mapper);
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            Objects.requireNonNull(action);
            this.iterable.forEach((char E) -> action.accept((T)this.mapper.apply(E)));
        }
    }

    private static class WrappedIterable
    implements CharIterable,
    ISizeProvider {
        Iterable<? extends Character> iterable;

        public WrappedIterable(Iterable<? extends Character> iterable) {
            this.iterable = iterable;
        }

        @Override
        public CharIterator iterator() {
            return CharIterators.wrap(this.iterable.iterator());
        }

        @Override
        public int size() {
            ISizeProvider prov = ISizeProvider.of(this.iterable);
            return prov == null ? -1 : prov.size();
        }

        @Override
        public void forEach(CharConsumer action) {
            Objects.requireNonNull(action);
            this.iterable.forEach(action);
        }
    }
}

