/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.utils;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import speiger.src.collections.chars.collections.CharCollection;
import speiger.src.collections.chars.collections.CharIterator;
import speiger.src.collections.chars.collections.CharSplititerator;
import speiger.src.collections.chars.functions.CharConsumer;
import speiger.src.collections.utils.SanityChecks;

public class CharSplititerators {
    public static Spliterator.OfInt createArrayJavaSplititerator(char[] array, int characteristics) {
        return CharSplititerators.createArrayJavaSplititerator(array, 0, array.length, characteristics);
    }

    public static Spliterator.OfInt createArrayJavaSplititerator(char[] array, int size, int characteristics) {
        return CharSplititerators.createArrayJavaSplititerator(array, 0, size, characteristics);
    }

    public static Spliterator.OfInt createArrayJavaSplititerator(char[] array, int offset, int size, int characteristics) {
        SanityChecks.checkArrayCapacity(array.length, offset, size);
        return new ArraySplitIterator(array, offset, size, characteristics);
    }

    public static Spliterator.OfInt createJavaSplititerator(CharCollection collection, int characteristics) {
        return new IteratorSpliterator(collection, characteristics);
    }

    public static Spliterator.OfInt createUnknownJavaSplititerator(CharIterator iterator, int characteristics) {
        return new IteratorSpliterator(iterator, characteristics);
    }

    public static Spliterator.OfInt createSizedJavaSplititerator(CharIterator iterator, long size, int characteristics) {
        return new IteratorSpliterator(iterator, size, characteristics);
    }

    public static CharSplititerator createArraySplititerator(char[] array, int characteristics) {
        return CharSplititerators.createArraySplititerator(array, 0, array.length, characteristics);
    }

    public static CharSplititerator createArraySplititerator(char[] array, int size, int characteristics) {
        return CharSplititerators.createArraySplititerator(array, 0, size, characteristics);
    }

    public static CharSplititerator createArraySplititerator(char[] array, int offset, int size, int characteristics) {
        SanityChecks.checkArrayCapacity(array.length, offset, size);
        return new TypeArraySplitIterator(array, offset, size, characteristics);
    }

    public static CharSplititerator createSplititerator(CharCollection collection, int characteristics) {
        return new TypeIteratorSpliterator(collection, characteristics);
    }

    public static CharSplititerator createUnknownSplititerator(CharIterator iterator, int characteristics) {
        return new TypeIteratorSpliterator(iterator, characteristics);
    }

    public static CharSplititerator createSizedSplititerator(CharIterator iterator, long size, int characteristics) {
        return new TypeIteratorSpliterator(iterator, size, characteristics);
    }

    static final class ArraySplitIterator
    implements Spliterator.OfInt {
        private final char[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public ArraySplitIterator(char[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            ArraySplitIterator arraySplitIterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                arraySplitIterator = null;
            } else {
                this.index = mid;
                ArraySplitIterator arraySplitIterator2 = new ArraySplitIterator(this.array, lo, this.index, this.characteristics);
                arraySplitIterator = arraySplitIterator2;
            }
            return arraySplitIterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static class IteratorSpliterator
    implements Spliterator.OfInt {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final CharCollection collection;
        private CharIterator it;
        private final int characteristics;
        private long est;
        private int batch;

        IteratorSpliterator(CharCollection collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        IteratorSpliterator(CharIterator iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        IteratorSpliterator(CharIterator iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        private CharIterator iterator() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            return this.it;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            CharIterator i = this.iterator();
            if (this.est > 1L && i.hasNext()) {
                int n = Math.min(this.batch + 1024, Math.min((int)this.est, 0x2000000));
                char[] a = new char[n];
                int j = 0;
                do {
                    a[j] = i.nextChar();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new ArraySplitIterator(a, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.iterator().forEachRemaining((char T) -> action.accept(T));
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            CharIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept(iter.nextChar());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            this.iterator();
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class TypeArraySplitIterator
    implements CharSplititerator {
        private final char[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public TypeArraySplitIterator(char[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public CharSplititerator trySplit() {
            TypeArraySplitIterator typeArraySplitIterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                typeArraySplitIterator = null;
            } else {
                this.index = mid;
                TypeArraySplitIterator typeArraySplitIterator2 = new TypeArraySplitIterator(this.array, lo, this.index, this.characteristics);
                typeArraySplitIterator = typeArraySplitIterator2;
            }
            return typeArraySplitIterator;
        }

        @Override
        public void forEachRemaining(CharConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            char[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(Character.valueOf(this.array[this.index++]));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Character> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public char nextChar() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }

        @Override
        public boolean hasNext() {
            return this.index < this.fence;
        }
    }

    static class TypeIteratorSpliterator
    implements CharSplititerator {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final CharCollection collection;
        private CharIterator it;
        private final int characteristics;
        private long est;
        private int batch;

        TypeIteratorSpliterator(CharCollection collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        TypeIteratorSpliterator(CharIterator iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        TypeIteratorSpliterator(CharIterator iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        private CharIterator iterator() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            return this.it;
        }

        @Override
        public CharSplititerator trySplit() {
            CharIterator i = this.iterator();
            if (this.est > 1L && i.hasNext()) {
                int n = Math.min(this.batch + 1024, Math.min((int)this.est, 0x2000000));
                char[] a = new char[n];
                int j = 0;
                do {
                    a[j] = i.nextChar();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new TypeArraySplitIterator(a, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.iterator().forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(CharConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            CharIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept(iter.nextChar());
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Character> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            CharIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept(Character.valueOf(iter.nextChar()));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            this.iterator();
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Character> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public char nextChar() {
            return this.iterator().nextChar();
        }

        @Override
        public boolean hasNext() {
            return this.iterator().hasNext();
        }
    }
}

