/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.lists;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import speiger.src.collections.objects.collections.AbstractObjectCollection;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.collections.ObjectSplititerator;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.objects.lists.ObjectListIterator;
import speiger.src.collections.objects.utils.ObjectSplititerators;
import speiger.src.collections.utils.SanityChecks;

public abstract class AbstractObjectList<T>
extends AbstractObjectCollection<T>
implements ObjectList<T> {
    @Override
    public boolean add(T e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public boolean addAll(ObjectCollection<T> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(ObjectList<T> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends T> c) {
        return c instanceof ObjectCollection ? this.addAll((ObjectCollection)c) : this.addAll(this.size(), c);
    }

    @Override
    public int indexOf(Object o) {
        ListIterator iter = this.listIterator();
        if (o == null) {
            while (iter.hasNext()) {
                if (iter.next() != null) continue;
                return iter.previousIndex();
            }
            return -1;
        }
        while (iter.hasNext()) {
            if (!Objects.equals(o, iter.next())) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        ListIterator iter = this.listIterator(this.size());
        if (o == null) {
            while (iter.hasPrevious()) {
                if (iter.previous() != null) continue;
                return iter.nextIndex();
            }
            return -1;
        }
        while (iter.hasPrevious()) {
            if (!Objects.equals(o, iter.previous())) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    @Override
    public boolean swapRemove(T e) {
        int index = this.indexOf(e);
        if (index == -1) {
            return false;
        }
        this.swapRemove(index);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        if (l.size() != this.size()) {
            return false;
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = l.listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            if (Objects.equals(e1.next(), e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        ListIterator i = this.listIterator();
        while (i.hasNext()) {
            hashCode = 31 * hashCode + i.next().hashCode();
        }
        return hashCode;
    }

    @Override
    public ObjectList<T> subList(int fromIndex, int toIndex) {
        SanityChecks.checkArrayCapacity(this.size(), fromIndex, toIndex - fromIndex);
        return new SubList(this, 0, fromIndex, toIndex);
    }

    @Override
    public ObjectList<T> reversed() {
        return new ReversedList(this);
    }

    @Override
    public ObjectIterator<T> iterator() {
        return this.listIterator(0);
    }

    @Override
    public ObjectListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ObjectListIterator<T> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new ObjectListIter(index);
    }

    @Override
    public ObjectListIterator<T> indexedIterator(int ... indecies) {
        return new IndexedIterator(indecies);
    }

    @Override
    public void size(int size) {
        while (size > this.size()) {
            this.add((T)null);
        }
        while (size < this.size()) {
            this.remove(this.size() - 1);
        }
    }

    @Override
    public AbstractObjectList<T> copy() {
        throw new UnsupportedOperationException();
    }

    private class ObjectListIter
    implements ObjectListIterator<T> {
        int index;
        int lastReturned = -1;

        ObjectListIter(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < AbstractObjectList.this.size();
        }

        @Override
        public T next() {
            int i;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = i = this.index++;
            return AbstractObjectList.this.get(this.lastReturned);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.index;
            this.lastReturned = this.index;
            return AbstractObjectList.this.get(this.lastReturned);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            AbstractObjectList.this.remove(this.lastReturned);
            this.index = this.lastReturned;
            this.lastReturned = -1;
        }

        @Override
        public void set(T e) {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            AbstractObjectList.this.set(this.lastReturned, e);
        }

        @Override
        public void add(T e) {
            AbstractObjectList.this.add(this.index, e);
            ++this.index;
            this.lastReturned = -1;
        }

        @Override
        public int skip(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int steps = Math.min(amount, AbstractObjectList.this.size() - this.index);
            this.index += steps;
            if (steps > 0) {
                this.lastReturned = Math.min(this.index - 1, AbstractObjectList.this.size() - 1);
            }
            return steps;
        }

        @Override
        public int back(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int steps = Math.min(amount, this.index);
            this.index -= steps;
            if (steps > 0) {
                this.lastReturned = Math.max(this.index, 0);
            }
            return steps;
        }
    }

    private class IndexedIterator
    implements ObjectListIterator<T> {
        int[] indecies;
        int index;
        int lastReturned = -1;

        IndexedIterator(int[] indecies) {
            this.indecies = indecies;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.indecies.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int i = this.index++;
            this.lastReturned = this.indecies[i];
            return AbstractObjectList.this.get(this.lastReturned);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.index;
            this.lastReturned = this.indecies[this.index];
            return AbstractObjectList.this.get(this.lastReturned);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            AbstractObjectList.this.set(this.lastReturned, e);
        }

        @Override
        public int skip(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int steps = Math.min(amount, this.indecies.length - this.index);
            this.index += steps;
            if (steps > 0) {
                this.lastReturned = Math.min(this.index - 1, this.indecies.length - 1);
            }
            return steps;
        }

        @Override
        public int back(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int steps = Math.min(amount, this.index);
            this.index -= steps;
            if (steps > 0) {
                this.lastReturned = Math.max(this.index, 0);
            }
            return steps;
        }
    }

    private class SubList
    extends AbstractObjectList<T> {
        final AbstractObjectList<T> list;
        final int parentOffset;
        final int offset;
        int size;

        public SubList(AbstractObjectList<T> list, int offset, int from, int to) {
            this.list = list;
            this.parentOffset = from;
            this.offset = offset + from;
            this.size = to - from;
        }

        @Override
        public void add(int index, T element) {
            this.checkAddSubRange(index);
            this.list.add(this.parentOffset + index, element);
            ++this.size;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            this.checkAddSubRange(index);
            int add = c.size();
            if (add <= 0) {
                return false;
            }
            this.list.addAll(this.parentOffset + index, c);
            this.size += add;
            return true;
        }

        @Override
        public boolean addAll(int index, ObjectCollection<T> c) {
            this.checkAddSubRange(index);
            int add = c.size();
            if (add <= 0) {
                return false;
            }
            this.list.addAll(this.parentOffset + index, c);
            this.size += add;
            return true;
        }

        @Override
        public boolean addAll(int index, ObjectList<T> c) {
            this.checkAddSubRange(index);
            int add = c.size();
            if (add <= 0) {
                return false;
            }
            this.list.addAll(this.parentOffset + index, c);
            this.size += add;
            return true;
        }

        @Override
        public void addElements(int from, T[] a, int offset, int length) {
            this.checkAddSubRange(from);
            if (length <= 0) {
                return;
            }
            this.list.addElements(this.parentOffset + from, a, offset, length);
            this.size += length;
        }

        @Override
        public T[] getElements(int from, T[] a, int offset, int length) {
            SanityChecks.checkArrayCapacity(this.size, from, length);
            SanityChecks.checkArrayCapacity(a.length, offset, length);
            return this.list.getElements(from + this.parentOffset, a, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            if (to - from <= 0) {
                return;
            }
            this.checkSubRange(from);
            this.checkAddSubRange(to);
            this.list.removeElements(from + this.parentOffset, to + this.parentOffset);
            this.size -= to - from;
        }

        @Override
        public <K> K[] extractElements(int from, int to, Class<K> type) {
            this.checkSubRange(from);
            this.checkAddSubRange(to);
            K[] result = this.list.extractElements(from + this.parentOffset, to + this.parentOffset, type);
            this.size -= result.length;
            return result;
        }

        @Override
        public T get(int index) {
            this.checkSubRange(index);
            return this.list.get(this.parentOffset + index);
        }

        @Override
        public T set(int index, T element) {
            this.checkSubRange(index);
            return this.list.set(this.parentOffset + index, element);
        }

        @Override
        public T swapRemove(int index) {
            this.checkSubRange(index);
            if (index == this.size - 1) {
                Object result = this.list.remove(this.parentOffset + this.size - 1);
                --this.size;
                return result;
            }
            Object result = this.list.set(index + this.parentOffset, this.list.get(this.parentOffset + this.size - 1));
            this.list.remove(this.parentOffset + this.size - 1);
            --this.size;
            return result;
        }

        @Override
        public T remove(int index) {
            this.checkSubRange(index);
            Object result = this.list.remove(index + this.parentOffset);
            --this.size;
            return result;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public ObjectSplititerator<T> spliterator() {
            return ObjectSplititerators.createSplititerator(this, 16464);
        }

        @Override
        public ObjectListIterator<T> listIterator(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return new SubListIterator(this, index);
        }

        @Override
        public ObjectList<T> subList(int fromIndex, int toIndex) {
            SanityChecks.checkArrayCapacity(this.size, fromIndex, toIndex - fromIndex);
            return new SubList(this, this.offset, fromIndex, toIndex);
        }

        protected void checkSubRange(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        }

        protected void checkAddSubRange(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        }

        private class SubListIterator
        implements ObjectListIterator<T> {
            AbstractObjectList<T> list;
            int index;
            int lastReturned = -1;

            SubListIterator(AbstractObjectList<T> list, int index) {
                this.list = list;
                this.index = index;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.list.size();
            }

            @Override
            public T next() {
                int i;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = i = this.index++;
                return this.list.get(this.lastReturned);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                --this.index;
                this.lastReturned = this.index;
                return this.list.get(this.lastReturned);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                if (this.lastReturned == -1) {
                    throw new IllegalStateException();
                }
                this.list.remove(this.lastReturned);
                this.index = this.lastReturned;
                this.lastReturned = -1;
            }

            @Override
            public void set(T e) {
                if (this.lastReturned == -1) {
                    throw new IllegalStateException();
                }
                this.list.set(this.lastReturned, e);
            }

            @Override
            public void add(T e) {
                this.list.add(this.index, e);
                ++this.index;
                this.lastReturned = -1;
            }

            @Override
            public int skip(int amount) {
                if (amount < 0) {
                    throw new IllegalStateException("Negative Numbers are not allowed");
                }
                int steps = Math.min(amount, SubList.this.size() - this.index);
                this.index += steps;
                if (steps > 0) {
                    this.lastReturned = Math.min(this.index - 1, SubList.this.size() - 1);
                }
                return steps;
            }

            @Override
            public int back(int amount) {
                if (amount < 0) {
                    throw new IllegalStateException("Negative Numbers are not allowed");
                }
                int steps = Math.min(amount, this.index);
                this.index -= steps;
                if (steps > 0) {
                    this.lastReturned = Math.min(this.index, SubList.this.size() - 1);
                }
                return steps;
            }
        }
    }

    private class ReversedList
    extends AbstractObjectList<T> {
        final AbstractObjectList<T> list;

        public ReversedList(AbstractObjectList<T> list) {
            this.list = list;
        }

        @Override
        public void add(int index, T e) {
            this.list.add(this.list.size() - index - 1, e);
        }

        @Override
        public boolean addAll(int index, ObjectCollection<T> c) {
            return this.addCollection(index, c);
        }

        @Override
        public boolean addAll(int index, ObjectList<T> c) {
            if (c instanceof RandomAccess) {
                int m = c.size();
                for (int i = 0; i < m; ++i) {
                    this.list.add(this.list.size() - index - i - 1, c.get(i));
                }
                return true;
            }
            return this.addCollection(index, c);
        }

        private boolean addCollection(int index, ObjectCollection<T> c) {
            int i = 0;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.list.add(this.list.size() - index - i - 1, iter.next());
                ++i;
            }
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            int i = 0;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.list.add(this.list.size() - index - i - 1, iter.next());
                ++i;
            }
            return true;
        }

        @Override
        public T get(int index) {
            return this.list.get(this.list.size() - index - 1);
        }

        @Override
        public T set(int index, T e) {
            return this.list.set(this.list.size() - index - 1, e);
        }

        @Override
        public T remove(int index) {
            return this.list.remove(this.list.size() - index - 1);
        }

        @Override
        public void addElements(int from, T[] a, int offset, int length) {
            int m = length;
            for (int i = 0; i < m; ++i) {
                this.list.add(this.list.size() - from - i - 1, a[i + offset]);
            }
        }

        @Override
        public T[] getElements(int from, T[] a, int offset, int length) {
            return this.reverse(this.list.getElements(this.list.size() - from - 1, a, offset, length));
        }

        @Override
        public void removeElements(int from, int to) {
            this.list.removeElements(this.list.size() - to - 1, this.list.size() - from - 1);
        }

        @Override
        public T swapRemove(int index) {
            return this.list.swapRemove(this.list.size() - index - 1);
        }

        @Override
        public <K> K[] extractElements(int from, int to, Class<K> type) {
            return this.reverse(this.list.extractElements(this.list.size() - to - 1, this.list.size() - from - 1, type));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public ObjectList<T> reversed() {
            return this.list;
        }

        private <K> K[] reverse(K[] data) {
            int i = 0;
            int mid = data.length >> 1;
            int j = data.length - 1;
            while (i < mid) {
                K t = data[i];
                data[i] = data[j];
                data[j] = t;
                ++i;
                --j;
            }
            return data;
        }
    }
}

