/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.sets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.objects.collections.ObjectBidirectionalIterator;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.functions.consumer.ObjectObjectConsumer;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.lists.ObjectListIterator;
import speiger.src.collections.objects.sets.ObjectOpenHashSet;
import speiger.src.collections.objects.sets.ObjectOrderedSet;
import speiger.src.collections.objects.utils.ObjectArrays;
import speiger.src.collections.utils.HashUtil;
import speiger.src.collections.utils.SanityChecks;

public class ObjectLinkedOpenHashSet<T>
extends ObjectOpenHashSet<T>
implements ObjectOrderedSet<T> {
    protected transient long[] links = new long[this.nullIndex + 1];
    protected int firstIndex = -1;
    protected int lastIndex = -1;

    public ObjectLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    public ObjectLinkedOpenHashSet(int minCapacity) {
        this(minCapacity, 0.75f);
    }

    public ObjectLinkedOpenHashSet(int minCapacity, float loadFactor) {
        super(minCapacity, loadFactor);
    }

    public ObjectLinkedOpenHashSet(T[] array) {
        this(array, 0, array.length, 0.75f);
    }

    public ObjectLinkedOpenHashSet(T[] array, float loadFactor) {
        this(array, 0, array.length, loadFactor);
    }

    public ObjectLinkedOpenHashSet(T[] array, int offset, int length) {
        this(array, offset, length, 0.75f);
    }

    public ObjectLinkedOpenHashSet(T[] array, int offset, int length, float loadFactor) {
        this(length);
        SanityChecks.checkArrayCapacity(array.length, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(array[offset + i]);
        }
    }

    public ObjectLinkedOpenHashSet(Collection<? extends T> collection) {
        this(collection, 0.75f);
    }

    public ObjectLinkedOpenHashSet(Collection<? extends T> collection, float loadFactor) {
        this(collection.size(), loadFactor);
        this.addAll(collection);
    }

    public ObjectLinkedOpenHashSet(ObjectCollection<T> collection) {
        this(collection, 0.75f);
    }

    public ObjectLinkedOpenHashSet(ObjectCollection<T> collection, float loadFactor) {
        this(collection.size());
        this.addAll(collection);
    }

    public ObjectLinkedOpenHashSet(Iterator<T> iterator) {
        this(iterator, 0.75f);
    }

    public ObjectLinkedOpenHashSet(Iterator<T> iterator, float loadFactor) {
        this(16, loadFactor);
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    @Override
    public boolean addAndMoveToFirst(T o) {
        if (o == null) {
            if (this.containsNull) {
                this.moveToFirstIndex(this.nullIndex);
                return false;
            }
            this.containsNull = true;
            this.onNodeAdded(this.nullIndex);
            this.moveToFirstIndex(this.nullIndex);
        } else {
            int pos = HashUtil.mix(Objects.hashCode(o)) & this.mask;
            while (this.keys[pos] != null) {
                if (Objects.equals(this.keys[pos], o)) {
                    this.moveToFirstIndex(pos);
                    return false;
                }
                ++pos;
                pos &= this.mask;
            }
            this.keys[pos] = o;
            this.onNodeAdded(pos);
            this.moveToFirstIndex(pos);
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
        return true;
    }

    @Override
    public boolean addAndMoveToLast(T o) {
        if (o == null) {
            if (this.containsNull) {
                this.moveToLastIndex(this.nullIndex);
                return false;
            }
            this.containsNull = true;
            this.onNodeAdded(this.nullIndex);
        } else {
            int pos = HashUtil.mix(Objects.hashCode(o)) & this.mask;
            while (this.keys[pos] != null) {
                if (Objects.equals(this.keys[pos], o)) {
                    this.moveToLastIndex(pos);
                    return false;
                }
                ++pos;
                pos &= this.mask;
            }
            this.keys[pos] = o;
            this.onNodeAdded(pos);
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(HashUtil.arraySize(this.size + 1, this.loadFactor));
        }
        return true;
    }

    @Override
    public boolean moveToFirst(T o) {
        if (this.isEmpty() || Objects.equals(this.first(), o)) {
            return false;
        }
        if (o == null) {
            if (this.containsNull) {
                this.moveToFirstIndex(this.nullIndex);
                return true;
            }
        } else {
            int pos = HashUtil.mix(Objects.hashCode(o)) & this.mask;
            while (this.keys[pos] != null) {
                if (Objects.equals(this.keys[pos], o)) {
                    this.moveToFirstIndex(pos);
                    return true;
                }
                ++pos;
                pos &= this.mask;
            }
        }
        return false;
    }

    @Override
    public boolean moveToLast(T o) {
        if (this.isEmpty() || Objects.equals(this.last(), o)) {
            return false;
        }
        if (o == null) {
            if (this.containsNull) {
                this.moveToLastIndex(this.nullIndex);
                return true;
            }
        } else {
            int pos = HashUtil.mix(Objects.hashCode(o)) & this.mask;
            while (this.keys[pos] != null) {
                if (Objects.equals(this.keys[pos], o)) {
                    this.moveToLastIndex(pos);
                    return true;
                }
                ++pos;
                pos &= this.mask;
            }
        }
        return false;
    }

    protected void moveToFirstIndex(int startPos) {
        if (this.size == 1 || this.firstIndex == startPos) {
            return;
        }
        if (this.lastIndex == startPos) {
            int n = this.lastIndex = (int)(this.links[startPos] >>> 32);
            this.links[n] = this.links[n] | 0xFFFFFFFFL;
        } else {
            long link = this.links[startPos];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n = prev;
            this.links[n] = this.links[n] ^ (this.links[prev] ^ link & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.links[n2] = this.links[n2] ^ (this.links[next] ^ link & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.firstIndex;
        this.links[n] = this.links[n] ^ (this.links[this.firstIndex] ^ ((long)startPos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.links[startPos] = 0xFFFFFFFF00000000L | (long)this.firstIndex & 0xFFFFFFFFL;
        this.firstIndex = startPos;
    }

    protected void moveToLastIndex(int startPos) {
        if (this.size == 1 || this.lastIndex == startPos) {
            return;
        }
        if (this.firstIndex == startPos) {
            this.firstIndex = (int)this.links[startPos];
            int n = this.lastIndex;
            this.links[n] = this.links[n] | 0xFFFFFFFF00000000L;
        } else {
            long link = this.links[startPos];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n = prev;
            this.links[n] = this.links[n] ^ (this.links[prev] ^ link & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.links[n2] = this.links[n2] ^ (this.links[next] ^ link & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.lastIndex;
        this.links[n] = this.links[n] ^ (this.links[this.lastIndex] ^ (long)startPos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.links[startPos] = ((long)this.lastIndex & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.lastIndex = startPos;
    }

    @Override
    public T first() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (T)this.keys[this.firstIndex];
    }

    @Override
    public T pollFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos = this.firstIndex;
        this.onNodeRemoved(pos);
        Object result = this.keys[pos];
        --this.size;
        if (result == null) {
            this.containsNull = false;
            this.keys[this.nullIndex] = null;
        } else {
            this.shiftKeys(pos);
        }
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return (T)result;
    }

    @Override
    public T last() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (T)this.keys[this.lastIndex];
    }

    @Override
    public T pollLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int pos = this.lastIndex;
        this.onNodeRemoved(pos);
        Object result = this.keys[pos];
        --this.size;
        if (result == null) {
            this.containsNull = false;
            this.keys[this.nullIndex] = null;
        } else {
            this.shiftKeys(pos);
        }
        if (this.nullIndex > this.minCapacity && this.size < this.maxFill / 4 && this.nullIndex > 16) {
            this.rehash(this.nullIndex / 2);
        }
        return (T)result;
    }

    @Override
    @Deprecated
    public Object[] toArray() {
        if (this.isEmpty()) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        Object[] obj = new Object[this.size()];
        int i = 0;
        int index = this.firstIndex;
        while (index != -1) {
            obj[i] = this.keys[index];
            ++i;
            index = (int)this.links[index];
        }
        return obj;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = ObjectArrays.newArray(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        int index = this.firstIndex;
        while (index != -1) {
            a[i] = this.keys[index];
            ++i;
            index = (int)this.links[index];
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        int index = this.firstIndex;
        while (index != -1) {
            action.accept(this.keys[index]);
            index = (int)this.links[index];
        }
    }

    @Override
    public void forEachIndexed(IntObjectConsumer<T> action) {
        Objects.requireNonNull(action);
        int count = 0;
        int index = this.firstIndex;
        while (index != -1) {
            action.accept(count++, (T)this.keys[index]);
            index = (int)this.links[index];
        }
    }

    @Override
    public <E> void forEach(E input, ObjectObjectConsumer<E, T> action) {
        Objects.requireNonNull(action);
        int index = this.firstIndex;
        while (index != -1) {
            action.accept(input, (E)this.keys[index]);
            index = (int)this.links[index];
        }
    }

    @Override
    public boolean matchesAny(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        int index = this.firstIndex;
        while (index != -1) {
            if (filter.test(this.keys[index])) {
                return true;
            }
            index = (int)this.links[index];
        }
        return false;
    }

    @Override
    public boolean matchesNone(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        int index = this.firstIndex;
        while (index != -1) {
            if (filter.test(this.keys[index])) {
                return false;
            }
            index = (int)this.links[index];
        }
        return true;
    }

    @Override
    public boolean matchesAll(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        int index = this.firstIndex;
        while (index != -1) {
            if (!filter.test(this.keys[index])) {
                return false;
            }
            index = (int)this.links[index];
        }
        return true;
    }

    @Override
    public <E> E reduce(E identity, BiFunction<E, T, E> operator) {
        Objects.requireNonNull(operator);
        E state = identity;
        int index = this.firstIndex;
        while (index != -1) {
            state = operator.apply(state, this.keys[index]);
            index = (int)this.links[index];
        }
        return state;
    }

    @Override
    public T reduce(ObjectObjectUnaryOperator<T, T> operator) {
        Objects.requireNonNull(operator);
        Object state = null;
        boolean empty = true;
        int index = this.firstIndex;
        while (index != -1) {
            if (empty) {
                state = this.keys[index];
                empty = false;
            } else {
                state = operator.apply(state, this.keys[index]);
            }
            index = (int)this.links[index];
        }
        return (T)state;
    }

    @Override
    public T findFirst(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        int index = this.firstIndex;
        while (index != -1) {
            if (filter.test(this.keys[index])) {
                return (T)this.keys[index];
            }
            index = (int)this.links[index];
        }
        return null;
    }

    @Override
    public int count(Predicate<T> filter) {
        Objects.requireNonNull(filter);
        int result = 0;
        int index = this.firstIndex;
        while (index != -1) {
            if (filter.test(this.keys[index])) {
                ++result;
            }
            index = (int)this.links[index];
        }
        return result;
    }

    @Override
    protected void onNodeAdded(int pos) {
        if (this.size == 0) {
            this.firstIndex = this.lastIndex = pos;
            this.links[pos] = -1L;
        } else {
            int n = this.lastIndex;
            this.links[n] = this.links[n] ^ (this.links[this.lastIndex] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.links[pos] = ((long)this.lastIndex & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.lastIndex = pos;
        }
    }

    @Override
    protected void onNodeRemoved(int pos) {
        if (this.size == 0) {
            this.lastIndex = -1;
            this.firstIndex = -1;
        } else if (this.firstIndex == pos) {
            this.firstIndex = (int)this.links[pos];
            if (0 <= this.firstIndex) {
                int n = this.firstIndex;
                this.links[n] = this.links[n] | 0xFFFFFFFF00000000L;
            }
        } else if (this.lastIndex == pos) {
            this.lastIndex = (int)(this.links[pos] >>> 32);
            if (0 <= this.lastIndex) {
                int n = this.lastIndex;
                this.links[n] = this.links[n] | 0xFFFFFFFFL;
            }
        } else {
            long link = this.links[pos];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n = prev;
            this.links[n] = this.links[n] ^ (this.links[prev] ^ link & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.links[n2] = this.links[n2] ^ (this.links[next] ^ link & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
    }

    @Override
    protected void onNodeMoved(int from, int to) {
        if (this.size == 1) {
            this.firstIndex = this.lastIndex = to;
            this.links[to] = -1L;
        } else if (this.firstIndex == from) {
            this.firstIndex = to;
            int n = (int)this.links[from];
            this.links[n] = this.links[n] ^ (this.links[(int)this.links[from]] ^ ((long)to & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.links[to] = this.links[from];
        } else if (this.lastIndex == from) {
            this.lastIndex = to;
            int n = (int)(this.links[from] >>> 32);
            this.links[n] = this.links[n] ^ (this.links[(int)(this.links[from] >>> 32)] ^ (long)to & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.links[to] = this.links[from];
        } else {
            long link = this.links[from];
            int prev = (int)(link >>> 32);
            int next = (int)link;
            int n = prev;
            this.links[n] = this.links[n] ^ (this.links[prev] ^ (long)to & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.links[n2] = this.links[n2] ^ (this.links[next] ^ ((long)to & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.links[to] = link;
        }
    }

    @Override
    protected void rehash(int newSize) {
        int newMask = newSize - 1;
        Object[] newKeys = new Object[newSize + 1];
        long[] newLinks = new long[newSize + 1];
        int i = this.firstIndex;
        int prev = -1;
        int newPrev = -1;
        this.firstIndex = -1;
        int j = this.size;
        while (j-- != 0) {
            int pos;
            if (this.keys[i] == null) {
                pos = newSize;
            } else {
                pos = HashUtil.mix(Objects.hashCode(this.keys[i])) & newMask;
                while (newKeys[pos] != null) {
                    ++pos;
                    pos &= newMask;
                }
            }
            newKeys[pos] = this.keys[i];
            if (prev != -1) {
                int n = newPrev;
                newLinks[n] = newLinks[n] ^ (newLinks[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                newLinks[n2] = newLinks[n2] ^ (newLinks[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.firstIndex = pos;
                newLinks[pos] = -1L;
            }
            prev = i;
            i = (int)this.links[prev];
        }
        this.links = newLinks;
        this.lastIndex = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLinks[n] = newLinks[n] | 0xFFFFFFFFL;
        }
        this.nullIndex = newSize;
        this.mask = newMask;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = newKeys;
    }

    @Override
    public void clear() {
        super.clear();
        this.lastIndex = -1;
        this.firstIndex = -1;
    }

    @Override
    public void clearAndTrim(int size) {
        int request = Math.max(this.minCapacity, HashUtil.nextPowerOfTwo((int)Math.ceil((float)size / this.loadFactor)));
        if (request >= this.nullIndex) {
            this.clear();
            return;
        }
        this.nullIndex = request;
        this.mask = request - 1;
        this.maxFill = Math.min((int)Math.ceil((float)this.nullIndex * this.loadFactor), this.nullIndex - 1);
        this.keys = new Object[request + 1];
        this.links = new long[request + 1];
        this.lastIndex = -1;
        this.firstIndex = -1;
        this.size = 0;
        this.containsNull = false;
    }

    @Override
    public ObjectListIterator<T> iterator() {
        return new SetIterator();
    }

    @Override
    public ObjectBidirectionalIterator<T> iterator(T fromElement) {
        return new SetIterator(fromElement);
    }

    @Override
    public ObjectLinkedOpenHashSet<T> copy() {
        ObjectLinkedOpenHashSet<T> set = new ObjectLinkedOpenHashSet<T>(0, this.loadFactor);
        set.minCapacity = this.minCapacity;
        set.mask = this.mask;
        set.maxFill = this.maxFill;
        set.nullIndex = this.nullIndex;
        set.containsNull = this.containsNull;
        set.size = this.size;
        set.keys = Arrays.copyOf(this.keys, this.keys.length);
        set.links = Arrays.copyOf(this.links, this.links.length);
        set.firstIndex = this.firstIndex;
        set.lastIndex = this.lastIndex;
        return set;
    }

    private class SetIterator
    implements ObjectListIterator<T> {
        int previous = -1;
        int next = -1;
        int current = -1;
        int index = 0;

        SetIterator() {
            this.next = ObjectLinkedOpenHashSet.this.firstIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        SetIterator(T from) {
            if (from == null) {
                if (!ObjectLinkedOpenHashSet.this.containsNull) throw new NoSuchElementException("The null element is not in the set");
                this.next = (int)ObjectLinkedOpenHashSet.this.links[ObjectLinkedOpenHashSet.this.nullIndex];
                this.previous = ObjectLinkedOpenHashSet.this.nullIndex;
                return;
            } else if (Objects.equals(ObjectLinkedOpenHashSet.this.keys[ObjectLinkedOpenHashSet.this.lastIndex], from)) {
                this.previous = ObjectLinkedOpenHashSet.this.lastIndex;
                this.index = ObjectLinkedOpenHashSet.this.size;
                return;
            } else {
                int pos = HashUtil.mix(Objects.hashCode(from)) & ObjectLinkedOpenHashSet.this.mask;
                while (ObjectLinkedOpenHashSet.this.keys[pos] != null) {
                    if (Objects.equals(ObjectLinkedOpenHashSet.this.keys[pos], from)) {
                        this.next = (int)ObjectLinkedOpenHashSet.this.links[pos];
                        this.previous = pos;
                        break;
                    }
                    ++pos;
                    pos &= ObjectLinkedOpenHashSet.this.mask;
                }
                if (this.previous != -1 || this.next != -1) return;
                throw new NoSuchElementException("The element was not found");
            }
        }

        @Override
        public int skip(int amount) {
            int result;
            for (result = 0; this.next != -1 && result != amount; ++result) {
                this.current = this.previous = this.next;
                this.next = (int)ObjectLinkedOpenHashSet.this.links[this.current];
            }
            if (this.index >= 0) {
                this.index += result;
            }
            return result;
        }

        @Override
        public int back(int amount) {
            int result;
            for (result = 0; this.previous != -1 && result != amount; ++result) {
                this.current = this.next = this.previous;
                this.previous = (int)(ObjectLinkedOpenHashSet.this.links[this.current] >> 32);
            }
            if (this.index >= 0) {
                this.index -= result;
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.next != -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != -1;
        }

        @Override
        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        @Override
        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            this.ensureIndexKnown();
            if (this.current == this.previous) {
                --this.index;
                this.previous = (int)(ObjectLinkedOpenHashSet.this.links[this.current] >>> 32);
            } else {
                this.next = (int)ObjectLinkedOpenHashSet.this.links[this.current];
            }
            --ObjectLinkedOpenHashSet.this.size;
            if (this.previous == -1) {
                ObjectLinkedOpenHashSet.this.firstIndex = this.next;
            } else {
                int n = this.previous;
                ObjectLinkedOpenHashSet.this.links[n] = ObjectLinkedOpenHashSet.this.links[n] ^ (ObjectLinkedOpenHashSet.this.links[this.previous] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                ObjectLinkedOpenHashSet.this.lastIndex = this.previous;
            } else {
                int n = this.next;
                ObjectLinkedOpenHashSet.this.links[n] = ObjectLinkedOpenHashSet.this.links[n] ^ (ObjectLinkedOpenHashSet.this.links[this.next] ^ ((long)this.previous & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            if (this.current != ObjectLinkedOpenHashSet.this.nullIndex) {
                int startPos = this.current;
                this.current = -1;
                while (true) {
                    Object current;
                    int last = startPos;
                    startPos = last + 1 & ObjectLinkedOpenHashSet.this.mask;
                    while (true) {
                        if ((current = ObjectLinkedOpenHashSet.this.keys[startPos]) == null) {
                            ObjectLinkedOpenHashSet.this.keys[last] = null;
                            return;
                        }
                        int slot = HashUtil.mix(Objects.hashCode(current)) & ObjectLinkedOpenHashSet.this.mask;
                        if (last <= startPos ? last >= slot || slot > startPos : last >= slot && slot > startPos) break;
                        ++startPos;
                        startPos &= ObjectLinkedOpenHashSet.this.mask;
                    }
                    ObjectLinkedOpenHashSet.this.keys[last] = current;
                    if (this.next == startPos) {
                        this.next = last;
                    }
                    if (this.previous == startPos) {
                        this.previous = last;
                    }
                    ObjectLinkedOpenHashSet.this.onNodeMoved(startPos, last);
                }
            }
            this.current = -1;
            ObjectLinkedOpenHashSet.this.containsNull = false;
            ObjectLinkedOpenHashSet.this.keys[ObjectLinkedOpenHashSet.this.nullIndex] = null;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.current = this.next = this.previous;
            this.previous = (int)(ObjectLinkedOpenHashSet.this.links[this.current] >> 32);
            if (this.index >= 0) {
                --this.index;
            }
            return ObjectLinkedOpenHashSet.this.keys[this.current];
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.previous = this.next;
            this.next = (int)ObjectLinkedOpenHashSet.this.links[this.current];
            if (this.index >= 0) {
                ++this.index;
            }
            return ObjectLinkedOpenHashSet.this.keys[this.current];
        }

        private void ensureIndexKnown() {
            if (this.index == -1) {
                if (this.previous == -1) {
                    this.index = 0;
                } else if (this.next == -1) {
                    this.index = ObjectLinkedOpenHashSet.this.size;
                } else {
                    this.index = 1;
                    int pos = ObjectLinkedOpenHashSet.this.firstIndex;
                    while (pos != this.previous) {
                        pos = (int)ObjectLinkedOpenHashSet.this.links[pos];
                        ++this.index;
                    }
                }
            }
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }
    }
}

