/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.utils;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import java.util.RandomAccess;
import java.util.function.Consumer;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.lists.AbstractObjectList;
import speiger.src.collections.objects.lists.ObjectList;
import speiger.src.collections.objects.lists.ObjectListIterator;
import speiger.src.collections.objects.utils.IObjectArray;
import speiger.src.collections.objects.utils.ObjectArrays;
import speiger.src.collections.objects.utils.ObjectCollections;
import speiger.src.collections.objects.utils.ObjectIterators;
import speiger.src.collections.utils.SanityChecks;

public class ObjectLists {
    private static final EmptyList<?> EMPTY = new EmptyList();

    public static <T> EmptyList<T> empty() {
        return EMPTY;
    }

    public static <T> ObjectList<T> unmodifiable(ObjectList<T> l) {
        return l instanceof UnmodifiableList ? l : (l instanceof RandomAccess ? new UnmodifiableRandomList(l) : new UnmodifiableList(l));
    }

    public static <T> ObjectList<T> synchronize(ObjectList<T> l) {
        return l instanceof SynchronizedList ? l : (l instanceof IObjectArray ? new SynchronizedArrayList(l) : (l instanceof RandomAccess ? new SynchronizedRandomAccessList(l) : new SynchronizedList(l)));
    }

    public static <T> ObjectList<T> synchronize(ObjectList<T> l, Object mutex) {
        return l instanceof SynchronizedList ? l : (l instanceof IObjectArray ? new SynchronizedArrayList(l, mutex) : (l instanceof RandomAccess ? new SynchronizedRandomAccessList(l, mutex) : new SynchronizedList(l, mutex)));
    }

    public static <T> ObjectList<T> singleton(T element) {
        return new SingletonList<T>(element);
    }

    public static <T> ObjectList<T> reverse(ObjectList<T> list) {
        IObjectArray array;
        int size = list.size();
        if (list instanceof IObjectArray && (array = (IObjectArray)((Object)list)).isCastable()) {
            if (list instanceof SynchronizedArrayList) {
                array.elements(T -> ObjectArrays.reverse(T, size));
            } else {
                ObjectArrays.reverse(array.elements(), size);
            }
            return list;
        }
        if (list instanceof RandomAccess) {
            int i = 0;
            int mid = size >> 1;
            int j = size - 1;
            while (i < mid) {
                Object t = list.get(i);
                list.set(i, list.get(j));
                list.set(j, t);
                ++i;
                --j;
            }
            return list;
        }
        ListIterator fwd = list.listIterator();
        ListIterator rev = list.listIterator(size);
        int mid = size >> 1;
        for (int i = 0; i < mid; ++i) {
            Object tmp = fwd.next();
            fwd.set(rev.previous());
            rev.set(tmp);
        }
        return list;
    }

    public static <T> ObjectList<T> shuffle(ObjectList<T> list) {
        return ObjectLists.shuffle(list, SanityChecks.getRandom());
    }

    public static <T> ObjectList<T> shuffle(ObjectList<T> list, Random random) {
        int size = list.size();
        if (list instanceof IObjectArray) {
            IObjectArray array = (IObjectArray)((Object)list);
            if (array.isCastable()) {
                if (list instanceof SynchronizedArrayList) {
                    array.elements(T -> ObjectArrays.shuffle(T, size, random));
                } else {
                    ObjectArrays.shuffle(array.elements(), size, random);
                }
            } else {
                int i = list.size();
                while (i-- != 0) {
                    int p = random.nextInt(i + 1);
                    Object t = list.get(i);
                    list.set(i, list.get(p));
                    list.set(p, t);
                }
            }
            return list;
        }
        int i = size;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            Object t = list.get(i);
            list.set(i, list.get(p));
            list.set(p, t);
        }
        return list;
    }

    private static class EmptyList<T>
    extends ObjectCollections.EmptyCollection<T>
    implements ObjectList<T> {
        private EmptyList() {
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ObjectList<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, ObjectList<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public T set(int index, T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T swapRemove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean swapRemove(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object e) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object e) {
            return -1;
        }

        @Override
        public void addElements(int from, T[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T[] getElements(int from, T[] a, int offset, int length) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> K[] extractElements(int from, int to, Class<K> clz) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectListIterator<T> listIterator() {
            return ObjectIterators.empty();
        }

        @Override
        public ObjectListIterator<T> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ObjectIterators.empty();
        }

        @Override
        public ObjectListIterator<T> indexedIterator(int ... indecies) {
            return ObjectIterators.empty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            return ((List)o).isEmpty();
        }

        @Override
        public ObjectList<T> subList(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectList<T> reversed() {
            return this;
        }

        @Override
        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmptyList<T> copy() {
            return this;
        }
    }

    private static class UnmodifiableList<T>
    extends ObjectCollections.UnmodifiableCollection<T>
    implements ObjectList<T> {
        final ObjectList<T> l;

        UnmodifiableList(ObjectList<T> l) {
            super(l);
            this.l = l;
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(ObjectList<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, ObjectList<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(int index) {
            return (T)this.l.get(index);
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this.l.forEach(action);
        }

        @Override
        public T set(int index, T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T swapRemove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean swapRemove(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object e) {
            return this.l.indexOf(e);
        }

        @Override
        public int lastIndexOf(Object e) {
            return this.l.lastIndexOf(e);
        }

        @Override
        public void addElements(int from, T[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T[] getElements(int from, T[] a, int offset, int length) {
            return this.l.getElements(from, a, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> K[] extractElements(int from, int to, Class<K> clz) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectListIterator<T> listIterator() {
            return ObjectIterators.unmodifiable(this.l.listIterator());
        }

        @Override
        public ObjectListIterator<T> listIterator(int index) {
            return ObjectIterators.unmodifiable(this.l.listIterator(index));
        }

        @Override
        public ObjectListIterator<T> indexedIterator(int ... indecies) {
            return ObjectIterators.unmodifiable(this.l.indexedIterator(indecies));
        }

        @Override
        public ObjectList<T> subList(int from, int to) {
            return ObjectLists.unmodifiable(this.l.subList(from, to));
        }

        @Override
        public ObjectList<T> reversed() {
            return ObjectLists.unmodifiable(this.l.reversed());
        }

        @Override
        public void size(int size) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectList<T> copy() {
            return this.l.copy();
        }
    }

    private static class UnmodifiableRandomList<T>
    extends UnmodifiableList<T>
    implements RandomAccess {
        UnmodifiableRandomList(ObjectList<T> l) {
            super(l);
        }
    }

    private static class SynchronizedList<T>
    extends ObjectCollections.SynchronizedCollection<T>
    implements ObjectList<T> {
        ObjectList<T> l;

        SynchronizedList(ObjectList<T> l) {
            super(l);
            this.l = l;
        }

        SynchronizedList(ObjectList<T> l, Object mutex) {
            super(l, mutex);
            this.l = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, T element) {
            Object object = this.mutex;
            synchronized (object) {
                this.l.add(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, ObjectCollection<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(ObjectList<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, ObjectList<T> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return (T)this.l.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super T> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.l.forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T set(int index, T e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.set(index, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return (T)this.l.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T swapRemove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.swapRemove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean swapRemove(T e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.swapRemove(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.indexOf(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.lastIndexOf(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addElements(int from, T[] a, int offset, int length) {
            Object object = this.mutex;
            synchronized (object) {
                this.l.addElements(from, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T[] getElements(int from, T[] a, int offset, int length) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.getElements(from, a, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeElements(int from, int to) {
            Object object = this.mutex;
            synchronized (object) {
                this.l.removeElements(from, to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <K> K[] extractElements(int from, int to, Class<K> clz) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.extractElements(from, to, clz);
            }
        }

        @Override
        public ObjectListIterator<T> listIterator() {
            return this.l.listIterator();
        }

        @Override
        public ObjectListIterator<T> listIterator(int index) {
            return this.l.listIterator(index);
        }

        @Override
        public ObjectListIterator<T> indexedIterator(int ... indecies) {
            return this.l.indexedIterator(indecies);
        }

        @Override
        public ObjectList<T> subList(int from, int to) {
            return ObjectLists.synchronize(this.l.subList(from, to));
        }

        @Override
        public ObjectList<T> reversed() {
            return ObjectLists.synchronize(this.l.reversed());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void size(int size) {
            Object object = this.mutex;
            synchronized (object) {
                this.l.size(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectList<T> copy() {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.copy();
            }
        }
    }

    private static class SynchronizedRandomAccessList<T>
    extends SynchronizedList<T>
    implements RandomAccess {
        SynchronizedRandomAccessList(ObjectList<T> l) {
            super(l);
        }

        SynchronizedRandomAccessList(ObjectList<T> l, Object mutex) {
            super(l, mutex);
        }
    }

    private static class SynchronizedArrayList<T>
    extends SynchronizedList<T>
    implements IObjectArray<T> {
        IObjectArray<T> l;

        SynchronizedArrayList(ObjectList<T> l) {
            super(l);
            this.l = (IObjectArray)((Object)l);
        }

        SynchronizedArrayList(ObjectList<T> l, Object mutex) {
            super(l, mutex);
            this.l = (IObjectArray)((Object)l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ensureCapacity(int size) {
            Object object = this.mutex;
            synchronized (object) {
                this.l.ensureCapacity(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean trim(int size) {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.trim(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearAndTrim(int size) {
            Object object = this.mutex;
            synchronized (object) {
                this.l.clearAndTrim(size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T[] elements() {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.elements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCastable() {
            Object object = this.mutex;
            synchronized (object) {
                return this.l.isCastable();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elements(Consumer<T[]> action) {
            Objects.requireNonNull(action);
            Object object = this.mutex;
            synchronized (object) {
                this.l.elements(action);
            }
        }
    }

    private static class SingletonList<T>
    extends AbstractObjectList<T> {
        T element;

        SingletonList(T element) {
            this.element = element;
        }

        @Override
        public void add(int index, T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, ObjectCollection<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, ObjectList<T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T get(int index) {
            if (index == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public T set(int index, T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T swapRemove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addElements(int from, T[] a, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T[] getElements(int from, T[] a, int offset, int length) {
            if (from != 0 || length != 1) {
                throw new IndexOutOfBoundsException();
            }
            a[offset] = this.element;
            return a;
        }

        @Override
        public void removeElements(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> K[] extractElements(int from, int to, Class<K> type) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public SingletonList<T> copy() {
            return new SingletonList<T>(this.element);
        }
    }
}

