/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.objects.utils;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.collections.ObjectSplititerator;
import speiger.src.collections.utils.SanityChecks;

public class ObjectSplititerators {
    public static <T> ObjectSplititerator<T> createArraySplititerator(T[] array, int characteristics) {
        return ObjectSplititerators.createArraySplititerator(array, 0, array.length, characteristics);
    }

    public static <T> ObjectSplititerator<T> createArraySplititerator(T[] array, int size, int characteristics) {
        return ObjectSplititerators.createArraySplititerator(array, 0, size, characteristics);
    }

    public static <T> ObjectSplititerator<T> createArraySplititerator(T[] array, int offset, int size, int characteristics) {
        SanityChecks.checkArrayCapacity(array.length, offset, size);
        return new TypeArraySplitIterator<T>(array, offset, size, characteristics);
    }

    public static <T> ObjectSplititerator<T> createSplititerator(ObjectCollection<T> collection, int characteristics) {
        return new TypeIteratorSpliterator<T>(collection, characteristics);
    }

    public static <T> ObjectSplititerator<T> createUnknownSplititerator(ObjectIterator<T> iterator, int characteristics) {
        return new TypeIteratorSpliterator<T>(iterator, characteristics);
    }

    public static <T> ObjectSplititerator<T> createSizedSplititerator(ObjectIterator<T> iterator, long size, int characteristics) {
        return new TypeIteratorSpliterator<T>(iterator, size, characteristics);
    }

    static final class TypeArraySplitIterator<T>
    implements ObjectSplititerator<T> {
        private final T[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public TypeArraySplitIterator(T[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public ObjectSplititerator<T> trySplit() {
            TypeArraySplitIterator<T> typeArraySplitIterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                typeArraySplitIterator = null;
            } else {
                this.index = mid;
                TypeArraySplitIterator<T> typeArraySplitIterator2 = new TypeArraySplitIterator<T>(this.array, lo, this.index, this.characteristics);
                typeArraySplitIterator = typeArraySplitIterator2;
            }
            return typeArraySplitIterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            T[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }

        @Override
        public boolean hasNext() {
            return this.index < this.fence;
        }
    }

    static class TypeIteratorSpliterator<T>
    implements ObjectSplititerator<T> {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final ObjectCollection<T> collection;
        private ObjectIterator<T> it;
        private final int characteristics;
        private long est;
        private int batch;

        TypeIteratorSpliterator(ObjectCollection<T> collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        TypeIteratorSpliterator(ObjectIterator<T> iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        TypeIteratorSpliterator(ObjectIterator<T> iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        private ObjectIterator<T> iterator() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            return this.it;
        }

        @Override
        public ObjectSplititerator<T> trySplit() {
            ObjectIterator<T> i = this.iterator();
            if (this.est > 1L && i.hasNext()) {
                int n = Math.min(this.batch + 1024, Math.min((int)this.est, 0x2000000));
                Object[] a = new Object[n];
                int j = 0;
                do {
                    a[j] = i.next();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new TypeArraySplitIterator<Object>(a, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.iterator().forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            ObjectIterator<T> iter = this.iterator();
            if (iter.hasNext()) {
                action.accept(iter.next());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            this.iterator();
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super T> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public T next() {
            return (T)this.iterator().next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator().hasNext();
        }
    }
}

