/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.utils;

public class HashUtil {
    public static final int DEFAULT_MIN_CAPACITY = 16;
    public static final int DEFAULT_MIN_CONCURRENCY = 4;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final float FAST_LOAD_FACTOR = 0.5f;
    public static final float FASTER_LOAD_FACTOR = 0.25f;
    private static final int INT_PHI = -1640531527;
    private static final int INV_INT_PHI = 340573321;

    public static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public static int invMix(int x) {
        return (x ^ x >>> 16) * 340573321;
    }

    public static int nextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static long nextPowerOfTwo(long x) {
        return 1L << 64 - Long.numberOfLeadingZeros(x - 1L);
    }

    public static int getRequiredBits(int value) {
        return Integer.bitCount(HashUtil.nextPowerOfTwo(value + 1) - 1);
    }

    public static int getRequiredBits(long value) {
        return Long.bitCount(HashUtil.nextPowerOfTwo(value + 1L) - 1L);
    }

    public static int arraySize(int size, float loadFactor) {
        return (int)Math.min(0x40000000L, Math.max(2L, HashUtil.nextPowerOfTwo((long)Math.ceil((float)size / loadFactor))));
    }
}

