/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.util.List;
import net.blay09.mods.craftingtweaks.api.DefaultProvider;
import net.blay09.mods.craftingtweaks.api.RotationHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class DefaultProviderImpl
implements DefaultProvider {
    private static final RotationHandler rotationHandler = new RotationHandler(){

        @Override
        public boolean ignoreSlotId(int slotId) {
            return slotId == 4;
        }

        @Override
        public int rotateSlotId(int slotId, boolean counterClockwise) {
            if (!counterClockwise) {
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 5: {
                        return 8;
                    }
                    case 8: {
                        return 7;
                    }
                    case 7: {
                        return 6;
                    }
                    case 6: {
                        return 3;
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else {
                switch (slotId) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 6;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 8;
                    }
                    case 8: {
                        return 5;
                    }
                }
            }
            return 0;
        }
    };

    @Override
    public void clearGrid(EntityPlayer entityPlayer, Container container, IInventory craftMatrix) {
        this.clearGrid(entityPlayer, container, craftMatrix, 0, craftMatrix.func_70302_i_());
    }

    @Override
    public void clearGrid(EntityPlayer entityPlayer, Container container, IInventory craftMatrix, int start, int size) {
        for (int i = start; i < start + size; ++i) {
            ItemStack itemStack = craftMatrix.func_70301_a(i);
            if (itemStack != null && entityPlayer.field_71071_by.func_70441_a(itemStack)) {
                craftMatrix.func_70299_a(i, null);
            }
            container.func_75142_b();
        }
    }

    @Override
    public void balanceGrid(EntityPlayer entityPlayer, Container container, IInventory craftMatrix) {
        this.balanceGrid(entityPlayer, container, craftMatrix, 0, craftMatrix.func_70302_i_());
    }

    @Override
    public void balanceGrid(EntityPlayer entityPlayer, Container container, IInventory craftMatrix, int start, int size) {
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        for (int i = start; i < start + size; ++i) {
            ItemStack itemStack = craftMatrix.func_70301_a(i);
            if (itemStack == null || itemStack.func_77976_d() <= 1) continue;
            String key = itemStack.func_77977_a() + "@" + itemStack.func_77960_j();
            itemMap.put((Object)key, (Object)itemStack);
            itemCount.add((Object)key, itemStack.field_77994_a);
        }
        for (String key : itemMap.keySet()) {
            List balanceList = itemMap.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / balanceList.size();
            int restCount = totalCount % balanceList.size();
            for (ItemStack itemStack : balanceList) {
                itemStack.field_77994_a = countPerStack;
            }
            int idx = 0;
            while (restCount > 0) {
                ItemStack itemStack;
                itemStack = (ItemStack)balanceList.get(idx);
                if (itemStack.field_77994_a < itemStack.func_77976_d()) {
                    ++itemStack.field_77994_a;
                    --restCount;
                }
                if (++idx < balanceList.size()) continue;
                idx = 0;
            }
        }
        container.func_75142_b();
    }

    @Override
    public ItemStack putIntoGrid(EntityPlayer entityPlayer, Container container, IInventory craftMatrix, ItemStack itemStack, int index) {
        ItemStack craftStack = craftMatrix.func_70301_a(index);
        if (craftStack != null) {
            int spaceLeft;
            if (craftStack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)itemStack) && (spaceLeft = Math.min(craftMatrix.func_70297_j_(), craftStack.func_77976_d()) - craftStack.field_77994_a) > 0) {
                ItemStack splitStack = itemStack.func_77979_a(Math.min(spaceLeft, itemStack.field_77994_a));
                craftStack.field_77994_a += splitStack.field_77994_a;
                if (itemStack.field_77994_a <= 0) {
                    return null;
                }
            }
        } else {
            ItemStack transferStack = itemStack.func_77979_a(Math.min(itemStack.field_77994_a, craftMatrix.func_70297_j_()));
            craftMatrix.func_70299_a(index, transferStack);
        }
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    @Override
    public boolean transferIntoGrid(EntityPlayer entityPlayer, Container container, IInventory craftMatrix, Slot sourceSlot) {
        ItemStack itemStack = sourceSlot.func_75211_c();
        if (itemStack == null) {
            return false;
        }
        int firstEmptySlot = -1;
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            ItemStack craftStack = craftMatrix.func_70301_a(i);
            if (craftStack != null) {
                int spaceLeft;
                if (!craftStack.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)itemStack) || (spaceLeft = Math.min(craftMatrix.func_70297_j_(), craftStack.func_77976_d()) - craftStack.field_77994_a) <= 0) continue;
                ItemStack splitStack = itemStack.func_77979_a(Math.min(spaceLeft, itemStack.field_77994_a));
                craftStack.field_77994_a += splitStack.field_77994_a;
                if (itemStack.field_77994_a > 0) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (itemStack.field_77994_a > 0 && firstEmptySlot != -1) {
            ItemStack transferStack = itemStack.func_77979_a(Math.min(itemStack.field_77994_a, craftMatrix.func_70297_j_()));
            craftMatrix.func_70299_a(firstEmptySlot, transferStack);
            return true;
        }
        return false;
    }

    @Override
    public boolean canTransferFrom(EntityPlayer entityPlayer, Container container, Slot slot) {
        return slot.field_75224_c == entityPlayer.field_71071_by;
    }

    @Override
    public boolean canTransferFrom(EntityPlayer entityPlayer, Container container, int id, Slot slot) {
        return this.canTransferFrom(entityPlayer, container, slot);
    }

    @Override
    public void rotateGrid(EntityPlayer entityPlayer, Container container, IInventory craftMatrix) {
        this.rotateGrid(entityPlayer, container, craftMatrix, 0, craftMatrix.func_70302_i_(), rotationHandler);
    }

    @Override
    public void rotateGrid(EntityPlayer entityPlayer, Container container, IInventory craftMatrix, int start, int size, RotationHandler rotationHandler) {
        int i;
        InventoryBasic matrixClone = new InventoryBasic("", false, craftMatrix.func_70302_i_());
        for (i = start; i < start + size; ++i) {
            matrixClone.func_70299_a(i, craftMatrix.func_70301_a(i));
        }
        for (i = start; i < start + size; ++i) {
            if (rotationHandler.ignoreSlotId(i)) continue;
            craftMatrix.func_70299_a(rotationHandler.rotateSlotId(i, false), matrixClone.func_70301_a(i));
        }
        container.func_75142_b();
    }

    @Override
    public RotationHandler getRotationHandler() {
        return rotationHandler;
    }
}

