/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.coremod;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GuiScreenClassTransformer
implements IClassTransformer {
    public static final Logger logger = LogManager.getLogger();
    public static final String OBF_CLASS = "bdw";
    public static final String MCP_CLASS = "net.minecraft.client.gui.GuiScreen";
    public static final String SRG_METHOD = "func_146274_d";
    public static final String MCP_METHOD = "handleMouseInput";
    public static final String METHOD_DESC = "()V";

    public byte[] transform(String className, String transformedClassName, byte[] bytes) {
        String methodName;
        if (className.equals(OBF_CLASS)) {
            methodName = SRG_METHOD;
        } else if (className.equals(MCP_CLASS)) {
            methodName = MCP_METHOD;
        } else {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(METHOD_DESC)) continue;
            logger.info("CraftingTweaks will now patch {} in {}...", new Object[]{methodName, className});
            MethodNode mn = new MethodNode();
            Label notClicked = new Label();
            mn.visitVarInsn(21, 1);
            mn.visitVarInsn(21, 2);
            mn.visitVarInsn(21, 3);
            mn.visitMethodInsn(184, "net/blay09/mods/craftingtweaks/CraftingTweaks", "onGuiClick", "(III)Z", false);
            mn.visitJumpInsn(153, notClicked);
            mn.visitInsn(177);
            mn.visitLabel(notClicked);
            AbstractInsnNode insertAfter = null;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode node = method.instructions.get(i);
                if (!(node instanceof VarInsnNode) || node.getOpcode() != 54 || ((VarInsnNode)node).var != 3) continue;
                insertAfter = node;
                break;
            }
            if (insertAfter != null) {
                method.instructions.insert(insertAfter, mn.instructions);
                logger.info("CraftingTweaks successfully patched {} in {}!", new Object[]{methodName, className});
                continue;
            }
            logger.warn("CraftingTweaks failed to patch {0}::{1} ({2} not found) - transfering into crafting grids will not work!", new Object[]{className, methodName, "ISTORE 3"});
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

