/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.block;

import com.darkona.adventurebackpack.block.BlockAdventureBackpack;
import com.darkona.adventurebackpack.block.BlockSleepingBag;
import com.darkona.adventurebackpack.common.BackpackAbilities;
import com.darkona.adventurebackpack.common.IInventoryAdventureBackpack;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.init.ModItems;
import com.darkona.adventurebackpack.inventory.InventoryActions;
import com.darkona.adventurebackpack.inventory.SlotTool;
import com.darkona.adventurebackpack.item.ItemAdventureBackpack;
import com.darkona.adventurebackpack.util.BackpackUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidTank;

public class TileAdventureBackpack
extends TileEntity
implements IInventoryAdventureBackpack {
    public ItemStack[] inventory;
    private FluidTank leftTank = new FluidTank(4000);
    private FluidTank rightTank = new FluidTank(4000);
    public boolean sleepingBagDeployed = false;
    private boolean special;
    private int sbdir;
    private int sbx;
    private int sby;
    private int sbz;
    private int checkTime = 0;
    private String colorName;
    private int lastTime;
    private int luminosity;
    private NBTTagCompound extendedProperties;

    public int getLuminosity() {
        return this.luminosity;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int lastTime) {
        this.lastTime = lastTime;
    }

    @Override
    public NBTTagCompound getExtendedProperties() {
        return this.extendedProperties;
    }

    @Override
    public void setExtendedProperties(NBTTagCompound extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    public TileAdventureBackpack() {
        this.inventory = new ItemStack[45];
        this.setColorName("Standard");
        this.luminosity = 0;
        this.lastTime = 0;
        this.checkTime = 0;
        this.extendedProperties = new NBTTagCompound();
    }

    public boolean deploySleepingBag(EntityPlayer player, World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            return false;
        }
        BlockSleepingBag sleepingBag = ModBlocks.blockSleepingBag;
        if (world.func_147465_d(x, y, z, (Block)sleepingBag, meta, 3)) {
            world.func_72956_a((Entity)player, Block.field_149775_l.func_150496_b(), 0.5f, 1.0f);
            this.sbx = x--;
            this.sby = y;
            this.sbz = z++;
            this.sbdir = meta;
            switch (meta & 3) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++x;
                }
            }
            this.sleepingBagDeployed = world.func_147465_d(x, y, z, (Block)sleepingBag, meta + 8, 3);
            world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return this.sleepingBagDeployed;
        }
        return false;
    }

    public void setSleepingBagDeployed(boolean state) {
        this.sleepingBagDeployed = state;
    }

    public boolean removeSleepingBag(World world) {
        if (this.sleepingBagDeployed) {
            if (world.func_147439_a(this.sbx, this.sby, this.sbz) == ModBlocks.blockSleepingBag) {
                world.func_147480_a(this.sbx, this.sby, this.sbz, false);
                this.sleepingBagDeployed = false;
                this.func_70296_d();
                return true;
            }
        } else {
            this.sleepingBagDeployed = false;
            this.func_70296_d();
        }
        return false;
    }

    @Override
    public String getColorName() {
        return this.colorName;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public String func_145825_b() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public void setColorName(String string) {
        this.colorName = string;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public boolean isSBDeployed() {
        return this.sleepingBagDeployed;
    }

    @Override
    public boolean isSpecial() {
        return this.special;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.loadFromNBT(compound);
        this.sleepingBagDeployed = compound.func_74767_n("sleepingbag");
        this.sbx = compound.func_74762_e("sbx");
        this.sby = compound.func_74762_e("sby");
        this.sbz = compound.func_74762_e("sbz");
        this.sbdir = compound.func_74762_e("sbdir");
        this.luminosity = compound.func_74762_e("lumen");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.saveToNBT(compound);
        compound.func_74757_a("sleepingbag", this.sleepingBagDeployed);
        compound.func_74768_a("sbx", this.sbx);
        compound.func_74768_a("sby", this.sby);
        compound.func_74768_a("sbz", this.sbz);
        compound.func_74768_a("lumen", this.luminosity);
        compound.func_74768_a("sbdir", this.sbdir);
    }

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("backpackData")) {
            NBTTagCompound backpackData = compound.func_74775_l("backpackData");
            NBTTagList items = backpackData.func_150295_c("ABPItems", 10);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                byte slot = item.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
            }
            this.leftTank.readFromNBT(backpackData.func_74775_l("leftTank"));
            this.rightTank.readFromNBT(backpackData.func_74775_l("rightTank"));
            this.colorName = backpackData.func_74779_i("colorName");
            this.lastTime = backpackData.func_74762_e("lastTime");
            this.special = backpackData.func_74767_n("special");
            this.extendedProperties = backpackData.func_74775_l("extended");
        }
    }

    @Override
    public void saveToNBT(NBTTagCompound compound) {
        NBTTagCompound backpackData = new NBTTagCompound();
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        backpackData.func_74782_a("ABPItems", (NBTBase)items);
        backpackData.func_74778_a("colorName", this.colorName);
        backpackData.func_74768_a("lastTime", this.lastTime);
        backpackData.func_74757_a("special", BackpackAbilities.hasAbility(this.colorName));
        backpackData.func_74782_a("extended", (NBTBase)this.extendedProperties);
        backpackData.func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
        backpackData.func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("backpackData", (NBTBase)backpackData);
    }

    @Override
    public FluidTank[] getTanksArray() {
        FluidTank[] tanks = new FluidTank[]{this.leftTank, this.rightTank};
        return tanks;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
        this.func_70296_d();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAdventureBackpack || Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockAdventureBackpack) {
            return false;
        }
        if (slot == 6 || slot == 8) {
            return FluidContainerRegistry.isContainer((ItemStack)stack);
        }
        return slot != 0 && slot != 3 || SlotTool.isValidTool(stack);
    }

    public ItemStack func_70298_a(int i, int count) {
        ItemStack itemstack = this.func_70301_a(i);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(i, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
            }
        }
        this.func_70296_d();
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot == 41 || slot == 43 || slot == 42 || slot == 44) {
            return this.inventory[slot];
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        for (int i = 0; i < this.inventory.length; ++i) {
            if (i == 41 && this.inventory[i] != null) {
                this.updateTankSlots(this.getLeftTank(), i);
            }
            if (i != 43 || this.inventory[i] == null) continue;
            this.updateTankSlots(this.getRightTank(), i);
        }
        super.func_70296_d();
    }

    @Override
    public void setInventorySlotContentsNoSave(int slot, ItemStack itemstack) {
        if (slot > this.inventory.length) {
            return;
        }
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public ItemStack decrStackSizeNoSave(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.setInventorySlotContentsNoSave(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
            }
        }
        return stack;
    }

    @Override
    public boolean hasItem(Item item) {
        return InventoryActions.hasItem(this, item);
    }

    @Override
    public void consumeInventoryItem(Item item) {
        InventoryActions.consumeItemInInventory(this, item);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145845_h() {
        if (this.isSpecial() && !this.colorName.isEmpty()) {
            BackpackAbilities.backpackAbilities.executeAbility(null, this.field_145850_b, this);
        }
        if (this.checkTime == 0) {
            int lastLumen = this.luminosity;
            int left = this.leftTank.getFluid() != null ? this.leftTank.getFluid().getFluid().getLuminosity() : 0;
            int right = this.rightTank.getFluid() != null ? this.rightTank.getFluid().getFluid().getLuminosity() : 0;
            this.luminosity = Math.max(left, right);
            if (this.luminosity != lastLumen) {
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ModBlocks.blockBackpack, meta, 3);
                this.field_145850_b.func_72915_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.luminosity);
            }
            if (this.field_145850_b.func_147439_a(this.sbx, this.sby, this.sbz) != ModBlocks.blockSleepingBag) {
                this.sleepingBagDeployed = false;
            }
            this.checkTime = 20;
        } else {
            --this.checkTime;
        }
    }

    public void updateTankSlots(FluidTank tank, int slotIn) {
        InventoryActions.transferContainerTank(this, tank, slotIn);
    }

    @Override
    public void saveTanks(NBTTagCompound compound) {
        NBTTagCompound backpackData = compound.func_74764_b("backpackData") ? compound.func_74775_l("backpackData") : new NBTTagCompound();
        backpackData.func_74782_a("rightTank", (NBTBase)this.rightTank.writeToNBT(new NBTTagCompound()));
        backpackData.func_74782_a("leftTank", (NBTBase)this.leftTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("backpackData", (NBTBase)backpackData);
    }

    @Override
    public void loadTanks(NBTTagCompound compound) {
        if (compound.func_74764_b("backpackData")) {
            NBTTagCompound backpackData = compound.func_74775_l("backpackData");
            this.leftTank.readFromNBT(backpackData.func_74775_l("leftTank"));
            this.rightTank.readFromNBT(backpackData.func_74775_l("rightTank"));
        }
    }

    @Override
    public TileAdventureBackpack getTile() {
        return this;
    }

    @Override
    public ItemStack getParentItemStack() {
        return null;
    }

    private ItemStack transferToItemStack(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        this.saveToNBT(compound);
        stack.func_77982_d(compound);
        return stack;
    }

    public boolean equip(World world, EntityPlayer player, int x, int y, int z) {
        ItemStack stacky = new ItemStack((Item)ModItems.adventureBackpack, 1);
        this.transferToItemStack(stacky);
        this.removeSleepingBag(world);
        if (BackpackUtils.equipWearable(stacky, player) != BackpackUtils.reasons.SUCCESFUL) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:already.equipped", new Object[0]));
            if (!player.field_71071_by.func_70441_a(stacky)) {
                return this.drop(world, player, x, y, z);
            }
        }
        return true;
    }

    public boolean drop(World world, EntityPlayer player, int x, int y, int z) {
        this.removeSleepingBag(world);
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stacky = new ItemStack((Item)ModItems.adventureBackpack, 1);
        this.transferToItemStack(stacky);
        float spawnX = (float)x + world.field_73012_v.nextFloat();
        float spawnY = (float)y + world.field_73012_v.nextFloat();
        float spawnZ = (float)z + world.field_73012_v.nextFloat();
        EntityItem droppedItem = new EntityItem(world, (double)spawnX, (double)spawnY, (double)spawnZ, stacky);
        float mult = 0.05f;
        droppedItem.field_70159_w = (-0.5f + world.field_73012_v.nextFloat()) * mult;
        droppedItem.field_70181_x = (4.0f + world.field_73012_v.nextFloat()) * mult;
        droppedItem.field_70179_y = (-0.5f + world.field_73012_v.nextFloat()) * mult;
        return world.func_72838_d((Entity)droppedItem);
    }

    @Override
    public boolean updateTankSlots() {
        return false;
    }

    @Override
    public void dirtyTanks() {
    }

    @Override
    public void dirtyTime() {
    }

    @Override
    public void dirtyExtended() {
    }

    @Override
    public void dirtyInventory() {
    }
}

