/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.inventory;

import com.darkona.adventurebackpack.common.IInventoryAdventureBackpack;
import com.darkona.adventurebackpack.inventory.IWearableContainer;
import com.darkona.adventurebackpack.inventory.SlotBackpack;
import com.darkona.adventurebackpack.inventory.SlotFluid;
import com.darkona.adventurebackpack.inventory.SlotTool;
import com.darkona.adventurebackpack.item.ItemAdventureBackpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class ContainerBackpack
extends Container
implements IWearableContainer {
    public IInventoryAdventureBackpack inventory;
    public static byte SOURCE_TILE = 0;
    public static byte SOURCE_WEARING = 1;
    public static byte SOURCE_HOLDING = (byte)2;
    public byte source;
    public InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    public IInventory craftResult = new InventoryCraftResult();
    EntityPlayer player;
    private final int PLAYER_HOT_START = 0;
    private final int PLAYER_HOT_END = 8;
    private final int PLAYER_INV_START = 9;
    private final int PLAYER_INV_END = 35;
    private final int BACK_INV_START = 36;
    private final int BACK_INV_END = 74;
    private final int TOOL_START = 75;
    private final int TOOL_END = 76;
    private final int BUCKET_LEFT = 77;
    private final int BUCKET_RIGHT = 79;

    public ContainerBackpack(EntityPlayer player, IInventoryAdventureBackpack backpack, byte source) {
        this.player = player;
        this.inventory = backpack;
        this.makeSlots(player.field_71071_by);
        this.inventory.func_70295_k_();
        this.source = source;
    }

    public IInventoryAdventureBackpack getInventoryBackpack() {
        return this.inventory;
    }

    private void bindPlayerInventory(InventoryPlayer invPlayer) {
        int startX = 44;
        int startY = 125;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, startX + 18 * x, 183));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)invPlayer, x + y * 9 + 9, startX + 18 * x, startY + y * 18));
            }
        }
    }

    private void makeSlots(InventoryPlayer invPlayer) {
        int offsetY;
        int offsetX;
        int j;
        int i;
        this.bindPlayerInventory(invPlayer);
        int startX = 62;
        int startY = 7;
        int slot = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 8; ++j) {
                offsetX = startX + 18 * j;
                offsetY = startY + 18 * i;
                this.func_75146_a(new SlotBackpack(this.inventory, slot++, offsetX, offsetY));
            }
        }
        startY = 61;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 5; ++j) {
                offsetX = startX + 18 * j;
                offsetY = startY + 18 * i;
                this.func_75146_a(new SlotBackpack(this.inventory, slot++, offsetX, offsetY));
            }
        }
        this.func_75146_a(new SlotTool(this.inventory, 39, 44, 79));
        this.func_75146_a(new SlotTool(this.inventory, 40, 44, 97));
        this.func_75146_a(new SlotFluid(this.inventory, 41, 6, 7));
        this.func_75146_a(new SlotFluid(this.inventory, 42, 6, 37));
        this.func_75146_a(new SlotFluid(this.inventory, 43, 226, 7));
        this.func_75146_a(new SlotFluid(this.inventory, 44, 226, 37));
        startX = 152;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                offsetX = startX + 18 * x;
                offsetY = startY + 18 * y;
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, x + y * 3, offsetX, offsetY));
            }
        }
        this.func_75146_a((Slot)new SlotCrafting(invPlayer.field_70458_d, (IInventory)this.craftMatrix, this.craftResult, 0, 226, 97));
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_75130_a(IInventory par1IInventory) {
        this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(this.craftMatrix, this.player.field_70170_p));
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.source == SOURCE_WEARING) {
            this.field_75149_d.remove(player);
        }
        if (!player.field_70170_p.field_72995_K) {
            ItemStack itemstack;
            int i;
            for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
                itemstack = this.inventory.func_70304_b(i);
                if (itemstack == null) continue;
                this.inventory.func_70299_a(i, null);
                player.func_71019_a(itemstack, false);
            }
            for (i = 0; i < 9; ++i) {
                itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack == null) continue;
                player.func_71019_a(itemstack, false);
            }
        }
    }

    public ItemStack func_75144_a(int slot, int button, int flag, EntityPlayer player) {
        if (slot >= 0 && this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75211_c() == player.func_70694_bm() && this.source == SOURCE_HOLDING) {
            return null;
        }
        return super.func_75144_a(slot, button, flag, player);
    }

    protected boolean func_75135_a(ItemStack stack, int minSlot, int maxSlot, boolean direction) {
        ItemStack newItemStack;
        Slot slot;
        boolean changesMade = false;
        int slotInit = minSlot;
        if (direction) {
            slotInit = maxSlot - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!direction && slotInit < maxSlot || direction && slotInit >= minSlot)) {
                slot = (Slot)this.field_75151_b.get(slotInit);
                newItemStack = slot.func_75211_c();
                if (newItemStack != null && newItemStack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == newItemStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)newItemStack)) {
                    int newStackSize = newItemStack.field_77994_a + stack.field_77994_a;
                    if (newStackSize <= stack.func_77976_d()) {
                        stack.field_77994_a = 0;
                        newItemStack.field_77994_a = newStackSize;
                        slot.func_75218_e();
                        changesMade = true;
                    } else if (newItemStack.field_77994_a < stack.func_77976_d()) {
                        stack.field_77994_a -= stack.func_77976_d() - newItemStack.field_77994_a;
                        newItemStack.field_77994_a = stack.func_77976_d();
                        slot.func_75218_e();
                        changesMade = true;
                    }
                }
                if (direction) {
                    --slotInit;
                    continue;
                }
                ++slotInit;
            }
        }
        if (stack.field_77994_a > 0) {
            slotInit = direction ? maxSlot - 1 : minSlot;
            while (!direction && slotInit < maxSlot || direction && slotInit >= minSlot) {
                slot = (Slot)this.field_75151_b.get(slotInit);
                newItemStack = slot.func_75211_c();
                if (newItemStack == null) {
                    slot.func_75215_d(stack.func_77946_l());
                    slot.func_75218_e();
                    stack.field_77994_a = 0;
                    changesMade = true;
                    break;
                }
                if (direction) {
                    --slotInit;
                    continue;
                }
                ++slotInit;
            }
        }
        return changesMade;
    }

    public Slot func_75147_a(IInventory inv, int slot) {
        return super.func_75147_a(inv, slot);
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        if (this.source == SOURCE_WEARING) {
            this.refresh();
        }
        Slot slot = this.func_75139_a(i);
        ItemStack result = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            result = stack.func_77946_l();
            if (i >= 36 && !this.func_75135_a(stack, 0, 36, false)) {
                return null;
            }
            if (i < 36 && (SlotTool.isValidTool(stack) ? !this.func_75135_a(stack, 75, 77, false) && !this.func_75135_a(stack, 36, 75, false) : (SlotFluid.valid(stack) ? !this.func_75135_a(stack, 77, 78, false) && !this.func_75135_a(stack, 79, 80, false) && !this.func_75135_a(stack, 36, 75, false) : !(stack.func_77973_b() instanceof ItemAdventureBackpack) && !this.func_75135_a(stack, 36, 75, false)))) {
                return null;
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stack.field_77994_a == result.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stack);
        }
        return result;
    }

    public void func_75142_b() {
        this.refresh();
        super.func_75142_b();
    }

    @Override
    public void refresh() {
        this.inventory.func_70295_k_();
        this.func_75130_a((IInventory)this.craftMatrix);
    }
}

